/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class TerminalUtils {
    private static final Terminal TERMINAL_INSTANCE = TerminalUtils.createTerminal();
    private static final AtomicBoolean closed = new AtomicBoolean(false);

    private TerminalUtils() {
    }

    public static Terminal getTerminal() {
        Preconditions.checkState((!closed.get() ? 1 : 0) != 0, (Object)"Terminal is already closed");
        return TERMINAL_INSTANCE;
    }

    private static Terminal createTerminal() {
        try {
            return TerminalBuilder.builder().name("Trino").build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isRealTerminal(Terminal terminal) {
        return !"dumb".equals(terminal.getType()) && !"dumb-color".equals(terminal.getType());
    }

    public static boolean isRealTerminal() {
        return TerminalUtils.isRealTerminal(TerminalUtils.getTerminal());
    }

    public static int terminalWidth() {
        return TerminalUtils.getTerminal().getWidth();
    }

    public static Charset terminalEncoding() {
        return TerminalUtils.getTerminal().encoding();
    }

    public static void closeTerminal() {
        Terminal terminal = TerminalUtils.getTerminal();
        try {
            if (closed.compareAndSet(false, true)) {
                terminal.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

