/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.google.common.collect.ImmutableList;
import io.trino.cli.FormatUtils;
import io.trino.cli.OutputPrinter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class JsonPrinter
implements OutputPrinter {
    private final List<String> fieldNames;
    private final Writer writer;

    public JsonPrinter(List<String> fieldNames, Writer writer) {
        this.fieldNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldNames, "fieldNames is null"));
        this.writer = Objects.requireNonNull(writer, "writer is null");
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        JsonFactory jsonFactory = JsonPrinter.jsonFactory();
        try (JsonGenerator jsonGenerator = jsonFactory.createGenerator(this.writer);){
            jsonGenerator.setRootValueSeparator(null);
            for (List<?> row : rows) {
                jsonGenerator.writeStartObject();
                for (int position = 0; position < row.size(); ++position) {
                    String columnName = this.fieldNames.get(position);
                    jsonGenerator.writeObjectField(columnName, JsonPrinter.formatValue(row.get(position)));
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.writeRaw('\n');
                jsonGenerator.flush();
            }
        }
    }

    @Override
    public void finish() throws IOException {
        this.writer.flush();
    }

    private static Object formatValue(Object o) {
        if (o instanceof byte[]) {
            return FormatUtils.formatHexDump((byte[])o);
        }
        return o;
    }

    @SuppressModernizer
    private static JsonFactory jsonFactory() {
        return ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxNumberLength(Integer.MAX_VALUE).maxNestingDepth(Integer.MAX_VALUE).maxStringLength(Integer.MAX_VALUE).build())).build().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }
}

