/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.io.Closer;
import io.trino.cli.ClientOptions;
import io.trino.cli.InputHighlighter;
import io.trino.cli.InputParser;
import io.trino.cli.TerminalUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.widget.AutosuggestionWidgets;

public class InputReader
implements Closeable {
    private final LineReader reader;

    public InputReader(ClientOptions.EditingMode editingMode, Path historyFile, boolean disableAutoSuggestion, Completer ... completers) throws IOException {
        this.reader = LineReaderBuilder.builder().terminal(TerminalUtils.getTerminal()).variable("history-file", (Object)historyFile).variable("secondary-prompt-pattern", (Object)(TerminalUtils.isRealTerminal() ? InputReader.colored("%P -> ") : "")).variable("blink-matching-paren", (Object)0).parser((Parser)new InputParser()).highlighter((Highlighter)new InputHighlighter()).completer((Completer)new AggregateCompleter(completers)).build();
        this.reader.getKeyMaps().put("main", (KeyMap)this.reader.getKeyMaps().get(editingMode.getKeyMap()));
        this.reader.unsetOpt(LineReader.Option.HISTORY_TIMESTAMPED);
        if (!disableAutoSuggestion) {
            AutosuggestionWidgets autosuggestionWidgets = new AutosuggestionWidgets(this.reader);
            autosuggestionWidgets.enable();
        }
    }

    public String readLine(String prompt, String buffer) {
        return this.reader.readLine(InputReader.colored(prompt), null, buffer);
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> ((History)this.getHistory()).save());
            closer.register((Closeable)this.getTerminal());
        }
    }

    public History getHistory() {
        return this.reader.getHistory();
    }

    public Terminal getTerminal() {
        return this.reader.getTerminal();
    }

    private static String colored(String value) {
        return new AttributedString((CharSequence)value, AttributedStyle.DEFAULT.foreground(8)).toAnsi();
    }
}

