/*
 * Decompiled with CFR 0.152.
 */
package io.tpmn.suezx;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.webkit.WebView;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import io.tpmn.suezx.SuezXCreative;
import io.tpmn.suezx.SuezXLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SuezXUtils {
    protected static final String WEBVIEW_NAME = "tpmn_android";

    public static String getUserAgent(Context context) {
        return SuezXUtils.getUserAgent(context, false);
    }

    public static String getUserAgent(Context context, boolean encoded) {
        String userAgent = new WebView(context).getSettings().getUserAgentString();
        if (!encoded) {
            return userAgent;
        }
        String userAgentEnc = "";
        try {
            userAgentEnc = URLEncoder.encode(userAgent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)"UserAgent Error", (String)e.toString());
        }
        return userAgentEnc;
    }

    public static Map<String, Object> getRequestParams(Context context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        TelephonyManager teleMgr = (TelephonyManager)context.getSystemService("phone");
        String operatorName = teleMgr.getNetworkOperatorName();
        String operatorNameEnc = "";
        try {
            operatorNameEnc = URLEncoder.encode(operatorName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)"Operator Network Error", (String)e.toString());
        }
        params.put("cn", operatorNameEnc);
        String operator = teleMgr.getNetworkOperator();
        String mcc = "";
        String mnc = "";
        if (operator != null && !operator.isEmpty()) {
            try {
                mcc = operator.substring(0, 3);
                mnc = operator.substring(3, 5);
            }
            catch (NumberFormatException e) {
                Log.e((String)"TelephonyManager Error", (String)e.toString());
            }
        }
        params.put("mcc", mcc);
        params.put("mnc", mnc);
        String adId = "";
        int doNotTrack = 0;
        try {
            AdvertisingIdClient.Info adIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            adId = adIdInfo.getId();
            if (adIdInfo.isLimitAdTrackingEnabled()) {
                doNotTrack = 1;
            }
        }
        catch (Exception e) {
            Log.e((String)"AdId Error", (String)e.toString());
        }
        params.put("udid", adId);
        params.put("dnt", doNotTrack);
        int connectType = 0;
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            block4 : switch (networkInfo.getType()) {
                case 9: {
                    connectType = 1;
                    break;
                }
                case 1: {
                    connectType = 2;
                    break;
                }
                case 0: {
                    switch (networkInfo.getSubtype()) {
                        case 11: {
                            connectType = 4;
                            break block4;
                        }
                        case 15: {
                            connectType = 5;
                            break block4;
                        }
                        case 13: {
                            connectType = 6;
                            break block4;
                        }
                        case 20: {
                            connectType = 7;
                            break block4;
                        }
                    }
                    connectType = 3;
                }
            }
        }
        params.put("ct", connectType);
        String appPackageName = "";
        String appVersionName = "";
        try {
            appPackageName = context.getPackageName();
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(appPackageName, 0);
            appVersionName = pInfo.versionName;
        }
        catch (Exception e) {
            Log.e((String)"Package Error", (String)e.toString());
        }
        params.put("bundle", appPackageName);
        params.put("av", appVersionName);
        String language = context.getResources().getConfiguration().locale.getLanguage();
        params.put("locale", language);
        return params;
    }

    public static String getConnectType(Context paramContext) {
        ConnectivityManager connMgr = (ConnectivityManager)paramContext.getSystemService("connectivity");
        String result = "3G";
        try {
            ConnectivityManager cManager = (ConnectivityManager)paramContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = cManager.getActiveNetworkInfo();
            if (null != activeNetwork) {
                if (activeNetwork.getType() == 1) {
                    return "WIFI";
                }
                if (activeNetwork.getType() == 0) {
                    int networkType = activeNetwork.getSubtype();
                    switch (networkType) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            return "2G";
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            return "3G";
                        }
                        case 13: {
                            return "LTE";
                        }
                    }
                    return result;
                }
                return result;
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    public static boolean checkSelfPermission(String paramString, Context context) {
        boolean b = false;
        try {
            b = context.checkCallingOrSelfPermission(paramString) == 0;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return b;
    }

    public static boolean NVL(String param) {
        return param == null || "".equals(param);
    }

    public static String nvl(String value) {
        return SuezXUtils.nvl(value, "");
    }

    public static String nvl(String value, String defaultValue) {
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        return value;
    }

    public static boolean isWifiConnect(Context paramContext) {
        try {
            ConnectivityManager cManager = (ConnectivityManager)paramContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = cManager.getActiveNetworkInfo();
            if (null != activeNetwork) {
                return activeNetwork.getType() == 1;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static SuezXCreative parseJson(String str) {
        SuezXCreative creative = new SuezXCreative();
        try {
            JSONObject jObj = new JSONObject(str);
            int adHeight = jObj.getInt("adHeight");
            int adWidth = jObj.getInt("adWidth");
            String html = jObj.getString("html");
            creative.setAdHeight(adHeight);
            creative.setAdWidth(adWidth);
            creative.setHtml(html);
        }
        catch (JSONException e) {
            SuezXLogger.createLog(SuezXLogger.LogLevels.Debug, "suezXJsonParser", "Parsing error", e.toString());
        }
        return creative;
    }
}

