/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.DelegatingMutableBytes32;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes32;
import org.apache.tuweni.bytes.MutableBytes;

public interface MutableBytes32
extends MutableBytes,
Bytes32 {
    public static MutableBytes32 create() {
        return new MutableArrayWrappingBytes32(new byte[32]);
    }

    public static MutableBytes32 wrap(byte[] value) {
        Checks.checkNotNull(value);
        return new MutableArrayWrappingBytes32(value);
    }

    public static MutableBytes32 wrap(byte[] value, int offset) {
        Checks.checkNotNull(value);
        return new MutableArrayWrappingBytes32(value, offset);
    }

    public static MutableBytes32 wrap(MutableBytes value) {
        Checks.checkNotNull(value);
        if (value instanceof MutableBytes32) {
            return (MutableBytes32)value;
        }
        return DelegatingMutableBytes32.delegateTo(value);
    }

    public static MutableBytes32 wrap(MutableBytes value, int offset) {
        Checks.checkNotNull(value);
        if (value instanceof MutableBytes32) {
            return (MutableBytes32)value;
        }
        MutableBytes slice = value.mutableSlice(offset, 32);
        if (slice instanceof MutableBytes32) {
            return (MutableBytes32)slice;
        }
        return DelegatingMutableBytes32.delegateTo(slice);
    }
}

