/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import org.apache.tuweni.bytes.ArrayWrappingBytes;
import org.apache.tuweni.bytes.ArrayWrappingBytes32;
import org.apache.tuweni.bytes.BufferWrappingBytes;
import org.apache.tuweni.bytes.ByteBufWrappingBytes;
import org.apache.tuweni.bytes.ByteBufferWrappingBytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.BytesValues;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.ConcatenatedBytes;
import org.apache.tuweni.bytes.ConstantBytesValue;
import org.apache.tuweni.bytes.GuardedByteArrayBytes;
import org.apache.tuweni.bytes.MutableBytes;

public interface Bytes
extends Comparable<Bytes> {
    public static final Bytes EMPTY = Bytes.wrap(new byte[0]);

    public static Bytes wrap(byte[] value) {
        return Bytes.wrap(value, 0, value.length);
    }

    public static Bytes wrap(byte[] value, int offset, int length) {
        Checks.checkNotNull(value);
        if (length == 32) {
            return new ArrayWrappingBytes32(value, offset);
        }
        return new ArrayWrappingBytes(value, offset, length);
    }

    public static Bytes secure(byte[] value) {
        return Bytes.secure(value, 0, value.length);
    }

    public static Bytes secure(byte[] value, int offset, int length) {
        Checks.checkNotNull(value);
        return new GuardedByteArrayBytes(value, offset, length);
    }

    public static Bytes wrap(Bytes ... values) {
        return ConcatenatedBytes.wrap(values);
    }

    public static Bytes wrap(List<Bytes> values) {
        return ConcatenatedBytes.wrap(values);
    }

    public static Bytes concatenate(List<Bytes> values) {
        int size;
        if (values.size() == 0) {
            return EMPTY;
        }
        try {
            size = values.stream().mapToInt(Bytes::size).reduce(0, Math::addExact);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Combined length of values is too long (> Integer.MAX_VALUE)");
        }
        MutableBytes result = MutableBytes.create(size);
        int offset = 0;
        for (Bytes value : values) {
            value.copyTo(result, offset);
            offset += value.size();
        }
        return result;
    }

    public static Bytes concatenate(Bytes ... values) {
        int size;
        if (values.length == 0) {
            return EMPTY;
        }
        try {
            size = Arrays.stream(values).mapToInt(Bytes::size).reduce(0, Math::addExact);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Combined length of values is too long (> Integer.MAX_VALUE)");
        }
        MutableBytes result = MutableBytes.create(size);
        int offset = 0;
        for (Bytes value : values) {
            value.copyTo(result, offset);
            offset += value.size();
        }
        return result;
    }

    public static Bytes wrapBuffer(Buffer buffer) {
        Checks.checkNotNull(buffer);
        if (buffer.length() == 0) {
            return EMPTY;
        }
        return new BufferWrappingBytes(buffer);
    }

    public static Bytes wrapBuffer(Buffer buffer, int offset, int size) {
        Checks.checkNotNull(buffer);
        if (size == 0) {
            return EMPTY;
        }
        return new BufferWrappingBytes(buffer, offset, size);
    }

    public static Bytes wrapByteBuf(ByteBuf byteBuf) {
        Checks.checkNotNull(byteBuf);
        if (byteBuf.capacity() == 0) {
            return EMPTY;
        }
        return new ByteBufWrappingBytes(byteBuf);
    }

    public static Bytes wrapByteBuf(ByteBuf byteBuf, int offset, int size) {
        Checks.checkNotNull(byteBuf);
        if (size == 0) {
            return EMPTY;
        }
        return new ByteBufWrappingBytes(byteBuf, offset, size);
    }

    public static Bytes wrapByteBuffer(ByteBuffer byteBuffer) {
        Checks.checkNotNull(byteBuffer);
        if (byteBuffer.limit() == 0) {
            return EMPTY;
        }
        return new ByteBufferWrappingBytes(byteBuffer);
    }

    public static Bytes wrapByteBuffer(ByteBuffer byteBuffer, int offset, int size) {
        Checks.checkNotNull(byteBuffer);
        if (size == 0) {
            return EMPTY;
        }
        return new ByteBufferWrappingBytes(byteBuffer, offset, size);
    }

    public static Bytes of(byte ... bytes) {
        return Bytes.wrap(bytes);
    }

    public static Bytes of(int ... bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            Checks.checkArgument(b == ((byte)b & 0xFF), "%sth value %s does not fit a byte", i + 1, b);
            result[i] = (byte)b;
        }
        return Bytes.wrap(result);
    }

    public static Bytes ofUnsignedShort(int value) {
        return Bytes.ofUnsignedShort(value, ByteOrder.BIG_ENDIAN);
    }

    public static Bytes ofUnsignedShort(int value, ByteOrder order) {
        Checks.checkArgument(value >= 0 && value <= 65535, "Value %s cannot be represented as an unsigned short (it is negative or too big)", value);
        byte[] res = new byte[2];
        if (order == ByteOrder.BIG_ENDIAN) {
            res[0] = (byte)(value >> 8 & 0xFF);
            res[1] = (byte)(value & 0xFF);
        } else {
            res[0] = (byte)(value & 0xFF);
            res[1] = (byte)(value >> 8 & 0xFF);
        }
        return Bytes.wrap(res);
    }

    public static Bytes ofUnsignedInt(long value) {
        return Bytes.ofUnsignedInt(value, ByteOrder.BIG_ENDIAN);
    }

    public static Bytes ofUnsignedInt(long value, ByteOrder order) {
        Checks.checkArgument(value >= 0L && value <= 0xFFFFFFFFL, "Value %s cannot be represented as an unsigned int (it is negative or too big)", value);
        byte[] res = new byte[4];
        if (order == ByteOrder.BIG_ENDIAN) {
            res[0] = (byte)(value >> 24 & 0xFFL);
            res[1] = (byte)(value >> 16 & 0xFFL);
            res[2] = (byte)(value >> 8 & 0xFFL);
            res[3] = (byte)(value & 0xFFL);
        } else {
            res[0] = (byte)(value & 0xFFL);
            res[1] = (byte)(value >> 8 & 0xFFL);
            res[2] = (byte)(value >> 16 & 0xFFL);
            res[3] = (byte)(value >> 24 & 0xFFL);
        }
        return Bytes.wrap(res);
    }

    public static Bytes ofUnsignedLong(long value) {
        return Bytes.ofUnsignedLong(value, ByteOrder.BIG_ENDIAN);
    }

    public static Bytes ofUnsignedLong(long value, ByteOrder order) {
        byte[] res = new byte[8];
        if (order == ByteOrder.BIG_ENDIAN) {
            res[0] = (byte)(value >> 56 & 0xFFL);
            res[1] = (byte)(value >> 48 & 0xFFL);
            res[2] = (byte)(value >> 40 & 0xFFL);
            res[3] = (byte)(value >> 32 & 0xFFL);
            res[4] = (byte)(value >> 24 & 0xFFL);
            res[5] = (byte)(value >> 16 & 0xFFL);
            res[6] = (byte)(value >> 8 & 0xFFL);
            res[7] = (byte)(value & 0xFFL);
        } else {
            res[0] = (byte)(value & 0xFFL);
            res[1] = (byte)(value >> 8 & 0xFFL);
            res[2] = (byte)(value >> 16 & 0xFFL);
            res[3] = (byte)(value >> 24 & 0xFFL);
            res[4] = (byte)(value >> 32 & 0xFFL);
            res[5] = (byte)(value >> 40 & 0xFFL);
            res[6] = (byte)(value >> 48 & 0xFFL);
            res[7] = (byte)(value >> 56 & 0xFFL);
        }
        return Bytes.wrap(res);
    }

    public static Bytes minimalBytes(long value) {
        if (value == 0L) {
            return EMPTY;
        }
        int zeros = Long.numberOfLeadingZeros(value);
        int resultBytes = 8 - zeros / 8;
        byte[] result = new byte[resultBytes];
        int shift = 0;
        for (int i = 0; i < resultBytes; ++i) {
            result[resultBytes - i - 1] = (byte)(value >> shift & 0xFFL);
            shift += 8;
        }
        return Bytes.wrap(result);
    }

    public static Bytes fromHexStringLenient(CharSequence str) {
        Checks.checkNotNull(str);
        return BytesValues.fromHexString(str, -1, true);
    }

    public static Bytes fromHexStringLenient(CharSequence str, int destinationSize) {
        Checks.checkNotNull(str);
        Checks.checkArgument(destinationSize >= 0, "Invalid negative destination size %s", destinationSize);
        return BytesValues.fromHexString(str, destinationSize, true);
    }

    public static Bytes fromHexString(CharSequence str) {
        Checks.checkNotNull(str);
        return BytesValues.fromHexString(str, -1, false);
    }

    public static Bytes fromHexString(CharSequence str, int destinationSize) {
        Checks.checkNotNull(str);
        Checks.checkArgument(destinationSize >= 0, "Invalid negative destination size %s", destinationSize);
        return BytesValues.fromHexString(str, destinationSize, false);
    }

    public static Bytes fromBase64String(CharSequence str) {
        return Bytes.wrap(Base64.getDecoder().decode(str.toString()));
    }

    public static Bytes random(int size) {
        return Bytes.random(size, new SecureRandom());
    }

    public static Bytes random(int size, Random generator) {
        byte[] array = new byte[size];
        generator.nextBytes(array);
        return Bytes.wrap(array);
    }

    public static Bytes repeat(byte b, int size) {
        return new ConstantBytesValue(b, size);
    }

    public static Bytes32[] segment(Bytes bytes) {
        int segments = (int)Math.ceil((double)bytes.size() / 32.0);
        Bytes32[] result = new Bytes32[segments];
        for (int i = 0; i < segments; ++i) {
            result[i] = Bytes32.rightPad(bytes.slice(i * 32, Math.min(32, bytes.size() - i * 32)));
        }
        return result;
    }

    public int size();

    public byte get(int var1);

    default public int getInt(int i) {
        return this.getInt(i, ByteOrder.BIG_ENDIAN);
    }

    default public int getInt(int i, ByteOrder order) {
        int size = this.size();
        Checks.checkElementIndex(i, size);
        if (i > size - 4) {
            throw new IndexOutOfBoundsException(String.format("Value of size %s has not enough bytes to read a 4 bytes int from index %s", size, i));
        }
        int value = 0;
        if (order == ByteOrder.BIG_ENDIAN) {
            value |= (this.get(i) & 0xFF) << 24;
            value |= (this.get(i + 1) & 0xFF) << 16;
            value |= (this.get(i + 2) & 0xFF) << 8;
            value |= this.get(i + 3) & 0xFF;
        } else {
            value |= (this.get(i + 3) & 0xFF) << 24;
            value |= (this.get(i + 2) & 0xFF) << 16;
            value |= (this.get(i + 1) & 0xFF) << 8;
            value |= this.get(i) & 0xFF;
        }
        return value;
    }

    default public int toInt() {
        return this.toInt(ByteOrder.BIG_ENDIAN);
    }

    default public int toInt(ByteOrder order) {
        int size = this.size();
        Checks.checkArgument(size <= 4, "Value of size %s has more than 4 bytes", this.size());
        if (size == 0) {
            return 0;
        }
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = size;
            int value = this.get(--i) & 0xFF;
            if (i == 0) {
                return value;
            }
            value |= (this.get(--i) & 0xFF) << 8;
            if (i == 0) {
                return value;
            }
            value |= (this.get(--i) & 0xFF) << 16;
            if (i == 0) {
                return value;
            }
            return value | (this.get(--i) & 0xFF) << 24;
        }
        int i = 0;
        int value = this.get(i) & 0xFF;
        if (++i == size) {
            return value;
        }
        value |= (this.get(i++) & 0xFF) << 8;
        if (i == size) {
            return value;
        }
        value |= (this.get(i++) & 0xFF) << 16;
        if (i == size) {
            return value;
        }
        return value | (this.get(i) & 0xFF) << 24;
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public long getLong(int i) {
        return this.getLong(i, ByteOrder.BIG_ENDIAN);
    }

    default public long getLong(int i, ByteOrder order) {
        int size = this.size();
        Checks.checkElementIndex(i, size);
        if (i > size - 8) {
            throw new IndexOutOfBoundsException(String.format("Value of size %s has not enough bytes to read a 8 bytes long from index %s", size, i));
        }
        long value = 0L;
        if (order == ByteOrder.BIG_ENDIAN) {
            value |= ((long)this.get(i) & 0xFFL) << 56;
            value |= ((long)this.get(i + 1) & 0xFFL) << 48;
            value |= ((long)this.get(i + 2) & 0xFFL) << 40;
            value |= ((long)this.get(i + 3) & 0xFFL) << 32;
            value |= ((long)this.get(i + 4) & 0xFFL) << 24;
            value |= ((long)this.get(i + 5) & 0xFFL) << 16;
            value |= ((long)this.get(i + 6) & 0xFFL) << 8;
            value |= (long)this.get(i + 7) & 0xFFL;
        } else {
            value |= ((long)this.get(i + 7) & 0xFFL) << 56;
            value |= ((long)this.get(i + 6) & 0xFFL) << 48;
            value |= ((long)this.get(i + 5) & 0xFFL) << 40;
            value |= ((long)this.get(i + 4) & 0xFFL) << 32;
            value |= ((long)this.get(i + 3) & 0xFFL) << 24;
            value |= ((long)this.get(i + 2) & 0xFFL) << 16;
            value |= ((long)this.get(i + 1) & 0xFFL) << 8;
            value |= (long)this.get(i) & 0xFFL;
        }
        return value;
    }

    default public long toLong() {
        return this.toLong(ByteOrder.BIG_ENDIAN);
    }

    default public long toLong(ByteOrder order) {
        int size = this.size();
        Checks.checkArgument(size <= 8, "Value of size %s has more than 8 bytes", this.size());
        if (size == 0) {
            return 0L;
        }
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = size;
            long value = (long)this.get(--i) & 0xFFL;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 8;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 16;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 24;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 32;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 40;
            if (i == 0) {
                return value;
            }
            value |= ((long)this.get(--i) & 0xFFL) << 48;
            if (i == 0) {
                return value;
            }
            return value | ((long)this.get(--i) & 0xFFL) << 56;
        }
        int i = 0;
        long value = (long)this.get(i) & 0xFFL;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 8;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 16;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 24;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 32;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 40;
        if (++i == size) {
            return value;
        }
        value |= ((long)this.get(i) & 0xFFL) << 48;
        if (++i == size) {
            return value;
        }
        return value | ((long)this.get(i) & 0xFFL) << 56;
    }

    default public BigInteger toBigInteger() {
        return this.toBigInteger(ByteOrder.BIG_ENDIAN);
    }

    default public BigInteger toBigInteger(ByteOrder order) {
        if (this.size() == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(order == ByteOrder.BIG_ENDIAN ? this.toArrayUnsafe() : this.reverse().toArrayUnsafe());
    }

    default public BigInteger toUnsignedBigInteger() {
        return this.toUnsignedBigInteger(ByteOrder.BIG_ENDIAN);
    }

    default public BigInteger toUnsignedBigInteger(ByteOrder order) {
        return new BigInteger(1, order == ByteOrder.BIG_ENDIAN ? this.toArrayUnsafe() : this.reverse().toArrayUnsafe());
    }

    default public boolean isZero() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i) == 0) continue;
            return false;
        }
        return true;
    }

    default public boolean hasLeadingZero() {
        return this.size() > 0 && (this.get(0) & 0x80) == 0;
    }

    default public int numberOfLeadingZeros() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte b = this.get(i);
            if (b == 0) continue;
            return i * 8 + Integer.numberOfLeadingZeros(b & 0xFF) - 24;
        }
        return size * 8;
    }

    default public boolean hasLeadingZeroByte() {
        return this.size() > 0 && this.get(0) == 0;
    }

    default public int numberOfLeadingZeroBytes() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.get(i) == 0) continue;
            return i;
        }
        return size;
    }

    default public int numberOfTrailingZeroBytes() {
        int size;
        for (int i = size = this.size(); i >= 1; --i) {
            if (this.get(i - 1) == 0) continue;
            return size - i;
        }
        return size;
    }

    default public int bitLength() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            byte b = this.get(i);
            if (b == 0) continue;
            return size * 8 - i * 8 - (Integer.numberOfLeadingZeros(b & 0xFF) - 24);
        }
        return 0;
    }

    default public Bytes and(Bytes other) {
        return this.and(other, MutableBytes.create(Math.max(this.size(), other.size())));
    }

    default public <T extends MutableBytes> T and(Bytes other, T result) {
        Checks.checkNotNull(other);
        Checks.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        int offsetOther = rSize - other.size();
        for (int i = 0; i < rSize; ++i) {
            byte b1 = i < offsetSelf ? (byte)0 : this.get(i - offsetSelf);
            byte b2 = i < offsetOther ? (byte)0 : other.get(i - offsetOther);
            result.set(i, (byte)(b1 & b2));
        }
        return result;
    }

    default public Bytes or(Bytes other) {
        return this.or(other, MutableBytes.create(Math.max(this.size(), other.size())));
    }

    default public <T extends MutableBytes> T or(Bytes other, T result) {
        Checks.checkNotNull(other);
        Checks.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        int offsetOther = rSize - other.size();
        for (int i = 0; i < rSize; ++i) {
            byte b1 = i < offsetSelf ? (byte)0 : this.get(i - offsetSelf);
            byte b2 = i < offsetOther ? (byte)0 : other.get(i - offsetOther);
            result.set(i, (byte)(b1 | b2));
        }
        return result;
    }

    default public Bytes xor(Bytes other) {
        return this.xor(other, MutableBytes.create(Math.max(this.size(), other.size())));
    }

    default public <T extends MutableBytes> T xor(Bytes other, T result) {
        Checks.checkNotNull(other);
        Checks.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        int offsetOther = rSize - other.size();
        for (int i = 0; i < rSize; ++i) {
            byte b1 = i < offsetSelf ? (byte)0 : this.get(i - offsetSelf);
            byte b2 = i < offsetOther ? (byte)0 : other.get(i - offsetOther);
            result.set(i, (byte)(b1 ^ b2));
        }
        return result;
    }

    default public Bytes not() {
        return this.not(MutableBytes.create(this.size()));
    }

    default public <T extends MutableBytes> T not(T result) {
        Checks.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        for (int i = 0; i < rSize; ++i) {
            byte b1 = i < offsetSelf ? (byte)0 : this.get(i - offsetSelf);
            result.set(i, ~b1);
        }
        return result;
    }

    default public Bytes shiftRight(int distance) {
        return this.shiftRight(distance, MutableBytes.create(this.size()));
    }

    default public <T extends MutableBytes> T shiftRight(int distance, T result) {
        Checks.checkNotNull(result);
        int rSize = result.size();
        int offsetSelf = rSize - this.size();
        int d = distance / 8;
        int s = distance % 8;
        int resIdx = rSize - 1;
        for (int i = rSize - 1 - d; i >= 0; --i) {
            byte res;
            if (i < offsetSelf) {
                res = 0;
            } else {
                int selfIdx = i - offsetSelf;
                int leftSide = (this.get(selfIdx) & 0xFF) >>> s;
                int rightSide = selfIdx == 0 ? 0 : this.get(selfIdx - 1) << 8 - s;
                res = (byte)(leftSide | rightSide);
            }
            result.set(resIdx--, res);
        }
        while (resIdx >= 0) {
            result.set(resIdx, (byte)0);
            --resIdx;
        }
        return result;
    }

    default public Bytes shiftLeft(int distance) {
        return this.shiftLeft(distance, MutableBytes.create(this.size()));
    }

    default public <T extends MutableBytes> T shiftLeft(int distance, T result) {
        Checks.checkNotNull(result);
        int size = this.size();
        int rSize = result.size();
        int offsetSelf = rSize - size;
        int d = distance / 8;
        int s = distance % 8;
        int resIdx = 0;
        for (int i = d; i < rSize; ++i) {
            byte res;
            if (i < offsetSelf) {
                res = 0;
            } else {
                int selfIdx = i - offsetSelf;
                int leftSide = this.get(selfIdx) << s;
                int rightSide = selfIdx == size - 1 ? 0 : (this.get(selfIdx + 1) & 0xFF) >>> 8 - s;
                res = (byte)(leftSide | rightSide);
            }
            result.set(resIdx++, res);
        }
        while (resIdx < rSize) {
            result.set(resIdx, (byte)0);
            ++resIdx;
        }
        return result;
    }

    default public Bytes slice(int i) {
        if (i == 0) {
            return this;
        }
        int size = this.size();
        if (i >= size) {
            return EMPTY;
        }
        return this.slice(i, size - i);
    }

    public Bytes slice(int var1, int var2);

    public Bytes copy();

    public MutableBytes mutableCopy();

    default public void copyTo(MutableBytes destination) {
        Checks.checkNotNull(destination);
        Checks.checkArgument(destination.size() == this.size(), "Cannot copy %s bytes to destination of non-equal size %s", this.size(), destination.size());
        this.copyTo(destination, 0);
    }

    default public void copyTo(MutableBytes destination, int destinationOffset) {
        Checks.checkNotNull(destination);
        int size = this.size();
        if (size == 0) {
            return;
        }
        Checks.checkElementIndex(destinationOffset, destination.size());
        Checks.checkArgument(destination.size() - destinationOffset >= size, "Cannot copy %s bytes, destination has only %s bytes from index %s", size, destination.size() - destinationOffset, destinationOffset);
        destination.set(destinationOffset, this);
    }

    default public void appendTo(ByteBuffer byteBuffer) {
        Checks.checkNotNull(byteBuffer);
        for (int i = 0; i < this.size(); ++i) {
            byteBuffer.put(this.get(i));
        }
    }

    default public void appendTo(Buffer buffer) {
        Checks.checkNotNull(buffer);
        for (int i = 0; i < this.size(); ++i) {
            buffer.appendByte(this.get(i));
        }
    }

    default public <T extends Appendable> T appendHexTo(T appendable) {
        try {
            appendable.append(this.toFastHex(false));
            return appendable;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public String toFastHex(boolean prefix) {
        int offset = prefix ? 2 : 0;
        int resultSize = this.size() * 2 + offset;
        char[] result = new char[resultSize];
        if (prefix) {
            result[0] = 48;
            result[1] = 120;
        }
        for (int i = 0; i < this.size(); ++i) {
            byte b = this.get(i);
            int pos = i * 2;
            result[pos + offset] = "0123456789abcdef".charAt(b >> 4 & 0xF);
            result[pos + offset + 1] = "0123456789abcdef".charAt(b & 0xF);
        }
        return new String(result);
    }

    default public int commonPrefixLength(Bytes other) {
        int i;
        Checks.checkNotNull(other);
        int ourSize = this.size();
        int otherSize = other.size();
        for (i = 0; i < ourSize && i < otherSize && this.get(i) == other.get(i); ++i) {
        }
        return i;
    }

    default public Bytes commonPrefix(Bytes other) {
        return this.slice(0, this.commonPrefixLength(other));
    }

    default public Bytes trimLeadingZeros() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.get(i) == 0) continue;
            return this.slice(i);
        }
        return EMPTY;
    }

    default public Bytes trimTrailingZeros() {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            if (this.get(i) == 0) continue;
            return this.slice(0, i + 1);
        }
        return EMPTY;
    }

    default public void update(MessageDigest digest) {
        Checks.checkNotNull(digest);
        digest.update(this.toArrayUnsafe());
    }

    default public Bytes reverse() {
        byte[] reverse = new byte[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            reverse[this.size() - i - 1] = this.get(i);
        }
        return Bytes.wrap(reverse);
    }

    default public byte[] toArray() {
        return this.toArray(ByteOrder.BIG_ENDIAN);
    }

    default public byte[] toArray(ByteOrder byteOrder) {
        int size = this.size();
        byte[] array = new byte[size];
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < size; ++i) {
                array[i] = this.get(i);
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                array[this.size() - i - 1] = this.get(i);
            }
        }
        return array;
    }

    default public byte[] toArrayUnsafe() {
        return this.toArray();
    }

    public String toString();

    default public String toHexString() {
        return this.toFastHex(true);
    }

    default public String toUnprefixedHexString() {
        return this.toFastHex(false);
    }

    default public String toEllipsisHexString() {
        int pos;
        byte b;
        int i;
        int size = this.size();
        if (size < 6) {
            return this.toHexString();
        }
        char[] result = new char[12];
        result[0] = 48;
        result[1] = 120;
        for (i = 0; i < 2; ++i) {
            b = this.get(i);
            pos = i * 2 + 2;
            result[pos] = "0123456789abcdef".charAt(b >> 4 & 0xF);
            result[pos + 1] = "0123456789abcdef".charAt(b & 0xF);
        }
        result[6] = 46;
        result[7] = 46;
        for (i = 0; i < 2; ++i) {
            b = this.get(i + size - 2);
            pos = i * 2 + 8;
            result[pos] = "0123456789abcdef".charAt(b >> 4 & 0xF);
            result[pos + 1] = "0123456789abcdef".charAt(b & 0xF);
        }
        return new String(result);
    }

    default public String toShortHexString() {
        int i;
        String hex = this.toFastHex(false);
        for (i = 0; i < hex.length() && hex.charAt(i) == '0'; ++i) {
        }
        return "0x" + hex.substring(i);
    }

    default public String toQuantityHexString() {
        int i;
        if (EMPTY.equals(this)) {
            return "0x0";
        }
        String hex = this.toFastHex(false);
        for (i = 0; i < hex.length() - 1 && hex.charAt(i) == '0'; ++i) {
        }
        return "0x" + hex.substring(i);
    }

    default public String toBase64String() {
        return Base64.getEncoder().encodeToString(this.toArrayUnsafe());
    }

    @Override
    default public int compareTo(Bytes b) {
        Checks.checkNotNull(b);
        int bitLength = this.bitLength();
        int sizeCmp = Integer.compare(bitLength, b.bitLength());
        if (sizeCmp != 0) {
            return sizeCmp;
        }
        if (bitLength == 0) {
            return 0;
        }
        for (int i = 0; i < this.size(); ++i) {
            int cmp = Integer.compare(this.get(i) & 0xFF, b.get(i) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

