/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import io.vertx.core.buffer.Buffer;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableBytes;

class BufferWrappingBytes
extends AbstractBytes {
    protected final Buffer buffer;

    BufferWrappingBytes(Buffer buffer) {
        this.buffer = buffer;
    }

    BufferWrappingBytes(Buffer buffer, int offset, int length) {
        Checks.checkArgument(length >= 0, "Invalid negative length", new Object[0]);
        int bufferLength = buffer.length();
        Checks.checkElementIndex(offset, bufferLength + 1);
        Checks.checkArgument(offset + length <= bufferLength, "Provided length %s is too big: the buffer has size %s and has only %s bytes from %s", length, bufferLength, bufferLength - offset, offset);
        this.buffer = offset == 0 && length == bufferLength ? buffer : buffer.slice(offset, offset + length);
    }

    @Override
    public int size() {
        return this.buffer.length();
    }

    @Override
    public byte get(int i) {
        return this.buffer.getByte(i);
    }

    @Override
    public int getInt(int i) {
        return this.buffer.getInt(i);
    }

    @Override
    public long getLong(int i) {
        return this.buffer.getLong(i);
    }

    @Override
    public Bytes slice(int i, int length) {
        int size = this.buffer.length();
        if (i == 0 && length == size) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Checks.checkElementIndex(i, size);
        Checks.checkArgument(i + length <= size, "Provided length %s is too big: the value has size %s and has only %s bytes from %s", length, size, size - i, i);
        return new BufferWrappingBytes(this.buffer.slice(i, i + length));
    }

    @Override
    public Bytes copy() {
        return Bytes.wrap(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return MutableBytes.wrap(this.toArray());
    }

    @Override
    public void appendTo(Buffer buffer) {
        buffer.appendBuffer(this.buffer);
    }

    @Override
    public byte[] toArray() {
        return this.buffer.getBytes();
    }
}

