/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import io.tesseractgroup.reactor.Core;
import io.tesseractgroup.reactornavigation.AlertButton;
import io.tesseractgroup.reactornavigation.NavContainerState;
import io.tesseractgroup.reactornavigation.NavigationCommand;
import io.tesseractgroup.reactornavigation.NavigationEvent;
import io.tesseractgroup.reactornavigation.NavigationStateProtocol;
import io.tesseractgroup.reactornavigation.R;
import io.tesseractgroup.reactornavigation.ReactorActivity$NavigationIconState$WhenMappings;
import io.tesseractgroup.reactornavigation.ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0;
import io.tesseractgroup.reactornavigation.ReactorFragment;
import io.tesseractgroup.reactornavigation.ReactorNavigation;
import io.tesseractgroup.reactornavigation.ReactorTransitions;
import io.tesseractgroup.reactornavigation.ReactorView;
import io.tesseractgroup.reactornavigation.ReactorViewState;
import io.tesseractgroup.reactornavigation.TabContainerState;
import io.tesseractgroup.reactornavigation.ViewContainerState;
import io.tesseractgroup.reactornavigation.VisibleViewChanged;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0001EB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0018\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0013H\u0002J\b\u0010.\u001a\u00020$H\u0016J\u0012\u0010/\u001a\u00020$2\b\u00100\u001a\u0004\u0018\u000101H\u0014J\u0012\u00102\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020$H\u0014J\u0012\u00106\u001a\u00020\b2\b\u00107\u001a\u0004\u0018\u000108H\u0016J\b\u00109\u001a\u00020$H\u0014J\b\u0010:\u001a\u00020$H\u0014J\u0010\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u000201H\u0014J4\u0010=\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\n\u0010>\u001a\u00060?j\u0002`@2\u000e\u0010A\u001a\n\u0018\u00010?j\u0004\u0018\u0001`@2\u0006\u0010B\u001a\u00020\u000fH\u0002J\u0018\u0010C\u001a\u00020$2\u0006\u0010D\u001a\u00020\r2\u0006\u0010B\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "layoutId", "", "toolbarId", "reactorContainerId", "(III)V", "activityCreated", "", "lastView", "Lio/tesseractgroup/reactornavigation/ReactorView;", "navigationCore", "Lio/tesseractgroup/reactor/Core;", "Lio/tesseractgroup/reactornavigation/NavigationStateProtocol;", "Lio/tesseractgroup/reactornavigation/NavigationEvent;", "Lio/tesseractgroup/reactornavigation/NavigationCommand;", "getNavigationCore", "()Lio/tesseractgroup/reactor/Core;", "value", "Lio/tesseractgroup/reactornavigation/ReactorActivity$NavigationIconState;", "navigationIconSate", "setNavigationIconSate", "(Lio/tesseractgroup/reactornavigation/ReactorActivity$NavigationIconState;)V", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "getToolbar", "()Landroidx/appcompat/widget/Toolbar;", "setToolbar", "(Landroidx/appcompat/widget/Toolbar;)V", "transitioningMainView", "displayedFragment", "Lio/tesseractgroup/reactornavigation/ReactorFragment;", "getViewForState", "reactorViewState", "Lio/tesseractgroup/reactornavigation/ReactorViewState;", "hideSoftKeyBoard", "", "isARootContainer", "container", "Lio/tesseractgroup/reactornavigation/ViewContainerState;", "rootContainer", "navigationCommandReceived", "navigationCommand", "navigationIconChanged", "oldValue", "newValue", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPause", "onResume", "onSaveInstanceState", "outState", "showView", "containerTag", "", "Lio/tesseractgroup/reactornavigation/ViewContainerTag;", "parentTag", "command", "updateWithNavState", "state", "NavigationIconState", "reactornavigation_release"})
public abstract class ReactorActivity
extends AppCompatActivity {
    @NotNull
    public Toolbar toolbar;
    private NavigationIconState navigationIconSate;
    private boolean activityCreated;
    private boolean transitioningMainView;
    private ReactorView lastView;
    private final int layoutId;
    private final int toolbarId;
    private final int reactorContainerId;
    private HashMap _$_findViewCache;

    @NotNull
    public abstract Core<NavigationStateProtocol, NavigationEvent, NavigationCommand> getNavigationCore();

    @NotNull
    public final Toolbar getToolbar() {
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        return toolbar;
    }

    public final void setToolbar(@NotNull Toolbar toolbar) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"<set-?>");
        this.toolbar = toolbar;
    }

    private final void setNavigationIconSate(NavigationIconState value) {
        if (this.navigationIconSate != value) {
            this.navigationIconChanged(this.navigationIconSate, value);
            this.navigationIconSate = value;
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setContentView(this.layoutId);
        super.onCreate(savedInstanceState);
        ReactorFragment existingFragment = this.displayedFragment();
        ReactorViewState visibleViewState = ((NavigationStateProtocol)this.getNavigationCore().getCurrentState()).findVisibleView();
        if (existingFragment != null && visibleViewState != null) {
            existingFragment.setReactorView(this.getViewForState(visibleViewState));
        }
        View view = this.findViewById(this.toolbarId);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(toolbarId)");
        Toolbar toolbar = this.toolbar = (Toolbar)view;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        this.setSupportActionBar(toolbar);
        ReactorNavigation.INSTANCE.getNavigationCommandReceived().addMultipleCallbacks((Object)this, (Function1)new Function1<NavigationCommand, Unit>(this){

            public final void invoke(@NotNull NavigationCommand p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ReactorActivity.access$navigationCommandReceived((ReactorActivity)((Object)this.receiver), p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ReactorActivity.class);
            }

            public final String getName() {
                return "navigationCommandReceived";
            }

            public final String getSignature() {
                return "navigationCommandReceived(Lio/tesseractgroup/reactornavigation/NavigationCommand;)V";
            }
        });
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu) {
        this.activityCreated = true;
        this.updateWithNavState((NavigationStateProtocol)this.getNavigationCore().getCurrentState(), new NavigationCommand.RootContainerChanged(null));
        return super.onCreateOptionsMenu(menu);
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
    }

    protected void onPause() {
        super.onPause();
        this.getNavigationCore().fire((Object)new NavigationEvent.AppContextChanged(false));
    }

    protected void onResume() {
        super.onResume();
        this.getNavigationCore().fire((Object)new NavigationEvent.AppContextChanged(true));
    }

    protected void onDestroy() {
        super.onDestroy();
        ReactorNavigation.INSTANCE.getNavigationCommandReceived().remove((Object)this);
    }

    private final void navigationCommandReceived(NavigationCommand navigationCommand) {
        if (navigationCommand.getNavStackChanged()) {
            this.updateWithNavState((NavigationStateProtocol)this.getNavigationCore().getCurrentState(), navigationCommand);
        } else if (navigationCommand instanceof NavigationCommand.PresentAlert) {
            this.runOnUiThread(new Runnable(this, navigationCommand){
                final /* synthetic */ ReactorActivity this$0;
                final /* synthetic */ NavigationCommand $navigationCommand;

                public final void run() {
                    AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)this.this$0);
                    alertBuilder.setCancelable(false);
                    alertBuilder.setTitle((CharSequence)((NavigationCommand.PresentAlert)this.$navigationCommand).getTitle());
                    alertBuilder.setMessage((CharSequence)((NavigationCommand.PresentAlert)this.$navigationCommand).getMessage());
                    Iterator iterator = CollectionsKt.withIndex(((NavigationCommand.PresentAlert)this.$navigationCommand).getButtons().iterator());
                    boolean bl = false;
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        Function2<DialogInterface, Integer, Unit> function2;
                        IndexedValue indexedValue = (IndexedValue)iterator2.next();
                        int index = indexedValue.component1();
                        AlertButton button = (AlertButton)indexedValue.component2();
                        if (index == 0) {
                            CharSequence charSequence = button.getTitle();
                            Object object = button.getAction();
                            if (object != null) {
                                function2 = object;
                                object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                            }
                            alertBuilder.setPositiveButton(charSequence, (DialogInterface.OnClickListener)object);
                            continue;
                        }
                        if (index == 1) {
                            CharSequence charSequence = button.getTitle();
                            Object object = button.getAction();
                            if (object != null) {
                                function2 = object;
                                object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                            }
                            alertBuilder.setNegativeButton(charSequence, (DialogInterface.OnClickListener)object);
                            continue;
                        }
                        CharSequence charSequence = button.getTitle();
                        Object object = button.getAction();
                        if (object != null) {
                            function2 = object;
                            object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                        }
                        alertBuilder.setNeutralButton(charSequence, (DialogInterface.OnClickListener)object);
                    }
                    alertBuilder.show();
                }
                {
                    this.this$0 = reactorActivity;
                    this.$navigationCommand = navigationCommand;
                }
            });
        }
    }

    private final ReactorFragment displayedFragment() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"supportFragmentManager");
        List list = fragmentManager.getFragments();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"supportFragmentManager.fragments");
        Fragment fragment = (Fragment)CollectionsKt.firstOrNull((List)list);
        return fragment instanceof ReactorFragment ? (ReactorFragment)fragment : null;
    }

    private final void updateWithNavState(NavigationStateProtocol state, NavigationCommand command) {
        if (!(command instanceof VisibleViewChanged)) {
            return;
        }
        this.runOnUiThread(new Runnable(this, state, command){
            final /* synthetic */ ReactorActivity this$0;
            final /* synthetic */ NavigationStateProtocol $state;
            final /* synthetic */ NavigationCommand $command;

            public final void run() {
                NavContainerState visibleContainer = this.$state.findVisibleContainer();
                ReactorViewState visibleViewState = this.$state.findVisibleView();
                if (visibleViewState != null && visibleContainer != null) {
                    NavigationIconState navigationIconState;
                    if (!ReactorActivity.access$getActivityCreated$p(this.this$0)) {
                        Log.e((String)"NAVIGATION", (String)"Dropping navigation event. Activity not created.");
                        return;
                    }
                    ReactorActivity.access$showView(this.this$0, visibleViewState, visibleContainer.getTag(), visibleContainer.getParentTag(), this.$command);
                    boolean isARootNavContainer = ReactorActivity.access$isARootContainer(this.this$0, visibleContainer, this.$state.getRootViewContainer());
                    Collection collection = visibleContainer.getViewStates();
                    ReactorActivity reactorActivity = this.this$0;
                    boolean bl = false;
                    int n = collection.size();
                    ReactorActivity reactorActivity2 = reactorActivity;
                    if (n == 1 && !isARootNavContainer && visibleContainer.getCancellable()) {
                        navigationIconState = NavigationIconState.CLOSE;
                    } else {
                        collection = visibleContainer.getViewStates();
                        reactorActivity = reactorActivity2;
                        bl = false;
                        n = collection.size();
                        reactorActivity2 = reactorActivity;
                        navigationIconState = n > 1 ? NavigationIconState.BACK : NavigationIconState.NONE;
                    }
                    ReactorActivity.access$setNavigationIconSate$p(reactorActivity2, navigationIconState);
                }
            }
            {
                this.this$0 = reactorActivity;
                this.$state = navigationStateProtocol;
                this.$command = navigationCommand;
            }
        });
    }

    private final void navigationIconChanged(NavigationIconState oldValue, NavigationIconState newValue) {
        block1: {
            AnimatedVectorDrawableCompat drawable2 = newValue.drawable((Context)this);
            Toolbar toolbar = this.toolbar;
            if (toolbar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar.setNavigationIcon((Drawable)drawable2);
            AnimatedVectorDrawableCompat animatedVectorDrawableCompat = drawable2;
            if (animatedVectorDrawableCompat == null) break block1;
            animatedVectorDrawableCompat.start();
        }
    }

    private final void showView(ReactorViewState reactorViewState, String containerTag, String parentTag, NavigationCommand command) {
        if (this.transitioningMainView) {
            Log.e((String)"NAVIGATION", (String)"In the middle of a transition. Dropping view transition.");
            return;
        }
        ReactorFragment reactorFragment = this.displayedFragment();
        ReactorView view = reactorFragment != null ? reactorFragment.getReactorView() : null;
        this.transitioningMainView = true;
        ReactorView reactorView = view;
        if (Intrinsics.areEqual((Object)(reactorView != null ? reactorView.getViewState() : null), (Object)reactorViewState) ^ true) {
            Toolbar toolbar = this.toolbar;
            if (toolbar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar.setOnMenuItemClickListener(null);
            Toolbar toolbar2 = this.toolbar;
            if (toolbar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar2.setTitle((CharSequence)"");
            boolean isInitialView = false;
            if (view != null) {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Show in main view: " + reactorViewState + " replacing view: " + view.getViewState()));
            } else {
                isInitialView = true;
                Log.d((String)"REACTOR_NAVIGATION", (String)("Replace initial view: " + reactorViewState));
            }
            this.hideSoftKeyBoard();
            ReactorView viewToRemove = view;
            ReactorView viewToShow = this.getViewForState(reactorViewState);
            viewToShow.setContainerTag$reactornavigation_release(containerTag);
            viewToShow.setParentTag$reactornavigation_release(parentTag);
            ReactorFragment fragment = ReactorFragment.Companion.newInstance(viewToShow);
            ReactorFragment currentFragment = this.displayedFragment();
            NavigationCommand navigationCommand = command;
            if (navigationCommand instanceof NavigationCommand.TabIndexChanged) {
                fragment.setEnterTransition(ReactorTransitions.INSTANCE.getEnterFade());
                ReactorFragment reactorFragment2 = currentFragment;
                if (reactorFragment2 != null) {
                    reactorFragment2.setExitTransition(ReactorTransitions.INSTANCE.getExitFade());
                }
            } else if (navigationCommand instanceof NavigationCommand.ModalPresented) {
                fragment.setEnterTransition(ReactorTransitions.INSTANCE.getBottomSlide());
                ReactorFragment reactorFragment3 = currentFragment;
                if (reactorFragment3 != null) {
                    reactorFragment3.setExitTransition(ReactorTransitions.INSTANCE.getExitFade());
                }
            } else if (navigationCommand instanceof NavigationCommand.ModalDismissed) {
                fragment.setEnterTransition(ReactorTransitions.INSTANCE.getEnterFade());
                ReactorFragment reactorFragment4 = currentFragment;
                if (reactorFragment4 != null) {
                    reactorFragment4.setExitTransition(ReactorTransitions.INSTANCE.getBottomSlide());
                }
            } else if (navigationCommand instanceof NavigationCommand.RootContainerChanged) {
                fragment.setEnterTransition(ReactorTransitions.INSTANCE.getEnterFade());
                ReactorFragment reactorFragment5 = currentFragment;
                if (reactorFragment5 != null) {
                    reactorFragment5.setExitTransition(ReactorTransitions.INSTANCE.getExitFade());
                }
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.NavViewPushed.INSTANCE)) {
                fragment.setEnterTransition(ReactorTransitions.INSTANCE.getRightSlide());
                ReactorFragment reactorFragment6 = currentFragment;
                if (reactorFragment6 != null) {
                    reactorFragment6.setExitTransition(ReactorTransitions.INSTANCE.getLeftSlide());
                }
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.NavViewPopped.INSTANCE)) {
                fragment.setEnterTransition(ReactorTransitions.INSTANCE.getLeftSlide());
                ReactorFragment reactorFragment7 = currentFragment;
                if (reactorFragment7 != null) {
                    reactorFragment7.setExitTransition(ReactorTransitions.INSTANCE.getRightSlide());
                }
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.NavViewReplaced.INSTANCE)) {
                fragment.setEnterTransition(ReactorTransitions.INSTANCE.getEnterFade());
                ReactorFragment reactorFragment8 = currentFragment;
                if (reactorFragment8 != null) {
                    reactorFragment8.setExitTransition(ReactorTransitions.INSTANCE.getExitFade());
                }
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.HiddenUpdate.INSTANCE) || Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.AppContextChanged.INSTANCE) || navigationCommand instanceof NavigationCommand.PresentAlert) {
                // empty if block
            }
            FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
            FragmentTransaction transaction = fragmentTransaction;
            transaction.replace(this.reactorContainerId, (Fragment)fragment);
            transaction.commitAllowingStateLoss();
            if (Intrinsics.areEqual((Object)((Object)this.lastView), (Object)((Object)viewToRemove)) ^ true && !isInitialView) {
                Log.e((String)"REACTOR_NAVIGATION", (String)"Last view added doesn't match current view. Consider re-ordering navigation events.");
                ReactorView reactorView2 = this.lastView;
                if (reactorView2 != null) {
                    reactorView2.viewTearDown();
                }
            }
            if (viewToRemove instanceof ReactorView) {
                viewToRemove.viewTearDown();
            }
            this.lastView = viewToShow;
        }
        this.transitioningMainView = false;
    }

    @NotNull
    public ReactorView getViewForState(@NotNull ReactorViewState reactorViewState) {
        Intrinsics.checkParameterIsNotNull((Object)reactorViewState, (String)"reactorViewState");
        return reactorViewState.view((Context)this);
    }

    private final void hideSoftKeyBoard() {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View currentFocusElement = this.getCurrentFocus();
        if (imm.isAcceptingText() && currentFocusElement != null) {
            imm.hideSoftInputFromWindow(currentFocusElement.getWindowToken(), 0);
        }
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        MenuItem menuItem = item;
        if (menuItem != null) {
            if (menuItem.getItemId() == 16908332) {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        String parentContainerTag;
        NavContainerState selectedContainer;
        ReactorView reactorView;
        ReactorFragment reactorFragment = this.displayedFragment();
        ReactorView reactorView2 = reactorView = reactorFragment != null ? reactorFragment.getReactorView() : null;
        if (reactorView2 != null) {
            if (reactorView2.onBackPressed()) {
                return;
            }
        }
        NavigationStateProtocol state = (NavigationStateProtocol)this.getNavigationCore().getCurrentState();
        NavContainerState navContainerState = selectedContainer = state.getRootViewContainer().findVisibleContainer$reactornavigation_release();
        String string = parentContainerTag = navContainerState != null ? navContainerState.getParentTag() : null;
        if (selectedContainer == null) {
            this.finish();
            return;
        }
        boolean isRootContainer = this.isARootContainer(selectedContainer, state.getRootViewContainer());
        Collection collection = selectedContainer.getViewStates();
        boolean bl = false;
        if (collection.size() > 1) {
            this.getNavigationCore().fire((Object)new NavigationEvent.PopNavView(selectedContainer.getTag()));
        } else if (!isRootContainer && selectedContainer.getCancellable()) {
            Core<NavigationStateProtocol, NavigationEvent, NavigationCommand> core = this.getNavigationCore();
            String string2 = parentContainerTag;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            core.fire((Object)new NavigationEvent.DismissModal(string2));
        } else {
            this.finish();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isARootContainer(ViewContainerState container, ViewContainerState rootContainer) {
        List list;
        if (rootContainer instanceof TabContainerState) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((TabContainerState)rootContainer).getTabContainers();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NavContainerState navContainerState = (NavContainerState)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getTag();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        List rootContainerTabContainerTags = list;
        return container.getParentTag() == null || rootContainerTabContainerTags.contains(container.getTag());
    }

    public ReactorActivity(int layoutId, int toolbarId, int reactorContainerId) {
        this.layoutId = layoutId;
        this.toolbarId = toolbarId;
        this.reactorContainerId = reactorContainerId;
        this.navigationIconSate = NavigationIconState.NONE;
    }

    public static final /* synthetic */ void access$navigationCommandReceived(ReactorActivity $this, NavigationCommand navigationCommand) {
        $this.navigationCommandReceived(navigationCommand);
    }

    public static final /* synthetic */ boolean access$getActivityCreated$p(ReactorActivity $this) {
        return $this.activityCreated;
    }

    public static final /* synthetic */ void access$setActivityCreated$p(ReactorActivity $this, boolean bl) {
        $this.activityCreated = bl;
    }

    public static final /* synthetic */ void access$showView(ReactorActivity $this, ReactorViewState reactorViewState, String containerTag, String parentTag, NavigationCommand command) {
        $this.showView(reactorViewState, containerTag, parentTag, command);
    }

    public static final /* synthetic */ boolean access$isARootContainer(ReactorActivity $this, ViewContainerState container, ViewContainerState rootContainer) {
        return $this.isARootContainer(container, rootContainer);
    }

    public static final /* synthetic */ NavigationIconState access$getNavigationIconSate$p(ReactorActivity $this) {
        return $this.navigationIconSate;
    }

    public static final /* synthetic */ void access$setNavigationIconSate$p(ReactorActivity $this, NavigationIconState navigationIconState) {
        $this.setNavigationIconSate(navigationIconState);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorActivity$NavigationIconState;", "", "(Ljava/lang/String;I)V", "drawable", "Landroidx/vectordrawable/graphics/drawable/AnimatedVectorDrawableCompat;", "context", "Landroid/content/Context;", "NONE", "CLOSE", "BACK", "reactornavigation_release"})
    public static final class NavigationIconState
    extends Enum<NavigationIconState> {
        public static final /* enum */ NavigationIconState NONE;
        public static final /* enum */ NavigationIconState CLOSE;
        public static final /* enum */ NavigationIconState BACK;
        private static final /* synthetic */ NavigationIconState[] $VALUES;

        static {
            NavigationIconState[] navigationIconStateArray = new NavigationIconState[3];
            NavigationIconState[] navigationIconStateArray2 = navigationIconStateArray;
            navigationIconStateArray[0] = NONE = new NavigationIconState();
            navigationIconStateArray[1] = CLOSE = new NavigationIconState();
            navigationIconStateArray[2] = BACK = new NavigationIconState();
            $VALUES = navigationIconStateArray;
        }

        @Nullable
        public final AnimatedVectorDrawableCompat drawable(@NotNull Context context) {
            AnimatedVectorDrawableCompat animatedVectorDrawableCompat;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            switch (ReactorActivity$NavigationIconState$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    animatedVectorDrawableCompat = null;
                    break;
                }
                case 2: {
                    animatedVectorDrawableCompat = AnimatedVectorDrawableCompat.create((Context)context, (int)R.drawable.pathmorph_back_to_close);
                    break;
                }
                case 3: {
                    animatedVectorDrawableCompat = AnimatedVectorDrawableCompat.create((Context)context, (int)R.drawable.pathmorph_close_to_back);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return animatedVectorDrawableCompat;
        }

        public static NavigationIconState[] values() {
            return (NavigationIconState[])$VALUES.clone();
        }

        public static NavigationIconState valueOf(String string) {
            return Enum.valueOf(NavigationIconState.class, string);
        }
    }
}

