/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import io.tesseractgroup.reactor.Core;
import io.tesseractgroup.reactornavigation.AlertButton;
import io.tesseractgroup.reactornavigation.NavContainerState;
import io.tesseractgroup.reactornavigation.NavigationCommand;
import io.tesseractgroup.reactornavigation.NavigationEvent;
import io.tesseractgroup.reactornavigation.NavigationStateProtocol;
import io.tesseractgroup.reactornavigation.R;
import io.tesseractgroup.reactornavigation.ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0;
import io.tesseractgroup.reactornavigation.ReactorFragment;
import io.tesseractgroup.reactornavigation.ReactorNavigation;
import io.tesseractgroup.reactornavigation.ReactorView;
import io.tesseractgroup.reactornavigation.ReactorViewState;
import io.tesseractgroup.reactornavigation.TabContainerState;
import io.tesseractgroup.reactornavigation.ViewContainerState;
import io.tesseractgroup.reactornavigation.VisibleViewChanged;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\rH\u0002J\b\u0010!\u001a\u00020\u001eH\u0016J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0012\u0010%\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020\u001eH\u0014J\u0012\u0010)\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020\u001eH\u0014J\b\u0010-\u001a\u00020\u001eH\u0014J4\u0010.\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010/\u001a\u000600j\u0002`12\u000e\u00102\u001a\n\u0018\u000100j\u0004\u0018\u0001`12\u0006\u00103\u001a\u00020\rH\u0002J\u0018\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorActivity;", "Landroid/support/v7/app/AppCompatActivity;", "layoutId", "", "toolbarId", "reactorContainerId", "(III)V", "activityCreated", "", "navigationCore", "Lio/tesseractgroup/reactor/Core;", "Lio/tesseractgroup/reactornavigation/NavigationStateProtocol;", "Lio/tesseractgroup/reactornavigation/NavigationEvent;", "Lio/tesseractgroup/reactornavigation/NavigationCommand;", "getNavigationCore", "()Lio/tesseractgroup/reactor/Core;", "toolbar", "Landroid/support/v7/widget/Toolbar;", "getToolbar", "()Landroid/support/v7/widget/Toolbar;", "setToolbar", "(Landroid/support/v7/widget/Toolbar;)V", "transitioningMainView", "displayedFragment", "Lio/tesseractgroup/reactornavigation/ReactorFragment;", "getViewForState", "Lio/tesseractgroup/reactornavigation/ReactorView;", "reactorViewState", "Lio/tesseractgroup/reactornavigation/ReactorViewState;", "hideSoftKeyBoard", "", "navigationCommandReceived", "navigationCommand", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPause", "onResume", "showView", "containerTag", "", "Lio/tesseractgroup/reactornavigation/ViewContainerTag;", "parentTag", "command", "updateWithNavState", "state", "reactornavigation_release"})
public abstract class ReactorActivity
extends AppCompatActivity {
    @NotNull
    public Toolbar toolbar;
    private boolean activityCreated;
    private boolean transitioningMainView;
    private final int layoutId;
    private final int toolbarId;
    private final int reactorContainerId;
    private HashMap _$_findViewCache;

    @NotNull
    public abstract Core<NavigationStateProtocol, NavigationEvent, NavigationCommand> getNavigationCore();

    @NotNull
    public final Toolbar getToolbar() {
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        return toolbar;
    }

    public final void setToolbar(@NotNull Toolbar toolbar) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"<set-?>");
        this.toolbar = toolbar;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setContentView(this.layoutId);
        super.onCreate(savedInstanceState);
        View view = this.findViewById(this.toolbarId);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(toolbarId)");
        Toolbar toolbar = this.toolbar = (Toolbar)view;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        this.setSupportActionBar(toolbar);
        ReactorNavigation.INSTANCE.getNavigationCommandReceived().addMultipleCallbacks((Object)this, (Function1)new Function1<NavigationCommand, Unit>(this){

            public final void invoke(@NotNull NavigationCommand p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ReactorActivity.access$navigationCommandReceived((ReactorActivity)((Object)this.receiver), p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ReactorActivity.class);
            }

            public final String getName() {
                return "navigationCommandReceived";
            }

            public final String getSignature() {
                return "navigationCommandReceived(Lio/tesseractgroup/reactornavigation/NavigationCommand;)V";
            }
        });
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu) {
        this.activityCreated = true;
        this.updateWithNavState((NavigationStateProtocol)this.getNavigationCore().getCurrentState(), NavigationCommand.RootContainerChanged.INSTANCE);
        return super.onCreateOptionsMenu(menu);
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onDestroy() {
        super.onDestroy();
        ReactorNavigation.INSTANCE.getNavigationCommandReceived().remove((Object)this);
    }

    private final void navigationCommandReceived(NavigationCommand navigationCommand) {
        if (navigationCommand.getNavStackChanged()) {
            this.updateWithNavState((NavigationStateProtocol)this.getNavigationCore().getCurrentState(), navigationCommand);
        } else if (navigationCommand instanceof NavigationCommand.PresentAlert) {
            this.runOnUiThread(new Runnable(this, navigationCommand){
                final /* synthetic */ ReactorActivity this$0;
                final /* synthetic */ NavigationCommand $navigationCommand;

                public final void run() {
                    AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)this.this$0);
                    alertBuilder.setCancelable(false);
                    alertBuilder.setTitle((CharSequence)((NavigationCommand.PresentAlert)this.$navigationCommand).getTitle());
                    alertBuilder.setMessage((CharSequence)((NavigationCommand.PresentAlert)this.$navigationCommand).getMessage());
                    Iterator iterator = CollectionsKt.withIndex(((NavigationCommand.PresentAlert)this.$navigationCommand).getButtons().iterator());
                    boolean bl = false;
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        Function2<DialogInterface, Integer, Unit> function2;
                        IndexedValue indexedValue = (IndexedValue)iterator2.next();
                        int index = indexedValue.component1();
                        AlertButton button = (AlertButton)indexedValue.component2();
                        if (index == 0) {
                            CharSequence charSequence = button.getTitle();
                            Object object = button.getAction();
                            if (object != null) {
                                function2 = object;
                                object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                            }
                            alertBuilder.setPositiveButton(charSequence, (DialogInterface.OnClickListener)object);
                            continue;
                        }
                        if (index == 1) {
                            CharSequence charSequence = button.getTitle();
                            Object object = button.getAction();
                            if (object != null) {
                                function2 = object;
                                object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                            }
                            alertBuilder.setNegativeButton(charSequence, (DialogInterface.OnClickListener)object);
                            continue;
                        }
                        CharSequence charSequence = button.getTitle();
                        Object object = button.getAction();
                        if (object != null) {
                            function2 = object;
                            object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                        }
                        alertBuilder.setNeutralButton(charSequence, (DialogInterface.OnClickListener)object);
                    }
                    alertBuilder.show();
                }
                {
                    this.this$0 = reactorActivity;
                    this.$navigationCommand = navigationCommand;
                }
            });
        }
    }

    private final ReactorFragment displayedFragment() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"supportFragmentManager");
        List list = fragmentManager.getFragments();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"supportFragmentManager.fragments");
        Fragment fragment = (Fragment)CollectionsKt.firstOrNull((List)list);
        return fragment instanceof ReactorFragment ? (ReactorFragment)fragment : null;
    }

    private final void updateWithNavState(NavigationStateProtocol state, NavigationCommand command) {
        if (!(command instanceof VisibleViewChanged)) {
            return;
        }
        this.runOnUiThread(new Runnable(this, state, command){
            final /* synthetic */ ReactorActivity this$0;
            final /* synthetic */ NavigationStateProtocol $state;
            final /* synthetic */ NavigationCommand $command;

            public final void run() {
                block0: {
                    block1: {
                        boolean isARootNavContainer;
                        NavContainerState visibleContainer = this.$state.findVisibleContainer();
                        ReactorViewState visibleViewState = this.$state.findVisibleView();
                        if (visibleViewState == null || visibleContainer == null) break block0;
                        ReactorActivity.access$showView(this.this$0, visibleViewState, visibleContainer.getTag(), visibleContainer.getParentTag(), this.$command);
                        ViewContainerState rootContainer = this.$state.getRootViewContainer();
                        String rootTag = rootContainer.getTag();
                        boolean bl = isARootNavContainer = Intrinsics.areEqual((Object)visibleContainer.getTag(), (Object)rootTag) || rootContainer instanceof TabContainerState && Intrinsics.areEqual((Object)visibleContainer.getParentTag(), (Object)rootTag);
                        if (!isARootNavContainer && visibleContainer.getCancellable()) break block1;
                        Collection collection = visibleContainer.getViewStates();
                        boolean bl2 = false;
                        boolean isEnabled = collection.size() > 1;
                        ActionBar actionBar = this.this$0.getSupportActionBar();
                        if (actionBar == null) break block0;
                        actionBar.setDisplayHomeAsUpEnabled(isEnabled);
                        break block0;
                    }
                    ActionBar actionBar = this.this$0.getSupportActionBar();
                    if (actionBar == null) break block0;
                    actionBar.setDisplayHomeAsUpEnabled(true);
                }
            }
            {
                this.this$0 = reactorActivity;
                this.$state = navigationStateProtocol;
                this.$command = navigationCommand;
            }
        });
    }

    private final void showView(ReactorViewState reactorViewState, String containerTag, String parentTag, NavigationCommand command) {
        if (!this.activityCreated) {
            Log.e((String)"NAVIGATION", (String)"Dropping navigation event. Activity not created.");
            return;
        }
        if (this.transitioningMainView) {
            Log.e((String)"NAVIGATION", (String)"In the middle of a transition. Dropping view transition.");
            return;
        }
        ReactorFragment reactorFragment = this.displayedFragment();
        ReactorView view = reactorFragment != null ? reactorFragment.getReactorView() : null;
        this.transitioningMainView = true;
        ReactorView reactorView = view;
        if (Intrinsics.areEqual((Object)(reactorView != null ? reactorView.getViewState() : null), (Object)reactorViewState) ^ true) {
            Toolbar toolbar = this.toolbar;
            if (toolbar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar.setOnMenuItemClickListener(null);
            Toolbar toolbar2 = this.toolbar;
            if (toolbar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar2.setTitle((CharSequence)"");
            if (view != null) {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Show in main view: " + reactorViewState + " replacing view: " + view.getViewState()));
            } else {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Replace initial view: " + reactorViewState));
            }
            this.hideSoftKeyBoard();
            ReactorView viewToRemove = view;
            ReactorView viewToShow = this.getViewForState(reactorViewState);
            viewToShow.setContainerTag$reactornavigation_release(containerTag);
            viewToShow.setParentTag$reactornavigation_release(parentTag);
            ReactorFragment fragment = ReactorFragment.Companion.newInstance(viewToShow);
            FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
            FragmentTransaction transaction = fragmentTransaction;
            NavigationCommand navigationCommand = command;
            if (navigationCommand instanceof NavigationCommand.TabIndexChanged) {
                Intrinsics.checkExpressionValueIsNotNull((Object)transaction.setCustomAnimations(0x10B0000, 0x10B0001), (String)"transaction.setCustomAni\u2026roid.R.animator.fade_out)");
            } else if (navigationCommand instanceof NavigationCommand.ModalPresented) {
                Intrinsics.checkExpressionValueIsNotNull((Object)transaction.setCustomAnimations(0x10B0000, 0x10B0001), (String)"transaction.setCustomAni\u2026roid.R.animator.fade_out)");
            } else if (navigationCommand instanceof NavigationCommand.ModalDismissed) {
                Intrinsics.checkExpressionValueIsNotNull((Object)transaction.setCustomAnimations(0x10B0000, 0x10B0001), (String)"transaction.setCustomAni\u2026roid.R.animator.fade_out)");
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.RootContainerChanged.INSTANCE)) {
                Intrinsics.checkExpressionValueIsNotNull((Object)transaction.setCustomAnimations(0x10B0000, 0x10B0001), (String)"transaction.setCustomAni\u2026roid.R.animator.fade_out)");
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.NavViewPushed.INSTANCE)) {
                Intrinsics.checkExpressionValueIsNotNull((Object)transaction.setCustomAnimations(R.anim.enter_from_left, R.anim.exit_to_right, R.anim.enter_from_right, R.anim.exit_to_left), (String)"transaction.setCustomAni\u2026ght, R.anim.exit_to_left)");
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.NavViewPopped.INSTANCE)) {
                Intrinsics.checkExpressionValueIsNotNull((Object)transaction.setCustomAnimations(R.anim.enter_from_right, R.anim.exit_to_left, R.anim.enter_from_left, R.anim.exit_to_right), (String)"transaction.setCustomAni\u2026ft, R.anim.exit_to_right)");
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.NavViewReplaced.INSTANCE)) {
                Intrinsics.checkExpressionValueIsNotNull((Object)transaction.setCustomAnimations(0x10B0000, 0x10B0001), (String)"transaction.setCustomAni\u2026roid.R.animator.fade_out)");
            } else if (Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.HiddenUpdate.INSTANCE) || Intrinsics.areEqual((Object)navigationCommand, (Object)NavigationCommand.AppContextChanged.INSTANCE) || navigationCommand instanceof NavigationCommand.PresentAlert) {
                // empty if block
            }
            transaction.replace(this.reactorContainerId, (Fragment)fragment);
            transaction.commit();
            if (viewToRemove instanceof ReactorView) {
                viewToRemove.viewTearDown();
            }
        }
        this.transitioningMainView = false;
    }

    @NotNull
    public ReactorView getViewForState(@NotNull ReactorViewState reactorViewState) {
        Intrinsics.checkParameterIsNotNull((Object)reactorViewState, (String)"reactorViewState");
        return reactorViewState.view((Context)this);
    }

    private final void hideSoftKeyBoard() {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View currentFocusElement = this.getCurrentFocus();
        if (imm.isAcceptingText() && currentFocusElement != null) {
            imm.hideSoftInputFromWindow(currentFocusElement.getWindowToken(), 0);
        }
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        MenuItem menuItem = item;
        if (menuItem != null) {
            if (menuItem.getItemId() == 16908332) {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onBackPressed() {
        boolean isRootContainer;
        NavContainerState selectedContainer;
        ReactorView reactorView;
        ReactorFragment reactorFragment = this.displayedFragment();
        ReactorView reactorView2 = reactorView = reactorFragment != null ? reactorFragment.getReactorView() : null;
        if (reactorView2 != null) {
            if (reactorView2.onBackPressed()) {
                return;
            }
        }
        NavigationStateProtocol state = (NavigationStateProtocol)this.getNavigationCore().getCurrentState();
        NavContainerState navContainerState = selectedContainer = state.getRootViewContainer().findVisibleContainer$reactornavigation_release();
        String parentContainerTag = navContainerState != null ? navContainerState.getParentTag() : null;
        boolean bl = isRootContainer = parentContainerTag == null || Intrinsics.areEqual((Object)state.getRootViewContainer().getTag(), (Object)parentContainerTag) && state.getRootViewContainer() instanceof TabContainerState;
        if (selectedContainer != null) {
            Collection collection = selectedContainer.getViewStates();
            boolean bl2 = false;
            if (collection.size() > 1) {
                this.getNavigationCore().fire((Object)new NavigationEvent.PopNavView(selectedContainer.getTag()));
                return;
            }
        }
        if (!isRootContainer) {
            NavContainerState navContainerState2 = selectedContainer;
            if (navContainerState2 != null) {
                if (navContainerState2.getCancellable()) {
                    Core<NavigationStateProtocol, NavigationEvent, NavigationCommand> core = this.getNavigationCore();
                    String string = parentContainerTag;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    core.fire((Object)new NavigationEvent.DismissModal(string));
                    return;
                }
            }
        }
        this.finish();
    }

    public ReactorActivity(int layoutId, int toolbarId, int reactorContainerId) {
        this.layoutId = layoutId;
        this.toolbarId = toolbarId;
        this.reactorContainerId = reactorContainerId;
    }

    public static final /* synthetic */ void access$navigationCommandReceived(ReactorActivity $this, NavigationCommand navigationCommand) {
        $this.navigationCommandReceived(navigationCommand);
    }

    public static final /* synthetic */ void access$showView(ReactorActivity $this, ReactorViewState reactorViewState, String containerTag, String parentTag, NavigationCommand command) {
        $this.showView(reactorViewState, containerTag, parentTag, command);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

