/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import io.tesseractgroup.reactor.Core;
import io.tesseractgroup.reactornavigation.AlertButton;
import io.tesseractgroup.reactornavigation.NavContainerState;
import io.tesseractgroup.reactornavigation.NavigationCommand;
import io.tesseractgroup.reactornavigation.NavigationEvent;
import io.tesseractgroup.reactornavigation.NavigationStateProtocol;
import io.tesseractgroup.reactornavigation.ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0;
import io.tesseractgroup.reactornavigation.ReactorNavigation;
import io.tesseractgroup.reactornavigation.ReactorView;
import io.tesseractgroup.reactornavigation.ReactorViewState;
import io.tesseractgroup.reactornavigation.TabContainerState;
import io.tesseractgroup.reactornavigation.ViewContainerState;
import io.tesseractgroup.reactornavigation.VisibleViewChanged;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\rH\u0002J\b\u0010#\u001a\u00020 H\u0016J\u0012\u0010$\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u0012\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020 H\u0014J\u0012\u0010+\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020 H\u0014J\b\u0010/\u001a\u00020 H\u0014J4\u00100\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u00101\u001a\u000602j\u0002`32\u000e\u00104\u001a\n\u0018\u000102j\u0004\u0018\u0001`32\u0006\u00105\u001a\u00020\rH\u0002J\u0018\u00106\u001a\u00020 2\u0006\u00107\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorActivity;", "Landroid/support/v7/app/AppCompatActivity;", "layoutId", "", "toolbarId", "reactorContainerId", "(III)V", "activityCreated", "", "navigationCore", "Lio/tesseractgroup/reactor/Core;", "Lio/tesseractgroup/reactornavigation/NavigationStateProtocol;", "Lio/tesseractgroup/reactornavigation/NavigationEvent;", "Lio/tesseractgroup/reactornavigation/NavigationCommand;", "getNavigationCore", "()Lio/tesseractgroup/reactor/Core;", "rootViewGroup", "Landroid/view/ViewGroup;", "toolbar", "Landroid/support/v7/widget/Toolbar;", "getToolbar", "()Landroid/support/v7/widget/Toolbar;", "setToolbar", "(Landroid/support/v7/widget/Toolbar;)V", "transitioningMainView", "displayedView", "Landroid/view/View;", "getViewForState", "Lio/tesseractgroup/reactornavigation/ReactorView;", "reactorViewState", "Lio/tesseractgroup/reactornavigation/ReactorViewState;", "hideSoftKeyBoard", "", "navigationCommandReceived", "navigationCommand", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPause", "onResume", "showView", "containerTag", "", "Lio/tesseractgroup/reactornavigation/ViewContainerTag;", "parentTag", "command", "updateWithNavState", "state", "reactornavigation_release"})
public abstract class ReactorActivity
extends AppCompatActivity {
    @NotNull
    public Toolbar toolbar;
    private boolean activityCreated;
    private ViewGroup rootViewGroup;
    private boolean transitioningMainView;
    private final int layoutId;
    private final int toolbarId;
    private final int reactorContainerId;

    @NotNull
    public abstract Core<NavigationStateProtocol, NavigationEvent, NavigationCommand> getNavigationCore();

    @NotNull
    public final Toolbar getToolbar() {
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        return toolbar;
    }

    public final void setToolbar(@NotNull Toolbar toolbar) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"<set-?>");
        this.toolbar = toolbar;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setContentView(this.layoutId);
        super.onCreate(savedInstanceState);
        View view = this.findViewById(this.reactorContainerId);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(reactorContainerId)");
        this.rootViewGroup = (ViewGroup)view;
        View view2 = this.findViewById(this.toolbarId);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(toolbarId)");
        Toolbar toolbar = this.toolbar = (Toolbar)view2;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        this.setSupportActionBar(toolbar);
        ReactorNavigation.INSTANCE.getNavigationCommandReceived().addMultipleCallbacks((Object)this, (Function1)new Function1<NavigationCommand, Unit>(this){

            public final void invoke(@NotNull NavigationCommand p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ReactorActivity.access$navigationCommandReceived((ReactorActivity)((Object)this.receiver), p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ReactorActivity.class);
            }

            public final String getName() {
                return "navigationCommandReceived";
            }

            public final String getSignature() {
                return "navigationCommandReceived(Lio/tesseractgroup/reactornavigation/NavigationCommand;)V";
            }
        });
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu) {
        this.activityCreated = true;
        this.updateWithNavState((NavigationStateProtocol)this.getNavigationCore().getCurrentState(), NavigationCommand.RootContainerChanged.INSTANCE);
        return super.onCreateOptionsMenu(menu);
    }

    protected void onPause() {
        View view = this.displayedView();
        if (view != null && view instanceof ReactorView) {
            ((ReactorView)view).setViewIsVisible$reactornavigation_release(false);
        }
        super.onPause();
        this.getNavigationCore().fire((Object)new NavigationEvent.AppContextChanged(false));
    }

    protected void onResume() {
        super.onResume();
        this.getNavigationCore().fire((Object)new NavigationEvent.AppContextChanged(true));
        View view = this.displayedView();
        if (view != null && view instanceof ReactorView) {
            ((ReactorView)view).setViewIsVisible$reactornavigation_release(true);
        }
    }

    protected void onDestroy() {
        View view = this.displayedView();
        if (view != null && view instanceof ReactorView) {
            ((ReactorView)view).viewTearDown();
        }
        super.onDestroy();
        ReactorNavigation.INSTANCE.getNavigationCommandReceived().remove((Object)this);
    }

    private final void navigationCommandReceived(NavigationCommand navigationCommand) {
        if (navigationCommand.getNavStackChanged()) {
            this.updateWithNavState((NavigationStateProtocol)this.getNavigationCore().getCurrentState(), navigationCommand);
        } else if (navigationCommand instanceof NavigationCommand.PresentAlert) {
            this.runOnUiThread(new Runnable(this, navigationCommand){
                final /* synthetic */ ReactorActivity this$0;
                final /* synthetic */ NavigationCommand $navigationCommand;

                public final void run() {
                    Iterator iterator;
                    AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)this.this$0);
                    alertBuilder.setCancelable(false);
                    alertBuilder.setTitle((CharSequence)((NavigationCommand.PresentAlert)this.$navigationCommand).getTitle());
                    alertBuilder.setMessage((CharSequence)((NavigationCommand.PresentAlert)this.$navigationCommand).getMessage());
                    Iterator iterator2 = iterator = CollectionsKt.withIndex(((NavigationCommand.PresentAlert)this.$navigationCommand).getButtons().iterator());
                    while (iterator2.hasNext()) {
                        Function2<DialogInterface, Integer, Unit> function2;
                        IndexedValue indexedValue = (IndexedValue)iterator2.next();
                        int index = indexedValue.component1();
                        AlertButton button = (AlertButton)indexedValue.component2();
                        if (index == 0) {
                            CharSequence charSequence = button.getTitle();
                            Object object = button.getAction();
                            if (object != null) {
                                function2 = object;
                                object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                            }
                            alertBuilder.setPositiveButton(charSequence, (DialogInterface.OnClickListener)object);
                            continue;
                        }
                        if (index == 1) {
                            CharSequence charSequence = button.getTitle();
                            Object object = button.getAction();
                            if (object != null) {
                                function2 = object;
                                object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                            }
                            alertBuilder.setNegativeButton(charSequence, (DialogInterface.OnClickListener)object);
                            continue;
                        }
                        CharSequence charSequence = button.getTitle();
                        Object object = button.getAction();
                        if (object != null) {
                            function2 = object;
                            object = new ReactorActivity$sam$android_content_DialogInterface_OnClickListener$0(function2);
                        }
                        alertBuilder.setNeutralButton(charSequence, (DialogInterface.OnClickListener)object);
                    }
                    alertBuilder.show();
                }
                {
                    this.this$0 = reactorActivity;
                    this.$navigationCommand = navigationCommand;
                }
            });
        }
    }

    private final View displayedView() {
        ViewGroup viewGroup = this.rootViewGroup;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootViewGroup");
        }
        if (viewGroup.getChildCount() > 0) {
            ViewGroup viewGroup2 = this.rootViewGroup;
            if (viewGroup2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rootViewGroup");
            }
            return viewGroup2.getChildAt(0);
        }
        return null;
    }

    private final void updateWithNavState(NavigationStateProtocol state, NavigationCommand command) {
        if (!(command instanceof VisibleViewChanged)) {
            return;
        }
        this.runOnUiThread(new Runnable(this, state, command){
            final /* synthetic */ ReactorActivity this$0;
            final /* synthetic */ NavigationStateProtocol $state;
            final /* synthetic */ NavigationCommand $command;

            public final void run() {
                block0: {
                    block1: {
                        NavContainerState visibleContainer = this.$state.findVisibleContainer();
                        ReactorViewState visibleViewState = this.$state.findVisibleView();
                        if (visibleViewState == null || visibleContainer == null) break block0;
                        ReactorActivity.access$showView(this.this$0, visibleViewState, visibleContainer.getTag(), visibleContainer.getParentTag(), this.$command);
                        ViewContainerState rootContainer = this.$state.getRootViewContainer();
                        String rootTag = rootContainer.getTag();
                        if (!Intrinsics.areEqual((Object)visibleContainer.getTag(), (Object)rootTag) && (!(rootContainer instanceof TabContainerState) || !Intrinsics.areEqual((Object)visibleContainer.getParentTag(), (Object)rootTag))) break block1;
                        Collection collection = visibleContainer.getViewStates();
                        boolean isEnabled = collection.size() > 1;
                        ActionBar actionBar = this.this$0.getSupportActionBar();
                        if (actionBar == null) break block0;
                        actionBar.setDisplayHomeAsUpEnabled(isEnabled);
                        break block0;
                    }
                    ActionBar actionBar = this.this$0.getSupportActionBar();
                    if (actionBar == null) break block0;
                    actionBar.setDisplayHomeAsUpEnabled(true);
                }
            }
            {
                this.this$0 = reactorActivity;
                this.$state = navigationStateProtocol;
                this.$command = navigationCommand;
            }
        });
    }

    private final void showView(ReactorViewState reactorViewState, String containerTag, String parentTag, NavigationCommand command) {
        if (!this.activityCreated) {
            Log.e((String)"NAVIGATION", (String)"Dropping navigation event. Activity not created.");
            return;
        }
        if (this.transitioningMainView) {
            Log.e((String)"NAVIGATION", (String)"In the middle of a transition. Dropping view transition.");
            return;
        }
        View view = this.displayedView();
        if (view == null) {
            Log.e((String)"NAVIGATION", (String)"(Unknown) In the middle of a transition. Dropping view transition.");
            return;
        }
        this.transitioningMainView = true;
        if (view instanceof ReactorView && Intrinsics.areEqual((Object)((ReactorView)view).getViewState(), (Object)reactorViewState) ^ true || !(view instanceof ReactorView)) {
            Toolbar toolbar = this.toolbar;
            if (toolbar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar.setOnMenuItemClickListener(null);
            Toolbar toolbar2 = this.toolbar;
            if (toolbar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar2.setTitle((CharSequence)"");
            if (view instanceof ReactorView) {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Show in main view: " + reactorViewState + " replacing view: " + ((ReactorView)view).getViewState()));
            } else {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Replace initial view: " + reactorViewState));
            }
            this.hideSoftKeyBoard();
            View viewToRemove = view;
            ReactorView viewToShow = this.getViewForState(reactorViewState);
            viewToShow.setContainerTag$reactornavigation_release(containerTag);
            viewToShow.setParentTag$reactornavigation_release(parentTag);
            ViewGroup viewGroup = this.rootViewGroup;
            if (viewGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rootViewGroup");
            }
            viewGroup.removeView(viewToRemove);
            ViewGroup viewGroup2 = this.rootViewGroup;
            if (viewGroup2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rootViewGroup");
            }
            viewGroup2.addView((View)viewToShow);
            if (viewToRemove instanceof ReactorView) {
                ((ReactorView)viewToRemove).viewTearDown();
            }
        }
        this.transitioningMainView = false;
    }

    @NotNull
    public ReactorView getViewForState(@NotNull ReactorViewState reactorViewState) {
        Intrinsics.checkParameterIsNotNull((Object)reactorViewState, (String)"reactorViewState");
        return reactorViewState.view((Context)this);
    }

    private final void hideSoftKeyBoard() {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View currentFocusElement = this.getCurrentFocus();
        if (imm.isAcceptingText() && currentFocusElement != null) {
            imm.hideSoftInputFromWindow(currentFocusElement.getWindowToken(), 0);
        }
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        MenuItem menuItem = item;
        if (menuItem != null) {
            if (menuItem.getItemId() == 16908332) {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        Collection collection;
        String parentContainerTag;
        NavContainerState selectedContainer;
        NavigationStateProtocol state = (NavigationStateProtocol)this.getNavigationCore().getCurrentState();
        NavContainerState navContainerState = selectedContainer = state.getRootViewContainer().findVisibleContainer$reactornavigation_release();
        String string = parentContainerTag = navContainerState != null ? navContainerState.getParentTag() : null;
        if (selectedContainer != null && (collection = (Collection)selectedContainer.getViewStates()).size() > 1) {
            this.getNavigationCore().fire((Object)new NavigationEvent.PopNavView(selectedContainer.getTag()));
        } else if (parentContainerTag != null && (Intrinsics.areEqual((Object)state.getRootViewContainer().getTag(), (Object)parentContainerTag) ^ true || state.getRootViewContainer() instanceof NavContainerState)) {
            this.getNavigationCore().fire((Object)new NavigationEvent.DismissModal(parentContainerTag));
        } else {
            this.finish();
        }
    }

    public ReactorActivity(int layoutId, int toolbarId, int reactorContainerId) {
        this.layoutId = layoutId;
        this.toolbarId = toolbarId;
        this.reactorContainerId = reactorContainerId;
    }

    public static final /* synthetic */ void access$navigationCommandReceived(ReactorActivity $this, @NotNull NavigationCommand navigationCommand) {
        $this.navigationCommandReceived(navigationCommand);
    }

    public static final /* synthetic */ void access$showView(ReactorActivity $this, @NotNull ReactorViewState reactorViewState, @NotNull String containerTag, @Nullable String parentTag, @NotNull NavigationCommand command) {
        $this.showView(reactorViewState, containerTag, parentTag, command);
    }
}

