/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import io.tesseractgroup.reactornavigation.ReactorActivity;
import io.tesseractgroup.reactornavigation.ReactorViewKt;
import io.tesseractgroup.reactornavigation.ReactorViewState;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0006H\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH&J\b\u0010\u001e\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorView;", "Landroid/widget/FrameLayout;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "context", "Landroid/content/Context;", "layoutId", "", "viewState", "Lio/tesseractgroup/reactornavigation/ReactorViewState;", "(Landroid/content/Context;ILio/tesseractgroup/reactornavigation/ReactorViewState;)V", "layoutRequested", "", "value", "viewIsVisible", "setViewIsVisible", "(Z)V", "viewLayedOut", "getViewState", "()Lio/tesseractgroup/reactornavigation/ReactorViewState;", "inflateLayout", "", "onAttachedToWindow", "onGlobalLayout", "onWindowVisibilityChanged", "visibility", "viewDidAppear", "viewDidDisappear", "viewSetup", "toolbar", "Landroid/support/v7/widget/Toolbar;", "viewTearDown", "reactornavigation_release"})
public abstract class ReactorView
extends FrameLayout
implements ViewTreeObserver.OnGlobalLayoutListener {
    private boolean layoutRequested;
    private boolean viewLayedOut;
    private boolean viewIsVisible;
    private final int layoutId;
    @NotNull
    private final ReactorViewState viewState;

    private final void setViewIsVisible(boolean value) {
        if (this.viewIsVisible != value) {
            this.viewIsVisible = value;
            if (value) {
                this.viewDidAppear();
            } else {
                this.viewDidDisappear();
            }
        }
    }

    private final void inflateLayout() {
        LayoutInflater.from((Context)this.getContext()).inflate(this.layoutId, (ViewGroup)this);
        Context context = this.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.tesseractgroup.reactornavigation.ReactorActivity");
        }
        Toolbar toolbar = ((ReactorActivity)context).getToolbar();
        this.viewSetup(toolbar);
        this.getRootView().requestLayout();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        boolean isVisible = visibility == 8 ? false : visibility != 4;
        if (this.viewLayedOut) {
            this.setViewIsVisible(isVisible);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.layoutRequested) {
            this.layoutRequested = true;
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            this.inflateLayout();
        }
    }

    public void onGlobalLayout() {
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        if (!this.viewLayedOut) {
            this.viewLayedOut = true;
            this.setViewIsVisible(true);
        }
    }

    public void viewDidAppear() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View did appear");
    }

    public void viewDidDisappear() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View did disappear");
    }

    public abstract void viewSetup(@NotNull Toolbar var1);

    public void viewTearDown() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View tear down");
    }

    @NotNull
    public ReactorViewState getViewState() {
        return this.viewState;
    }

    public ReactorView(@NotNull Context context, int layoutId, @NotNull ReactorViewState viewState) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)viewState, (String)"viewState");
        super(context, null, 0);
        this.layoutId = layoutId;
        this.viewState = viewState;
    }
}

