/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import io.tesseractgroup.reactornavigation.ReactorActivity;
import io.tesseractgroup.reactornavigation.ReactorViewKt;
import io.tesseractgroup.reactornavigation.ViewStateConvertible;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorView;", "Landroid/widget/FrameLayout;", "Lio/tesseractgroup/reactornavigation/ViewStateConvertible;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "context", "Landroid/content/Context;", "layoutId", "", "(Landroid/content/Context;I)V", "layoutRequested", "", "value", "viewIsVisible", "setViewIsVisible", "(Z)V", "viewLayedOut", "inflateLayout", "", "onAttachedToWindow", "onGlobalLayout", "onWindowVisibilityChanged", "visibility", "viewDidAppear", "viewDidDisappear", "viewSetup", "toolbar", "Landroid/support/v7/widget/Toolbar;", "viewTearDown", "reactornavigation_release"})
public abstract class ReactorView
extends FrameLayout
implements ViewStateConvertible,
ViewTreeObserver.OnGlobalLayoutListener {
    private boolean layoutRequested;
    private boolean viewLayedOut;
    private boolean viewIsVisible;
    private final int layoutId;

    private final void setViewIsVisible(boolean value) {
        if (this.viewIsVisible != value) {
            this.viewIsVisible = value;
            if (value) {
                this.viewDidAppear();
            } else {
                this.viewDidDisappear();
            }
        }
    }

    private final void inflateLayout() {
        LayoutInflater.from((Context)this.getContext()).inflate(this.layoutId, (ViewGroup)this);
        Context context = this.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.tesseractgroup.reactornavigation.ReactorActivity");
        }
        Toolbar toolbar = ((ReactorActivity)context).getToolbar();
        this.viewSetup(toolbar);
        this.getRootView().requestLayout();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        boolean isVisible = visibility == 8 ? false : visibility != 4;
        if (this.viewLayedOut) {
            this.setViewIsVisible(isVisible);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.layoutRequested) {
            this.layoutRequested = true;
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            this.inflateLayout();
        }
    }

    public void onGlobalLayout() {
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        if (!this.viewLayedOut) {
            this.viewLayedOut = true;
            this.setViewIsVisible(true);
        }
    }

    public void viewDidAppear() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View did appear");
    }

    public void viewDidDisappear() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View did disappear");
    }

    public abstract void viewSetup(@NotNull Toolbar var1);

    public void viewTearDown() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View tear down");
    }

    public ReactorView(@NotNull Context context, int layoutId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, null, 0);
        this.layoutId = layoutId;
    }
}

