/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import io.tesseractgroup.reactor.Core;
import io.tesseractgroup.reactornavigation.NavContainerState;
import io.tesseractgroup.reactornavigation.NavigationCommand;
import io.tesseractgroup.reactornavigation.NavigationEvent;
import io.tesseractgroup.reactornavigation.NavigationStateProtocol;
import io.tesseractgroup.reactornavigation.ReactorNavigation;
import io.tesseractgroup.reactornavigation.ReactorView;
import io.tesseractgroup.reactornavigation.ReactorViewState;
import io.tesseractgroup.reactornavigation.ViewStateConvertible;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\u0012\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0014J\u0012\u0010#\u001a\u00020\r2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020\u0018H\u0014J\b\u0010'\u001a\u00020\u0018H\u0014J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\nH\u0002J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\b2\u0006\u0010+\u001a\u00020\nH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/tesseractgroup/reactornavigation/ReactorActivity;", "Landroid/support/v7/app/AppCompatActivity;", "layoutId", "", "toolbarId", "reactorContainerId", "navigationCore", "Lio/tesseractgroup/reactor/Core;", "Lio/tesseractgroup/reactornavigation/NavigationStateProtocol;", "Lio/tesseractgroup/reactornavigation/NavigationEvent;", "Lio/tesseractgroup/reactornavigation/NavigationCommand;", "(IIILio/tesseractgroup/reactor/Core;)V", "activityCreated", "", "rootViewGroup", "Landroid/view/ViewGroup;", "toolbar", "Landroid/support/v7/widget/Toolbar;", "getToolbar", "()Landroid/support/v7/widget/Toolbar;", "setToolbar", "(Landroid/support/v7/widget/Toolbar;)V", "transitioningMainView", "hideSoftKeyBoard", "", "navigationCommandReceived", "navigationCommand", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPause", "onResume", "showView", "reactorViewState", "Lio/tesseractgroup/reactornavigation/ReactorViewState;", "command", "updateWithNavState", "state", "reactornavigation_release"})
public abstract class ReactorActivity
extends AppCompatActivity {
    @NotNull
    public Toolbar toolbar;
    private boolean activityCreated;
    private ViewGroup rootViewGroup;
    private boolean transitioningMainView;
    private final int layoutId;
    private final int toolbarId;
    private final int reactorContainerId;
    private final Core<NavigationStateProtocol, NavigationEvent, NavigationCommand> navigationCore;

    @NotNull
    public final Toolbar getToolbar() {
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        return toolbar;
    }

    public final void setToolbar(@NotNull Toolbar toolbar) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"<set-?>");
        this.toolbar = toolbar;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setContentView(this.layoutId);
        super.onCreate(savedInstanceState);
        View view = this.findViewById(this.reactorContainerId);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(reactorContainerId)");
        this.rootViewGroup = (ViewGroup)view;
        View view2 = this.findViewById(this.toolbarId);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(toolbarId)");
        Toolbar toolbar = this.toolbar = (Toolbar)view2;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        this.setSupportActionBar(toolbar);
        ReactorNavigation.INSTANCE.getNavigationCommandReceived().add((Object)this, (Function1)new Function1<NavigationCommand, Unit>(this){

            public final void invoke(@NotNull NavigationCommand p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ReactorActivity.access$navigationCommandReceived((ReactorActivity)((Object)this.receiver), p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ReactorActivity.class);
            }

            public final String getName() {
                return "navigationCommandReceived";
            }

            public final String getSignature() {
                return "navigationCommandReceived(Lio/tesseractgroup/reactornavigation/NavigationCommand;)V";
            }
        });
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu) {
        this.activityCreated = true;
        this.updateWithNavState((NavigationStateProtocol)this.navigationCore.getCurrentState(), new NavigationCommand());
        return super.onCreateOptionsMenu(menu);
    }

    protected void onPause() {
        super.onPause();
        this.navigationCore.fire((Object)new NavigationEvent.AppContextChanged(false));
    }

    protected void onResume() {
        super.onResume();
        this.navigationCore.fire((Object)new NavigationEvent.AppContextChanged(true));
    }

    protected void onDestroy() {
        super.onDestroy();
        ReactorNavigation.INSTANCE.getNavigationCommandReceived().remove((Object)this);
    }

    private final void navigationCommandReceived(NavigationCommand navigationCommand) {
        this.updateWithNavState((NavigationStateProtocol)this.navigationCore.getCurrentState(), navigationCommand);
    }

    private final void updateWithNavState(NavigationStateProtocol state, NavigationCommand command) {
        block2: {
            block1: {
                Collection collection;
                NavContainerState visibleContainer = state.findVisibleContainer();
                ReactorViewState visibleViewState = state.findVisibleView();
                if (visibleViewState != null) {
                    this.showView(visibleViewState, command);
                }
                if (visibleContainer == null || (collection = (Collection)visibleContainer.getViewStates()).size() <= 1) break block1;
                ActionBar actionBar = this.getSupportActionBar();
                if (actionBar == null) break block2;
                actionBar.setDisplayHomeAsUpEnabled(true);
                break block2;
            }
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar == null) break block2;
            actionBar.setDisplayHomeAsUpEnabled(false);
        }
    }

    private final void showView(ReactorViewState reactorViewState, NavigationCommand command) {
        ViewGroup viewGroup;
        if (!this.activityCreated) {
            Log.e((String)"NAVIGATION", (String)"Dropping navigation event. Activity not created.");
            return;
        }
        if (this.transitioningMainView) {
            Log.e((String)"NAVIGATION", (String)"In the middle of a transition. Dropping view transition.");
            return;
        }
        ViewGroup viewGroup2 = this.rootViewGroup;
        if (viewGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootViewGroup");
        }
        if (viewGroup2.getChildCount() > 0) {
            viewGroup = this.rootViewGroup;
            if (viewGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rootViewGroup");
            }
        } else {
            Log.e((String)"NAVIGATION", (String)"(Unknown) In the middle of a transition. Dropping view transition.");
            return;
        }
        View view = viewGroup.getChildAt(0);
        this.transitioningMainView = true;
        if (view instanceof ViewStateConvertible && Intrinsics.areEqual((Object)((ViewStateConvertible)view).state(), (Object)reactorViewState) ^ true || !(view instanceof ViewStateConvertible)) {
            Toolbar toolbar = this.toolbar;
            if (toolbar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar.setOnMenuItemClickListener(null);
            Toolbar toolbar2 = this.toolbar;
            if (toolbar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar2.setTitle((CharSequence)"");
            Toolbar toolbar3 = this.toolbar;
            if (toolbar3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar3.getMenu().clear();
            if (view instanceof ViewStateConvertible) {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Show in main view: " + reactorViewState + " replacing view: " + ((ViewStateConvertible)view).state()));
            } else {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Replace initial view: " + reactorViewState));
            }
            this.hideSoftKeyBoard();
            View viewToRemove = view;
            ReactorView viewToShow = reactorViewState.view((Context)this);
            ViewGroup viewGroup3 = this.rootViewGroup;
            if (viewGroup3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rootViewGroup");
            }
            viewGroup3.removeView(viewToRemove);
            ViewGroup viewGroup4 = this.rootViewGroup;
            if (viewGroup4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rootViewGroup");
            }
            viewGroup4.addView((View)viewToShow);
            if (viewToRemove instanceof ReactorView) {
                ((ReactorView)viewToRemove).viewTearDown();
            }
        }
        this.transitioningMainView = false;
    }

    private final void hideSoftKeyBoard() {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View currentFocusElement = this.getCurrentFocus();
        if (imm.isAcceptingText() && currentFocusElement != null) {
            imm.hideSoftInputFromWindow(currentFocusElement.getWindowToken(), 0);
        }
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        MenuItem menuItem = item;
        if (menuItem != null) {
            if (menuItem.getItemId() == 16908332) {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        Collection collection;
        String parentContainerTag;
        NavContainerState selectedContainer;
        NavigationStateProtocol state = (NavigationStateProtocol)this.navigationCore.getCurrentState();
        NavContainerState navContainerState = selectedContainer = state.getRootViewContainer().findVisibleContainer$reactornavigation_release();
        String string = parentContainerTag = navContainerState != null ? navContainerState.getParentTag() : null;
        if (parentContainerTag != null) {
            this.navigationCore.fire((Object)new NavigationEvent.DismissModal(parentContainerTag));
        } else if (selectedContainer != null && (collection = (Collection)selectedContainer.getViewStates()).size() > 1) {
            this.navigationCore.fire((Object)new NavigationEvent.PopNavView(selectedContainer.getTag()));
        } else {
            this.finish();
        }
    }

    public ReactorActivity(int layoutId, int toolbarId, int reactorContainerId, @NotNull Core<NavigationStateProtocol, NavigationEvent, NavigationCommand> navigationCore) {
        Intrinsics.checkParameterIsNotNull(navigationCore, (String)"navigationCore");
        this.layoutId = layoutId;
        this.toolbarId = toolbarId;
        this.reactorContainerId = reactorContainerId;
        this.navigationCore = navigationCore;
    }

    public static final /* synthetic */ void access$navigationCommandReceived(ReactorActivity $this, @NotNull NavigationCommand navigationCommand) {
        $this.navigationCommandReceived(navigationCommand);
    }
}

