/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.tesseractgroup.reactornavigation.ReactorActivity;
import io.tesseractgroup.reactornavigation.ReactorViewKt;
import io.tesseractgroup.reactornavigation.ViewStateConvertible;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0006H\u0014J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H&J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorView;", "Landroid/widget/FrameLayout;", "Lio/tesseractgroup/reactornavigation/ViewStateConvertible;", "context", "Landroid/content/Context;", "layoutId", "", "(Landroid/content/Context;I)V", "value", "", "viewIsVisible", "setViewIsVisible", "(Z)V", "viewLayedOut", "inflateLayout", "", "onAttachedToWindow", "onDetachedFromWindow", "onWindowVisibilityChanged", "visibility", "viewDidAppear", "viewDidDisappear", "viewSetup", "toolbar", "Landroid/support/v7/widget/Toolbar;", "viewTearDown", "reactornavigation_release"})
public abstract class ReactorView
extends FrameLayout
implements ViewStateConvertible {
    private boolean viewLayedOut;
    private boolean viewIsVisible;
    private final int layoutId;

    private final void setViewIsVisible(boolean value) {
        if (this.viewIsVisible != value) {
            this.viewIsVisible = value;
            if (value) {
                this.viewDidAppear();
            } else {
                this.viewDidDisappear();
            }
        }
    }

    private final void inflateLayout() {
        LayoutInflater.from((Context)this.getContext()).inflate(this.layoutId, (ViewGroup)this);
        Context context = this.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.tesseractgroup.reactornavigation.ReactorActivity");
        }
        Toolbar toolbar = ((ReactorActivity)context).getToolbar();
        this.viewSetup(toolbar);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        boolean isVisible = visibility == 8 ? false : visibility != 4;
        if (this.viewLayedOut) {
            this.setViewIsVisible(isVisible);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"attached to window");
        if (!this.viewLayedOut) {
            this.inflateLayout();
            this.setViewIsVisible(true);
            this.viewLayedOut = true;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"detached from window");
    }

    public void viewDidAppear() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View did appear");
    }

    public void viewDidDisappear() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View did disappear");
    }

    public abstract void viewSetup(@NotNull Toolbar var1);

    public void viewTearDown() {
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"View tear down");
    }

    public ReactorView(@NotNull Context context, int layoutId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, null, 0);
        this.layoutId = layoutId;
    }
}

