/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import io.tesseractgroup.reactornavigation.NavContainerState;
import io.tesseractgroup.reactornavigation.NavigationCommand;
import io.tesseractgroup.reactornavigation.NavigationEvent;
import io.tesseractgroup.reactornavigation.NavigationStateProtocol;
import io.tesseractgroup.reactornavigation.ReactorActivityViewModelInterface;
import io.tesseractgroup.reactornavigation.ReactorView;
import io.tesseractgroup.reactornavigation.ReactorViewState;
import io.tesseractgroup.reactornavigation.ViewStateConvertible;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0012\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\u0012\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u001bH\u0014J\u0012\u0010$\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020\u001bH\u0014J\b\u0010(\u001a\u00020\u001bH\u0014J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0018\u0010\f\u001a\u00020\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorActivity;", "Landroid/support/v7/app/AppCompatActivity;", "layoutId", "", "toolbarId", "reactorContainerId", "(III)V", "activityCreated", "", "getLayoutId", "()I", "getReactorContainerId", "reactorViewModel", "Lio/tesseractgroup/reactornavigation/ReactorActivityViewModelInterface;", "getReactorViewModel", "()Lio/tesseractgroup/reactornavigation/ReactorActivityViewModelInterface;", "setReactorViewModel", "(Lio/tesseractgroup/reactornavigation/ReactorActivityViewModelInterface;)V", "toolbar", "Landroid/support/v7/widget/Toolbar;", "getToolbar", "()Landroid/support/v7/widget/Toolbar;", "setToolbar", "(Landroid/support/v7/widget/Toolbar;)V", "getToolbarId", "transitioningMainView", "hideSoftKeyBoard", "", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPause", "onResume", "showView", "reactorViewState", "Lio/tesseractgroup/reactornavigation/ReactorViewState;", "command", "Lio/tesseractgroup/reactornavigation/NavigationCommand;", "updateWithNavState", "state", "Lio/tesseractgroup/reactornavigation/NavigationStateProtocol;", "reactornavigation_release"})
public abstract class ReactorActivity
extends AppCompatActivity {
    @NotNull
    public Toolbar toolbar;
    private boolean activityCreated;
    private boolean transitioningMainView;
    private final int layoutId;
    private final int toolbarId;
    private final int reactorContainerId;

    @NotNull
    public abstract ReactorActivityViewModelInterface getReactorViewModel();

    public abstract void setReactorViewModel(@NotNull ReactorActivityViewModelInterface var1);

    @NotNull
    public final Toolbar getToolbar() {
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        return toolbar;
    }

    public final void setToolbar(@NotNull Toolbar toolbar) {
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"<set-?>");
        this.toolbar = toolbar;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setContentView(this.layoutId);
        super.onCreate(savedInstanceState);
        View view = this.findViewById(this.toolbarId);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(toolbarId)");
        Toolbar toolbar = this.toolbar = (Toolbar)view;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
        }
        this.setSupportActionBar(toolbar);
        this.getReactorViewModel().setDelegate(this);
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu) {
        this.activityCreated = true;
        this.updateWithNavState(this.getReactorViewModel().navigationState(), new NavigationCommand());
        return super.onCreateOptionsMenu(menu);
    }

    protected void onPause() {
        super.onPause();
        this.getReactorViewModel().fireEvent(new NavigationEvent.AppContextChanged(false));
    }

    protected void onResume() {
        super.onResume();
        this.getReactorViewModel().fireEvent(new NavigationEvent.AppContextChanged(true));
    }

    protected void onDestroy() {
        super.onDestroy();
        this.getReactorViewModel().destroy();
    }

    public void updateWithNavState(@NotNull NavigationStateProtocol state, @NotNull NavigationCommand command) {
        block2: {
            block1: {
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
                NavContainerState visibleContainer = state.findVisibleContainer();
                ReactorViewState visibleViewState = state.findVisibleView();
                if (visibleViewState != null) {
                    this.showView(visibleViewState, command);
                }
                if (visibleContainer == null || (collection = (Collection)visibleContainer.getViewStates()).size() <= 1) break block1;
                ActionBar actionBar = this.getSupportActionBar();
                if (actionBar == null) break block2;
                actionBar.setDisplayHomeAsUpEnabled(true);
                break block2;
            }
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar == null) break block2;
            actionBar.setDisplayHomeAsUpEnabled(false);
        }
    }

    private final void showView(ReactorViewState reactorViewState, NavigationCommand command) {
        ViewGroup rootViewGroup;
        if (!this.activityCreated) {
            Log.e((String)"NAVIGATION", (String)"Dropping navigation event. Activity not created.");
            return;
        }
        if (this.transitioningMainView) {
            Log.e((String)"NAVIGATION", (String)"Dropping navigation event. In the middle of a transition.");
            return;
        }
        ViewGroup viewGroup = rootViewGroup = (ViewGroup)this.findViewById(this.reactorContainerId);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewGroup, (String)"rootViewGroup");
        if (viewGroup.getChildCount() <= 0) {
            Log.e((String)"NAVIGATION", (String)"Dropping navigation event. In the middle of a transition.");
            return;
        }
        View view = rootViewGroup.getChildAt(0);
        this.transitioningMainView = true;
        if (view instanceof ViewStateConvertible && Intrinsics.areEqual((Object)((ViewStateConvertible)view).state(), (Object)reactorViewState) ^ true || !(view instanceof ViewStateConvertible)) {
            Toolbar toolbar = this.toolbar;
            if (toolbar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar.setOnMenuItemClickListener(null);
            Toolbar toolbar2 = this.toolbar;
            if (toolbar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar2.setTitle((CharSequence)"");
            Toolbar toolbar3 = this.toolbar;
            if (toolbar3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            }
            toolbar3.getMenu().clear();
            if (view instanceof ViewStateConvertible) {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Show in main view: " + reactorViewState + " replacing view: " + ((ViewStateConvertible)view).state()));
            } else {
                Log.d((String)"REACTOR_NAVIGATION", (String)("Replace initial view: " + reactorViewState));
            }
            this.hideSoftKeyBoard();
            View viewToRemove = view;
            ReactorView viewToShow = reactorViewState.view((Context)this);
            rootViewGroup.removeView(viewToRemove);
            rootViewGroup.addView((View)viewToShow);
            if (viewToRemove instanceof ReactorView) {
                ((ReactorView)viewToRemove).viewTearDown();
            }
        }
        this.transitioningMainView = false;
    }

    private final void hideSoftKeyBoard() {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View currentFocusElement = this.getCurrentFocus();
        if (imm.isAcceptingText() && currentFocusElement != null) {
            imm.hideSoftInputFromWindow(currentFocusElement.getWindowToken(), 0);
        }
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        MenuItem menuItem = item;
        if (menuItem != null) {
            if (menuItem.getItemId() == 16908332) {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        Collection collection;
        String parentContainerTag;
        NavContainerState selectedContainer;
        NavigationStateProtocol state = this.getReactorViewModel().navigationState();
        NavContainerState navContainerState = selectedContainer = state.getRootViewContainer().findVisibleContainer$reactornavigation_release();
        String string = parentContainerTag = navContainerState != null ? navContainerState.getParentTag() : null;
        if (parentContainerTag != null) {
            this.getReactorViewModel().fireEvent(new NavigationEvent.DismissModal(parentContainerTag));
        } else if (selectedContainer != null && (collection = (Collection)selectedContainer.getViewStates()).size() > 1) {
            this.getReactorViewModel().fireEvent(new NavigationEvent.PopNavView(selectedContainer.getTag()));
        } else {
            this.finish();
        }
    }

    public final int getLayoutId() {
        return this.layoutId;
    }

    public final int getToolbarId() {
        return this.toolbarId;
    }

    public final int getReactorContainerId() {
        return this.reactorContainerId;
    }

    public ReactorActivity(int layoutId, int toolbarId, int reactorContainerId) {
        this.layoutId = layoutId;
        this.toolbarId = toolbarId;
        this.reactorContainerId = reactorContainerId;
    }
}

