/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import io.tesseractgroup.reactor.Core;
import io.tesseractgroup.reactor.Event;
import io.tesseractgroup.reactor.State;
import io.tesseractgroup.reactor.Subscriber;
import io.tesseractgroup.reactornavigation.NavigationStateProtocol;
import io.tesseractgroup.reactornavigation.ReactorActivity;
import io.tesseractgroup.reactornavigation.ReactorActivityViewModelInterface;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B'\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\u0012\u0010\u0017\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u0015\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorActivityViewModel;", "StateType", "Lio/tesseractgroup/reactor/State;", "Lio/tesseractgroup/reactornavigation/ReactorActivityViewModelInterface;", "Lio/tesseractgroup/reactor/Subscriber;", "sharedCore", "Lio/tesseractgroup/reactor/Core;", "navStateSelector", "Lkotlin/Function1;", "Lio/tesseractgroup/reactornavigation/NavigationStateProtocol;", "(Lio/tesseractgroup/reactor/Core;Lkotlin/jvm/functions/Function1;)V", "delegate", "Ljava/lang/ref/WeakReference;", "Lio/tesseractgroup/reactornavigation/ReactorActivity;", "getNavStateSelector", "()Lkotlin/jvm/functions/Function1;", "getSharedCore", "()Lio/tesseractgroup/reactor/Core;", "fireEvent", "", "event", "Lio/tesseractgroup/reactor/Event;", "navigationState", "setDelegate", "startListening", "stopListening", "updateWith", "state", "(Lio/tesseractgroup/reactor/State;)V", "reactornavigation_release"})
public final class ReactorActivityViewModel<StateType extends State>
implements ReactorActivityViewModelInterface,
Subscriber<StateType> {
    private WeakReference<ReactorActivity> delegate;
    @NotNull
    private final Core<StateType> sharedCore;
    @NotNull
    private final Function1<StateType, NavigationStateProtocol> navStateSelector;

    @Override
    public void setDelegate(@Nullable ReactorActivity delegate) {
        if (delegate != null) {
            this.delegate = new WeakReference<ReactorActivity>(delegate);
            this.sharedCore.add((Subscriber)this);
        } else {
            this.sharedCore.remove((Subscriber)this);
            this.delegate = null;
        }
    }

    @Override
    @NotNull
    public NavigationStateProtocol navigationState() {
        return (NavigationStateProtocol)this.navStateSelector.invoke((Object)this.sharedCore.getState());
    }

    public void updateWith(@NotNull StateType state) {
        block0: {
            Intrinsics.checkParameterIsNotNull(state, (String)"state");
            NavigationStateProtocol navState = (NavigationStateProtocol)this.navStateSelector.invoke(state);
            Object object = this.delegate;
            if (object == null || (object = (ReactorActivity)((Object)((Reference)object).get())) == null) break block0;
            ((ReactorActivity)((Object)object)).updateWith(navState);
        }
    }

    @Override
    public void fireEvent(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.sharedCore.fire(event);
    }

    @Override
    public void startListening() {
        this.sharedCore.add((Subscriber)this);
    }

    @Override
    public void stopListening() {
        this.sharedCore.remove((Subscriber)this);
    }

    @NotNull
    public final Core<StateType> getSharedCore() {
        return this.sharedCore;
    }

    @NotNull
    public final Function1<StateType, NavigationStateProtocol> getNavStateSelector() {
        return this.navStateSelector;
    }

    public ReactorActivityViewModel(@NotNull Core<StateType> sharedCore, @NotNull Function1<? super StateType, ? extends NavigationStateProtocol> navStateSelector) {
        Intrinsics.checkParameterIsNotNull(sharedCore, (String)"sharedCore");
        Intrinsics.checkParameterIsNotNull(navStateSelector, (String)"navStateSelector");
        this.sharedCore = sharedCore;
        this.navStateSelector = navStateSelector;
    }
}

