/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import io.tesseractgroup.reactornavigation.ReactorViewKt;
import io.tesseractgroup.reactornavigation.ViewStateConvertible;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0014J\b\u0010\u0011\u001a\u00020\fH&J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorView;", "Landroid/widget/FrameLayout;", "Lio/tesseractgroup/reactornavigation/ViewStateConvertible;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "context", "Landroid/content/Context;", "layoutId", "", "(Landroid/content/Context;I)V", "viewLayedOut", "", "onAttachedToWindow", "", "onDetachedFromWindow", "onGlobalLayout", "onWindowVisibilityChanged", "visibility", "viewSetup", "viewVisibilityChanged", "hidden", "reactornavigation_release"})
public abstract class ReactorView
extends FrameLayout
implements ViewStateConvertible,
ViewTreeObserver.OnGlobalLayoutListener {
    private boolean viewLayedOut;

    public void onGlobalLayout() {
        if (!this.viewLayedOut) {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(new Runnable(this){
                final /* synthetic */ ReactorView this$0;

                public final void run() {
                    this.this$0.viewSetup();
                    boolean hidden = this.this$0.getVisibility() != 0;
                    this.this$0.viewVisibilityChanged(hidden);
                }
                {
                    this.this$0 = reactorView;
                }
            });
        }
        Log.i((String)"NAVIGATION", (String)"Layout callback");
        this.viewLayedOut = true;
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        String visibilityStr = "Visibile";
        boolean hidden = false;
        if (visibility == 8) {
            visibilityStr = "Gone";
            hidden = true;
        } else if (visibility == 4) {
            visibilityStr = "Hidden";
            hidden = true;
        } else {
            hidden = false;
        }
        if (this.viewLayedOut) {
            this.viewVisibilityChanged(hidden);
        }
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)("Visibility changed: " + visibilityStr));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"attached to window");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.i((String)("NAVIGATION_" + ReactorViewKt.className((View)this) + ')'), (String)"detached from window");
    }

    public void viewVisibilityChanged(boolean hidden) {
    }

    public abstract void viewSetup();

    public ReactorView(@NotNull Context context, int layoutId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, null, 0);
        Log.i((String)"NAVIGATIION", (String)"init in base view");
        LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)this);
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }
}

