/*
 * Decompiled with CFR 0.152.
 */
package io.tesseractgroup.reactornavigation;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import io.tesseractgroup.reactornavigation.NavContainerState;
import io.tesseractgroup.reactornavigation.NavigationEvent;
import io.tesseractgroup.reactornavigation.NavigationStateProtocol;
import io.tesseractgroup.reactornavigation.ReactorActivityViewModelInterface;
import io.tesseractgroup.reactornavigation.ReactorViewState;
import io.tesseractgroup.reactornavigation.ViewContainerState;
import io.tesseractgroup.reactornavigation.ViewStateConvertible;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B!\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0014J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0014J\b\u0010\u001c\u001a\u00020\u0012H\u0014J\u0012\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u0012H&J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0018\u0010\u000b\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lio/tesseractgroup/reactornavigation/ReactorActivity;", "Landroid/support/v7/app/AppCompatActivity;", "args", "Landroid/os/Bundle;", "reactorContainerId", "", "reactorModalId", "(Landroid/os/Bundle;II)V", "getReactorContainerId", "()I", "getReactorModalId", "reactorViewModel", "Lio/tesseractgroup/reactornavigation/ReactorActivityViewModelInterface;", "getReactorViewModel", "()Lio/tesseractgroup/reactornavigation/ReactorActivityViewModelInterface;", "setReactorViewModel", "(Lio/tesseractgroup/reactornavigation/ReactorActivityViewModelInterface;)V", "hideSoftKeyBoard", "", "onBackPressed", "onCreate", "savedInstanceState", "onDestroy", "onOptionsItemSelected", "", "item", "Landroid/view/MenuItem;", "onStart", "onStop", "showOverlayView", "reactorViewState", "Lio/tesseractgroup/reactornavigation/ReactorViewState;", "showView", "stateUpdated", "updateWithNavState", "state", "Lio/tesseractgroup/reactornavigation/NavigationStateProtocol;", "reactornavigation_release"})
public abstract class ReactorActivity
extends AppCompatActivity {
    private final int reactorContainerId;
    private final int reactorModalId;

    @NotNull
    public abstract ReactorActivityViewModelInterface getReactorViewModel();

    public abstract void setReactorViewModel(@NotNull ReactorActivityViewModelInterface var1);

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getReactorViewModel().setDelegate(this);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.getReactorViewModel().stopListening();
    }

    protected void onStart() {
        super.onStart();
        this.getReactorViewModel().startListening();
    }

    protected void onStop() {
        super.onStop();
        this.getReactorViewModel().stopListening();
    }

    public void updateWithNavState(@NotNull NavigationStateProtocol state) {
        block2: {
            block1: {
                Collection collection;
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                ViewContainerState rootContainer = state.getRootViewContainer();
                ReactorViewState overlay = state.getOverlay();
                NavContainerState visibleContainer = rootContainer.findVisibleContainer$reactornavigation_release();
                ReactorViewState visibleViewState = rootContainer.findVisibleView$reactornavigation_release();
                if (visibleViewState != null) {
                    this.showView(visibleViewState);
                }
                this.showOverlayView(overlay);
                if (visibleContainer == null || (collection = (Collection)visibleContainer.getViewStates()).size() <= 1) break block1;
                ActionBar actionBar = this.getSupportActionBar();
                if (actionBar == null) break block2;
                actionBar.setDisplayHomeAsUpEnabled(true);
                break block2;
            }
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar == null) break block2;
            actionBar.setDisplayHomeAsUpEnabled(false);
        }
    }

    public abstract void stateUpdated();

    private final void showView(ReactorViewState reactorViewState) {
        ViewGroup rootViewGroup;
        ViewGroup viewGroup = rootViewGroup = (ViewGroup)this.findViewById(this.reactorContainerId);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewGroup, (String)"rootViewGroup");
        View view = viewGroup.getChildCount() > 0 ? rootViewGroup.getChildAt(0) : (View)null;
        if (view == null) {
            return;
        }
        if (view instanceof ViewStateConvertible && Intrinsics.areEqual((Object)((ViewStateConvertible)view).state(), (Object)reactorViewState) ^ true) {
            Log.d((String)"REACTOR_NAVIGATION", (String)("Show in main view: " + reactorViewState + " replacing view: " + ((ViewStateConvertible)view).state()));
            this.hideSoftKeyBoard();
            rootViewGroup.removeView(view);
            rootViewGroup.addView(reactorViewState.view((Context)this));
        } else if (!(view instanceof ViewStateConvertible)) {
            Log.d((String)"REACTOR_NAVIGATION", (String)("Replace initial view: " + reactorViewState));
            rootViewGroup.removeView(view);
            rootViewGroup.addView(reactorViewState.view((Context)this));
        }
    }

    private final void hideSoftKeyBoard() {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View currentFocusElement = this.getCurrentFocus();
        if (imm.isAcceptingText() && currentFocusElement != null) {
            imm.hideSoftInputFromWindow(currentFocusElement.getWindowToken(), 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void showOverlayView(ReactorViewState reactorViewState) {
        ViewGroup rootViewGroup = (ViewGroup)this.findViewById(this.reactorModalId);
        if (reactorViewState == null) {
            ViewGroup viewGroup = rootViewGroup;
            Intrinsics.checkExpressionValueIsNotNull((Object)viewGroup, (String)"rootViewGroup");
            if (viewGroup.getChildCount() > 0) {
                this.hideSoftKeyBoard();
                rootViewGroup.removeAllViews();
                rootViewGroup.setVisibility(8);
                return;
            }
        }
        if (reactorViewState == null) return;
        ViewGroup viewGroup = rootViewGroup;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewGroup, (String)"rootViewGroup");
        if (viewGroup.getChildCount() != 0) return;
        Log.d((String)"REACTOR_NAVIGATION", (String)("Show in overlay view: " + reactorViewState));
        this.hideSoftKeyBoard();
        rootViewGroup.addView(reactorViewState.view((Context)this));
        rootViewGroup.setVisibility(0);
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        MenuItem menuItem = item;
        if (menuItem != null) {
            if (menuItem.getItemId() == 16908332) {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        Collection collection;
        String parentContainerTag;
        NavContainerState selectedContainer;
        NavigationStateProtocol state = this.getReactorViewModel().navigationState();
        NavContainerState navContainerState = selectedContainer = state.getRootViewContainer().findVisibleContainer$reactornavigation_release();
        String string = parentContainerTag = navContainerState != null ? navContainerState.getParentContainerTag() : null;
        if (state.getOverlay() != null) {
            this.getReactorViewModel().fireEvent(new NavigationEvent.DismissOverlay());
        } else if (parentContainerTag != null) {
            this.getReactorViewModel().fireEvent(new NavigationEvent.DismissModal(parentContainerTag));
        } else if (selectedContainer != null && (collection = (Collection)selectedContainer.getViewStates()).size() > 1) {
            this.getReactorViewModel().fireEvent(new NavigationEvent.PopNavView(selectedContainer.getContainerTag()));
        } else {
            this.finish();
        }
    }

    public final int getReactorContainerId() {
        return this.reactorContainerId;
    }

    public final int getReactorModalId() {
        return this.reactorModalId;
    }

    public ReactorActivity(@Nullable Bundle args, int reactorContainerId, int reactorModalId) {
        this.reactorContainerId = reactorContainerId;
        this.reactorModalId = reactorModalId;
    }

    public /* synthetic */ ReactorActivity(Bundle bundle, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            bundle = null;
        }
        this(bundle, n, n2);
    }
}

