/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.base.Preconditions;
import io.temporal.common.interceptors.ActivityInterceptor;
import io.temporal.common.interceptors.WorkflowInterceptor;
import java.time.Duration;

public class WorkerFactoryOptions {
    private static final int DEFAULT_HOST_LOCAL_WORKFLOW_POLL_THREAD_COUNT = 5;
    private static final int DEFAULT_WORKFLOW_CACHE_SIZE = 600;
    private static final int DEFAULT_MAX_WORKFLOW_THREAD_COUNT = 600;
    private static final Duration DEFAULT_STICKY_SCHEDULE_TO_START_TIMEOUT = Duration.ofSeconds(5L);
    private static final WorkerFactoryOptions DEFAULT_INSTANCE = WorkerFactoryOptions.newBuilder().build();
    private final int workflowCacheSize;
    private final int maxWorkflowThreadCount;
    private final Duration workflowHostLocalTaskQueueScheduleToStartTimeout;
    private final WorkflowInterceptor[] workflowInterceptors;
    private final ActivityInterceptor[] activityInterceptors;
    private final boolean enableLoggingInReplay;
    private final int workflowHostLocalPollThreadCount;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkerFactoryOptions options) {
        return new Builder(options);
    }

    public static WorkerFactoryOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkerFactoryOptions(int workflowCacheSize, int maxWorkflowThreadCount, Duration workflowHostLocalTaskQueueScheduleToStartTimeout, WorkflowInterceptor[] workflowInterceptors, ActivityInterceptor[] activityInterceptors, boolean enableLoggingInReplay, int workflowHostLocalPollThreadCount, boolean validate) {
        if (validate) {
            Preconditions.checkState((workflowCacheSize >= 0 ? 1 : 0) != 0, (Object)"negative workflowCacheSize");
            if (workflowCacheSize <= 0) {
                workflowCacheSize = 600;
            }
            Preconditions.checkState((maxWorkflowThreadCount >= 0 ? 1 : 0) != 0, (Object)"negative maxWorkflowThreadCount");
            if (maxWorkflowThreadCount == 0) {
                maxWorkflowThreadCount = 600;
            }
            if (workflowHostLocalTaskQueueScheduleToStartTimeout != null) {
                Preconditions.checkState((!workflowHostLocalTaskQueueScheduleToStartTimeout.isNegative() ? 1 : 0) != 0, (Object)"negative workflowHostLocalTaskQueueScheduleToStartTimeoutSeconds");
            }
            if (workflowHostLocalTaskQueueScheduleToStartTimeout == null) {
                workflowHostLocalTaskQueueScheduleToStartTimeout = DEFAULT_STICKY_SCHEDULE_TO_START_TIMEOUT;
            }
            if (workflowInterceptors == null) {
                workflowInterceptors = new WorkflowInterceptor[]{};
            }
            Preconditions.checkState((workflowHostLocalPollThreadCount >= 0 ? 1 : 0) != 0, (Object)"negative workflowHostLocalPollThreadCount");
            if (workflowHostLocalPollThreadCount == 0) {
                workflowHostLocalPollThreadCount = 5;
            }
        }
        this.workflowCacheSize = workflowCacheSize;
        this.maxWorkflowThreadCount = maxWorkflowThreadCount;
        this.workflowHostLocalTaskQueueScheduleToStartTimeout = workflowHostLocalTaskQueueScheduleToStartTimeout;
        this.workflowInterceptors = workflowInterceptors;
        this.activityInterceptors = activityInterceptors;
        this.enableLoggingInReplay = enableLoggingInReplay;
        this.workflowHostLocalPollThreadCount = workflowHostLocalPollThreadCount;
    }

    public int getWorkflowCacheSize() {
        return this.workflowCacheSize;
    }

    public int getMaxWorkflowThreadCount() {
        return this.maxWorkflowThreadCount;
    }

    public Duration getWorkflowHostLocalTaskQueueScheduleToStartTimeout() {
        return this.workflowHostLocalTaskQueueScheduleToStartTimeout;
    }

    public WorkflowInterceptor[] getWorkflowInterceptors() {
        return this.workflowInterceptors;
    }

    public ActivityInterceptor[] getActivityInterceptors() {
        return this.activityInterceptors;
    }

    public boolean isEnableLoggingInReplay() {
        return this.enableLoggingInReplay;
    }

    public int getWorkflowHostLocalPollThreadCount() {
        return this.workflowHostLocalPollThreadCount;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Duration workflowHostLocalTaskQueueScheduleToStartTimeout;
        private int workflowCacheSize;
        private int maxWorkflowThreadCount;
        private WorkflowInterceptor[] workflowInterceptors;
        private ActivityInterceptor[] activityInterceptors;
        private boolean enableLoggingInReplay;
        private int workflowHostLocalPollThreadCount;

        private Builder() {
        }

        private Builder(WorkerFactoryOptions options) {
            if (options == null) {
                return;
            }
            this.workflowHostLocalTaskQueueScheduleToStartTimeout = options.workflowHostLocalTaskQueueScheduleToStartTimeout;
            this.workflowCacheSize = options.workflowCacheSize;
            this.maxWorkflowThreadCount = options.maxWorkflowThreadCount;
            this.workflowInterceptors = options.workflowInterceptors;
            this.activityInterceptors = options.activityInterceptors;
            this.enableLoggingInReplay = options.enableLoggingInReplay;
            this.workflowHostLocalPollThreadCount = options.workflowHostLocalPollThreadCount;
        }

        public Builder setWorkflowCacheSize(int workflowCacheSize) {
            this.workflowCacheSize = workflowCacheSize;
            return this;
        }

        public Builder setMaxWorkflowThreadCount(int maxWorkflowThreadCount) {
            this.maxWorkflowThreadCount = maxWorkflowThreadCount;
            return this;
        }

        public Builder setWorkflowHostLocalTaskQueueScheduleToStartTimeout(Duration timeout) {
            this.workflowHostLocalTaskQueueScheduleToStartTimeout = timeout;
            return this;
        }

        public Builder setWorkflowInterceptors(WorkflowInterceptor ... workflowInterceptors) {
            this.workflowInterceptors = workflowInterceptors;
            return this;
        }

        public Builder setActivityInterceptors(ActivityInterceptor ... activityInterceptors) {
            this.activityInterceptors = activityInterceptors;
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        public Builder setWorkflowHostLocalPollThreadCount(int workflowHostLocalPollThreadCount) {
            this.workflowHostLocalPollThreadCount = workflowHostLocalPollThreadCount;
            return this;
        }

        public WorkerFactoryOptions build() {
            return new WorkerFactoryOptions(this.workflowCacheSize, this.maxWorkflowThreadCount, this.workflowHostLocalTaskQueueScheduleToStartTimeout, this.workflowInterceptors, this.activityInterceptors, this.enableLoggingInReplay, this.workflowHostLocalPollThreadCount, false);
        }

        public WorkerFactoryOptions validateAndBuildWithDefaults() {
            return new WorkerFactoryOptions(this.workflowCacheSize, this.maxWorkflowThreadCount, this.workflowHostLocalTaskQueueScheduleToStartTimeout, this.workflowInterceptors == null ? new WorkflowInterceptor[]{} : this.workflowInterceptors, this.activityInterceptors == null ? new ActivityInterceptor[]{} : this.activityInterceptors, this.enableLoggingInReplay, this.workflowHostLocalPollThreadCount, true);
        }
    }
}

