/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.GrpcRetryer;
import io.temporal.internal.common.RpcRetryOptions;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.worker.NoopSuspendableWorker;
import io.temporal.internal.worker.PollTaskExecutor;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkflowPollTask;
import io.temporal.internal.worker.WorkflowRunLockManager;
import io.temporal.internal.worker.WorkflowTaskHandler;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.slf4j.MDC;

public final class WorkflowWorker
implements SuspendableWorker,
Functions.Proc1<PollWorkflowTaskQueueResponse> {
    private static final String POLL_THREAD_NAME_PREFIX = "Workflow Poller taskQueue=";
    private SuspendableWorker poller = new NoopSuspendableWorker();
    private PollTaskExecutor<PollWorkflowTaskQueueResponse> pollTaskExecutor;
    private final WorkflowTaskHandler handler;
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private final String stickyTaskQueueName;
    private final WorkflowRunLockManager runLocks = new WorkflowRunLockManager();

    public WorkflowWorker(WorkflowServiceStubs service, String namespace, String taskQueue, SingleWorkerOptions options, WorkflowTaskHandler handler, String stickyTaskQueueName) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.handler = handler;
        this.stickyTaskQueueName = stickyTaskQueueName;
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix("Workflow Poller taskQueue=\"" + taskQueue + "\", namespace=\"" + namespace + "\"").build();
        }
        this.options = SingleWorkerOptions.newBuilder(options).setPollerOptions(pollerOptions).build();
    }

    @Override
    public void start() {
        if (this.handler.isAnyTypeSupported()) {
            this.pollTaskExecutor = new PollTaskExecutor<PollWorkflowTaskQueueResponse>(this.namespace, this.taskQueue, this.options, new TaskHandlerImpl(this.handler));
            this.poller = new Poller<PollWorkflowTaskQueueResponse>(this.options.getIdentity(), new WorkflowPollTask(this.service, this.namespace, this.taskQueue, this.options.getMetricsScope(), this.options.getIdentity(), this.options.getBinaryChecksum()), this.pollTaskExecutor, this.options.getPollerOptions(), this.options.getMetricsScope());
            this.poller.start();
            this.options.getMetricsScope().counter("temporal_worker_start").inc(1L);
        }
    }

    @Override
    public boolean isStarted() {
        if (this.poller == null) {
            return false;
        }
        return this.poller.isStarted();
    }

    @Override
    public boolean isShutdown() {
        if (this.poller == null) {
            return true;
        }
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (this.poller == null) {
            return true;
        }
        return this.poller.isTerminated();
    }

    public Optional<Payloads> queryWorkflowExecution(WorkflowExecution exec, String queryType, Optional<Payloads> args) throws Exception {
        GetWorkflowExecutionHistoryResponse historyResponse = WorkflowExecutionUtils.getHistoryPage(this.service, this.namespace, exec, ByteString.EMPTY, this.options.getMetricsScope());
        History history = historyResponse.getHistory();
        WorkflowExecutionHistory workflowExecutionHistory = new WorkflowExecutionHistory(history);
        return this.queryWorkflowExecution(queryType, args, workflowExecutionHistory, historyResponse.getNextPageToken());
    }

    public Optional<Payloads> queryWorkflowExecution(String jsonSerializedHistory, String queryType, Optional<Payloads> args) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        return this.queryWorkflowExecution(queryType, args, history, ByteString.EMPTY);
    }

    public Optional<Payloads> queryWorkflowExecution(WorkflowExecutionHistory history, String queryType, Optional<Payloads> args) throws Exception {
        return this.queryWorkflowExecution(queryType, args, history, ByteString.EMPTY);
    }

    private Optional<Payloads> queryWorkflowExecution(String queryType, Optional<Payloads> args, WorkflowExecutionHistory history, ByteString nextPageToken) throws Exception {
        WorkflowQuery.Builder query = WorkflowQuery.newBuilder().setQueryType(queryType);
        if (args.isPresent()) {
            query.setQueryArgs(args.get());
        }
        PollWorkflowTaskQueueResponse.Builder task = PollWorkflowTaskQueueResponse.newBuilder().setWorkflowExecution(history.getWorkflowExecution()).setStartedEventId(Long.MAX_VALUE).setPreviousStartedEventId(Long.MAX_VALUE).setNextPageToken(nextPageToken).setQuery(query);
        List<HistoryEvent> events = history.getEvents();
        HistoryEvent startedEvent = events.get(0);
        WorkflowExecutionStartedEventAttributes started = startedEvent.getWorkflowExecutionStartedEventAttributes();
        if (started == null) {
            throw new IllegalStateException("First event of the history is not WorkflowExecutionStarted: " + startedEvent);
        }
        WorkflowType workflowType = started.getWorkflowType();
        task.setWorkflowType(workflowType);
        task.setHistory(History.newBuilder().addAllEvents(events));
        WorkflowTaskHandler.Result result = this.handler.handleWorkflowTask(task.build());
        if (result.getQueryCompleted() != null) {
            RespondQueryTaskCompletedRequest r = result.getQueryCompleted();
            if (!r.getErrorMessage().isEmpty()) {
                throw new RuntimeException("query failure for " + history.getWorkflowExecution() + ", queryType=" + queryType + ", args=" + args + ", error=" + r.getErrorMessage());
            }
            if (r.hasQueryResult()) {
                return Optional.of(r.getQueryResult());
            }
            return Optional.empty();
        }
        throw new RuntimeException("Query returned wrong response: " + result);
    }

    @Override
    public void shutdown() {
        if (this.poller == null) {
            return;
        }
        this.poller.shutdown();
    }

    @Override
    public void shutdownNow() {
        if (this.poller == null) {
            return;
        }
        this.poller.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        if (this.poller == null || !this.poller.isStarted()) {
            return;
        }
        this.poller.awaitTermination(timeout, unit);
    }

    @Override
    public void suspendPolling() {
        if (this.poller == null) {
            return;
        }
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        if (this.poller == null) {
            return;
        }
        this.poller.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        if (this.poller == null) {
            return false;
        }
        return this.poller.isSuspended();
    }

    @Override
    public void apply(PollWorkflowTaskQueueResponse pollWorkflowTaskQueueResponse) {
        this.pollTaskExecutor.process(pollWorkflowTaskQueueResponse);
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<PollWorkflowTaskQueueResponse> {
        final WorkflowTaskHandler handler;

        private TaskHandlerImpl(WorkflowTaskHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PollWorkflowTaskQueueResponse task) throws Exception {
            Scope metricsScope = WorkflowWorker.this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"WorkflowType", (Object)task.getWorkflowType().getName()));
            MDC.put((String)"WorkflowId", (String)task.getWorkflowExecution().getWorkflowId());
            MDC.put((String)"WorkflowType", (String)task.getWorkflowType().getName());
            MDC.put((String)"RunId", (String)task.getWorkflowExecution().getRunId());
            Lock runLock = null;
            if (!Strings.isNullOrEmpty((String)WorkflowWorker.this.stickyTaskQueueName)) {
                runLock = WorkflowWorker.this.runLocks.getLockForLocking(task.getWorkflowExecution().getRunId());
                runLock.lock();
            }
            Stopwatch swTotal = metricsScope.timer("temporal_workflow_task_execution_total_latency").start();
            try {
                Optional<PollWorkflowTaskQueueResponse> nextTask = Optional.of(task);
                do {
                    WorkflowTaskHandler.Result response;
                    Stopwatch sw = metricsScope.timer("temporal_workflow_task_execution_latency").start();
                    try {
                        response = this.handler.handleWorkflowTask(nextTask.get());
                    }
                    finally {
                        sw.stop();
                    }
                    nextTask = this.sendReply(WorkflowWorker.this.service, metricsScope, nextTask.get().getTaskToken(), response);
                    if (!nextTask.isPresent()) continue;
                    metricsScope.counter("temporal_workflow_task_heartbeat").inc(1L);
                } while (nextTask.isPresent());
            }
            finally {
                swTotal.stop();
                MDC.remove((String)"WorkflowId");
                MDC.remove((String)"WorkflowType");
                MDC.remove((String)"RunId");
                if (runLock != null) {
                    WorkflowWorker.this.runLocks.unlock(task.getWorkflowExecution().getRunId());
                }
            }
        }

        @Override
        public Throwable wrapFailure(PollWorkflowTaskQueueResponse task, Throwable failure) {
            WorkflowExecution execution = task.getWorkflowExecution();
            return new RuntimeException("Failure processing workflow task. WorkflowId=" + execution.getWorkflowId() + ", RunId=" + execution.getRunId(), failure);
        }

        private Optional<PollWorkflowTaskQueueResponse> sendReply(WorkflowServiceStubs service, Scope metricsScope, ByteString taskToken, WorkflowTaskHandler.Result response) {
            RpcRetryOptions ro = response.getRequestRetryOptions();
            RespondWorkflowTaskCompletedRequest taskCompleted = response.getTaskCompleted();
            if (taskCompleted != null) {
                ro = RpcRetryOptions.newBuilder().setRetryOptions(ro).validateBuildWithDefaults();
                RespondWorkflowTaskCompletedRequest request = taskCompleted.toBuilder().setIdentity(WorkflowWorker.this.options.getIdentity()).setNamespace(WorkflowWorker.this.namespace).setBinaryChecksum(WorkflowWorker.this.options.getBinaryChecksum()).setTaskToken(taskToken).build();
                ImmutableMap tags = new ImmutableMap.Builder(4).put((Object)"WorkflowType", (Object)response.getWorkflowType()).build();
                AtomicReference nextTask = new AtomicReference();
                GrpcRetryer.retry(ro, () -> TaskHandlerImpl.lambda$sendReply$0(nextTask, service, metricsScope, (Map)tags, request));
                if (((RespondWorkflowTaskCompletedResponse)nextTask.get()).hasWorkflowTask()) {
                    return Optional.of(((RespondWorkflowTaskCompletedResponse)nextTask.get()).getWorkflowTask());
                }
            } else {
                RespondWorkflowTaskFailedRequest taskFailed = response.getTaskFailed();
                if (taskFailed != null) {
                    ro = RpcRetryOptions.newBuilder(GrpcRetryer.DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS).setRetryOptions(ro).validateBuildWithDefaults();
                    RespondWorkflowTaskFailedRequest request = taskFailed.toBuilder().setIdentity(WorkflowWorker.this.options.getIdentity()).setNamespace(WorkflowWorker.this.namespace).setTaskToken(taskToken).build();
                    GrpcRetryer.retry(ro, () -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)WorkflowWorker.this.options.getMetricsScope())).respondWorkflowTaskFailed(request));
                } else {
                    RespondQueryTaskCompletedRequest queryCompleted = response.getQueryCompleted();
                    if (queryCompleted != null) {
                        queryCompleted = queryCompleted.toBuilder().setTaskToken(taskToken).setNamespace(WorkflowWorker.this.namespace).build();
                        ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)WorkflowWorker.this.options.getMetricsScope())).respondQueryTaskCompleted(queryCompleted);
                    }
                }
            }
            return Optional.empty();
        }

        private static /* synthetic */ void lambda$sendReply$0(AtomicReference nextTask, WorkflowServiceStubs service, Scope metricsScope, Map tags, RespondWorkflowTaskCompletedRequest request) throws RuntimeException {
            nextTask.set(((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope.tagged(tags))).respondWorkflowTaskCompleted(request));
        }
    }
}

