/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.uber.m3.tally.Scope;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.internal.common.RpcRetryOptions;
import java.time.Duration;

public interface ActivityTaskHandler {
    public Result handle(PollActivityTaskQueueResponse var1, Scope var2, boolean var3);

    public boolean isAnyTypeSupported();

    public static final class Result {
        private final String activityId;
        private final RespondActivityTaskCompletedRequest taskCompleted;
        private final TaskFailedResult taskFailed;
        private final RespondActivityTaskCanceledRequest taskCanceled;
        private final RpcRetryOptions requestRetryOptions;
        private int attempt;
        private Duration backoff;

        public String toString() {
            return "Result{activityId='" + this.activityId + '\'' + ", taskCompleted=" + this.taskCompleted + ", taskFailed=" + this.taskFailed + ", taskCanceled=" + this.taskCanceled + ", attempt=" + this.attempt + ", backoff=" + this.backoff + '}';
        }

        public Result(String activityId, RespondActivityTaskCompletedRequest taskCompleted, TaskFailedResult taskFailed, RespondActivityTaskCanceledRequest taskCanceled, RpcRetryOptions requestRetryOptions) {
            this.activityId = activityId;
            this.taskCompleted = taskCompleted;
            this.taskFailed = taskFailed;
            this.taskCanceled = taskCanceled;
            this.requestRetryOptions = requestRetryOptions;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public RespondActivityTaskCompletedRequest getTaskCompleted() {
            return this.taskCompleted;
        }

        public TaskFailedResult getTaskFailed() {
            return this.taskFailed;
        }

        public RespondActivityTaskCanceledRequest getTaskCanceled() {
            return this.taskCanceled;
        }

        public RpcRetryOptions getRequestRetryOptions() {
            return this.requestRetryOptions;
        }

        public void setAttempt(int attempt) {
            this.attempt = attempt;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public void setBackoff(Duration backoff) {
            this.backoff = backoff;
        }

        public Duration getBackoff() {
            return this.backoff;
        }

        public static class TaskFailedResult {
            private final RespondActivityTaskFailedRequest taskFailedRequest;
            private final Throwable failure;

            public TaskFailedResult(RespondActivityTaskFailedRequest taskFailedRequest, Throwable failure) {
                this.taskFailedRequest = taskFailedRequest;
                this.failure = failure;
            }

            public RespondActivityTaskFailedRequest getTaskFailedRequest() {
                return this.taskFailedRequest;
            }

            public Throwable getFailure() {
                return this.failure;
            }
        }
    }
}

