/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import io.grpc.Status;
import io.temporal.internal.testservice.RequestContext;
import io.temporal.internal.testservice.StateMachines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class StateMachine<Data> {
    private final List<Transition> transitionHistory = new ArrayList<Transition>();
    private final Map<Transition, TransitionDestination<Data, ?>> transitions = new HashMap();
    private StateMachines.State state = StateMachines.State.NONE;
    private final Data data;

    StateMachine(Data data) {
        this.data = Objects.requireNonNull(data);
    }

    public StateMachines.State getState() {
        return this.state;
    }

    public Data getData() {
        return this.data;
    }

    <V> StateMachine<Data> add(StateMachines.State from, StateMachines.Action action, StateMachines.State to, Callback<Data, V> callback) {
        this.transitions.put(new Transition(from, action), new FixedTransitionDestination(to, callback));
        return this;
    }

    <V> StateMachine<Data> add(StateMachines.State from, StateMachines.Action action, StateMachines.State[] toStates, DynamicCallback<Data, V> callback) {
        this.transitions.put(new Transition(from, action), new DynamicTransitionDestination(toStates, callback));
        return this;
    }

    <R> void action(StateMachines.Action action, RequestContext context, R request, long referenceId) {
        Transition transition = new Transition(this.state, action);
        TransitionDestination<Data, ?> destination = this.transitions.get(transition);
        if (destination == null) {
            throw Status.INTERNAL.withDescription(this.data + "Invalid " + transition + ", history: " + this.transitionHistory).asRuntimeException();
        }
        this.state = destination.apply(context, this.data, request, referenceId);
        this.transitionHistory.add(transition);
    }

    private static class DynamicTransitionDestination<Data, R>
    implements TransitionDestination<Data, R> {
        final DynamicCallback<Data, R> callback;
        StateMachines.State[] expectedStates;
        StateMachines.State state;

        private DynamicTransitionDestination(StateMachines.State[] expectedStates, DynamicCallback<Data, R> callback) {
            this.expectedStates = expectedStates;
            this.callback = callback;
        }

        public String toString() {
            return "DynamicTransitionDestination{state=" + (Object)((Object)this.state) + ", callback=" + this.callback + '}';
        }

        @Override
        public StateMachines.State apply(RequestContext ctx, Data data, R request, long referenceId) {
            this.state = this.callback.apply(ctx, data, request, referenceId);
            for (StateMachines.State s : this.expectedStates) {
                if (s != this.state) continue;
                return this.state;
            }
            throw new IllegalStateException((Object)((Object)this.state) + " is not expected. Expected states are: " + Arrays.toString((Object[])this.expectedStates));
        }
    }

    private static class FixedTransitionDestination<Data, R>
    implements TransitionDestination<Data, R> {
        final StateMachines.State state;
        final Callback<Data, R> callback;

        private FixedTransitionDestination(StateMachines.State state, Callback<Data, R> callback) {
            this.state = state;
            this.callback = callback;
        }

        public String toString() {
            return "TransitionDestination{state=" + (Object)((Object)this.state) + ", callback=" + this.callback + '}';
        }

        @Override
        public StateMachines.State apply(RequestContext ctx, Data data, R request, long referenceId) {
            this.callback.apply(ctx, data, request, referenceId);
            return this.state;
        }
    }

    private static interface TransitionDestination<Data, R> {
        public StateMachines.State apply(RequestContext var1, Data var2, R var3, long var4);
    }

    private static class Transition {
        final StateMachines.State from;
        final StateMachines.Action action;

        public Transition(StateMachines.State from, StateMachines.Action action) {
            this.from = Objects.requireNonNull(from);
            this.action = Objects.requireNonNull(action);
        }

        public StateMachines.State getFrom() {
            return this.from;
        }

        public StateMachines.Action getAction() {
            return this.action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Transition)) {
                return false;
            }
            Transition that = (Transition)o;
            if (this.from != that.from) {
                return false;
            }
            return this.action == that.action;
        }

        public int hashCode() {
            int result = this.from.hashCode();
            result = 31 * result + this.action.hashCode();
            return result;
        }

        public String toString() {
            return "Transition{from=" + (Object)((Object)this.from) + ", action=" + (Object)((Object)this.action) + '}';
        }
    }

    @FunctionalInterface
    static interface DynamicCallback<D, R> {
        public StateMachines.State apply(RequestContext var1, D var2, R var3, long var4);
    }

    @FunctionalInterface
    static interface Callback<D, R> {
        public void apply(RequestContext var1, D var2, R var3, long var4);
    }
}

