/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import io.grpc.Status;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.internal.testservice.WorkflowId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

final class ExecutionId {
    private final String namespace;
    private final WorkflowExecution execution;

    ExecutionId(String namespace, WorkflowExecution execution) {
        this.namespace = Objects.requireNonNull(namespace);
        this.execution = Objects.requireNonNull(execution);
    }

    ExecutionId(String namespace, String workflowId, String runId) {
        this(namespace, WorkflowExecution.newBuilder().setWorkflowId(Objects.requireNonNull(workflowId)).setRunId(OptionsUtils.safeGet(runId)).build());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public WorkflowExecution getExecution() {
        return this.execution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionId that = (ExecutionId)o;
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        return this.execution.equals((Object)that.execution);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.execution.hashCode();
        return result;
    }

    public String toString() {
        return "ExecutionId{namespace='" + this.namespace + '\'' + ", execution=" + this.execution + '}';
    }

    byte[] toBytes() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            this.addBytes(out);
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
        return bout.toByteArray();
    }

    void addBytes(DataOutputStream out) throws IOException {
        out.writeUTF(this.namespace);
        out.writeUTF(this.execution.getWorkflowId());
        if (!this.execution.getRunId().isEmpty()) {
            out.writeUTF(this.execution.getRunId());
        }
    }

    static ExecutionId fromBytes(byte[] serialized) {
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        DataInputStream in = new DataInputStream(bin);
        try {
            return ExecutionId.readFromBytes(in);
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()).asRuntimeException();
        }
    }

    static ExecutionId readFromBytes(DataInputStream in) throws IOException {
        String namespace = in.readUTF();
        String workflowId = in.readUTF();
        String runId = null;
        if (in.available() > 0) {
            runId = in.readUTF();
        }
        return new ExecutionId(namespace, workflowId, runId);
    }

    public WorkflowId getWorkflowId() {
        return new WorkflowId(this.namespace, this.execution.getWorkflowId());
    }
}

