/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.uber.m3.tally.Scope;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.RetryOptions;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.FailureConverter;
import io.temporal.internal.common.CheckedExceptionWrapper;
import io.temporal.internal.logging.ReplayAwareLogger;
import io.temporal.internal.sync.ActivityInvocationHandler;
import io.temporal.internal.sync.ActivityInvocationHandlerBase;
import io.temporal.internal.sync.ActivityStubImpl;
import io.temporal.internal.sync.AllOfPromise;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.internal.sync.CancellationScopeImpl;
import io.temporal.internal.sync.ChildWorkflowInvocationHandler;
import io.temporal.internal.sync.ChildWorkflowStubImpl;
import io.temporal.internal.sync.CompletablePromiseImpl;
import io.temporal.internal.sync.ContinueAsNewWorkflowInvocationHandler;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.ExternalWorkflowInvocationHandler;
import io.temporal.internal.sync.ExternalWorkflowStubImpl;
import io.temporal.internal.sync.LocalActivityInvocationHandler;
import io.temporal.internal.sync.LocalActivityStubImpl;
import io.temporal.internal.sync.POJOWorkflowImplMetadata;
import io.temporal.internal.sync.POJOWorkflowInterfaceMetadata;
import io.temporal.internal.sync.POJOWorkflowMethodMetadata;
import io.temporal.internal.sync.StubMarker;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowInfoImpl;
import io.temporal.internal.sync.WorkflowQueueImpl;
import io.temporal.internal.sync.WorkflowRetryerInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.workflow.ActivityStub;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.ChildWorkflowStub;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.ContinueAsNewOptions;
import io.temporal.workflow.ExternalWorkflowStub;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import io.temporal.workflow.WorkflowQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowInternal {
    public static final int DEFAULT_VERSION = -1;

    public static WorkflowThread newThread(boolean ignoreParentCancellation, Runnable runnable) {
        return WorkflowThread.newThread(runnable, ignoreParentCancellation);
    }

    public static WorkflowThread newThread(boolean ignoreParentCancellation, String name, Runnable runnable) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        return WorkflowThread.newThread(runnable, ignoreParentCancellation, name);
    }

    public static Promise<Void> newTimer(Duration duration) {
        return WorkflowInternal.getWorkflowInterceptor().newTimer(duration);
    }

    public static <E> WorkflowQueue<E> newQueue(int capacity) {
        return new WorkflowQueueImpl(capacity);
    }

    public static <E> CompletablePromise<E> newCompletablePromise() {
        return new CompletablePromiseImpl();
    }

    public static <E> Promise<E> newPromise(E value) {
        CompletablePromise result = Workflow.newPromise();
        result.complete(value);
        return result;
    }

    public static <E> Promise<E> newFailedPromise(Exception failure) {
        CompletablePromiseImpl result = new CompletablePromiseImpl();
        result.completeExceptionally(CheckedExceptionWrapper.wrap(failure));
        return result;
    }

    public static void registerListener(Object implementation) {
        Method method;
        POJOWorkflowMethodMetadata methodMetadata;
        Class<?> cls = implementation.getClass();
        POJOWorkflowImplMetadata workflowMetadata = POJOWorkflowImplMetadata.newListenerInstance(cls);
        for (String queryType : workflowMetadata.getQueryTypes()) {
            methodMetadata = workflowMetadata.getQueryMethodMetadata(queryType);
            method = methodMetadata.getWorkflowMethod();
            WorkflowInternal.getWorkflowInterceptor().registerQuery(methodMetadata.getName(), method.getParameterTypes(), method.getGenericParameterTypes(), args -> {
                try {
                    return method.invoke(implementation, args);
                }
                catch (Throwable e) {
                    throw CheckedExceptionWrapper.wrap(e);
                }
            });
        }
        for (String signalType : workflowMetadata.getSignalTypes()) {
            methodMetadata = workflowMetadata.getSignalMethodMetadata(signalType);
            method = methodMetadata.getWorkflowMethod();
            WorkflowInternal.getWorkflowInterceptor().registerSignal(methodMetadata.getName(), method.getParameterTypes(), method.getGenericParameterTypes(), args -> {
                try {
                    method.invoke(implementation, args);
                }
                catch (Throwable e) {
                    throw CheckedExceptionWrapper.wrap(e);
                }
            });
        }
    }

    public static long currentTimeMillis() {
        return WorkflowInternal.getWorkflowInterceptor().currentTimeMillis();
    }

    public static <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options) {
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(activityInterface, options, WorkflowInternal.getWorkflowInterceptor());
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options) {
        InvocationHandler invocationHandler = LocalActivityInvocationHandler.newInstance(activityInterface, options, WorkflowInternal.getWorkflowInterceptor());
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    public static ActivityStub newUntypedActivityStub(ActivityOptions options) {
        return ActivityStubImpl.newInstance(options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static ActivityStub newUntypedLocalActivityStub(LocalActivityOptions options) {
        return LocalActivityStubImpl.newInstance(options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static <T> T newChildWorkflowStub(Class<T> workflowInterface, ChildWorkflowOptions options) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new ChildWorkflowInvocationHandler(workflowInterface, options, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static <T> T newExternalWorkflowStub(Class<T> workflowInterface, WorkflowExecution execution) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, StubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new ExternalWorkflowInvocationHandler(workflowInterface, execution, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static Promise<WorkflowExecution> getWorkflowExecution(Object workflowStub) {
        if (workflowStub instanceof StubMarker) {
            Object stub = ((StubMarker)workflowStub).__getUntypedStub();
            return ((ChildWorkflowStub)stub).getExecution();
        }
        throw new IllegalArgumentException("Not a workflow stub created through Workflow.newChildWorkflowStub: " + workflowStub);
    }

    public static ChildWorkflowStub newUntypedChildWorkflowStub(String workflowType, ChildWorkflowOptions options) {
        return new ChildWorkflowStubImpl(workflowType, options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static ExternalWorkflowStub newUntypedExternalWorkflowStub(WorkflowExecution execution) {
        return new ExternalWorkflowStubImpl(execution, WorkflowInternal.getWorkflowInterceptor());
    }

    public static <T> T newContinueAsNewStub(Class<T> workflowInterface, ContinueAsNewOptions options) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface}, (InvocationHandler)new ContinueAsNewWorkflowInvocationHandler(workflowInterface, options, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static <R> R executeActivity(String name, ActivityOptions options, Class<R> resultClass, Type resultType, Object ... args) {
        Promise<R> result = WorkflowInternal.getWorkflowInterceptor().executeActivity(name, resultClass, resultType, args, options);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(result);
            return null;
        }
        return result.get();
    }

    private static WorkflowOutboundCallsInterceptor getWorkflowInterceptor() {
        return DeterministicRunnerImpl.currentThreadInternal().getWorkflowContext().getWorkflowInterceptor();
    }

    static SyncWorkflowContext getRootWorkflowContext() {
        return DeterministicRunnerImpl.currentThreadInternal().getWorkflowContext();
    }

    public static void await(String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        WorkflowInternal.getWorkflowInterceptor().await(reason, unblockCondition);
    }

    public static boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        return WorkflowInternal.getWorkflowInterceptor().await(timeout, reason, unblockCondition);
    }

    public static <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        return WorkflowInternal.getWorkflowInterceptor().sideEffect(resultClass, resultType, func);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        return WorkflowInternal.getWorkflowInterceptor().mutableSideEffect(id, resultClass, resultType, updated, func);
    }

    public static int getVersion(String changeId, int minSupported, int maxSupported) {
        return WorkflowInternal.getWorkflowInterceptor().getVersion(changeId, minSupported, maxSupported);
    }

    public static <V> Promise<Void> promiseAllOf(Iterable<Promise<V>> promises) {
        return new AllOfPromise(promises);
    }

    public static Promise<Void> promiseAllOf(Promise<?> ... promises) {
        return new AllOfPromise(promises);
    }

    public static <V> Promise<V> promiseAnyOf(Iterable<Promise<V>> promises) {
        return CompletablePromiseImpl.promiseAnyOf(promises);
    }

    public static Promise<Object> promiseAnyOf(Promise<?> ... promises) {
        return CompletablePromiseImpl.promiseAnyOf(promises);
    }

    public static CancellationScope newCancellationScope(boolean detached, Runnable runnable) {
        return new CancellationScopeImpl(detached, runnable);
    }

    public static CancellationScope newCancellationScope(boolean detached, Functions.Proc1<CancellationScope> proc) {
        return new CancellationScopeImpl(detached, proc);
    }

    public static CancellationScopeImpl currentCancellationScope() {
        return CancellationScopeImpl.current();
    }

    public static RuntimeException wrap(Throwable e) {
        return CheckedExceptionWrapper.wrap(e);
    }

    public static Throwable unwrap(Throwable e) {
        return CheckedExceptionWrapper.unwrap(e);
    }

    private WorkflowInternal() {
    }

    public static boolean isReplaying() {
        Optional<WorkflowThread> thread = DeterministicRunnerImpl.currentThreadInternalIfPresent();
        return thread.isPresent() && WorkflowInternal.getRootWorkflowContext().isReplaying();
    }

    public static WorkflowInfo getWorkflowInfo() {
        return new WorkflowInfoImpl(WorkflowInternal.getRootWorkflowContext().getContext());
    }

    public static <R> R retry(RetryOptions options, Optional<Duration> expiration, Functions.Func<R> fn) {
        return WorkflowRetryerInternal.validateOptionsAndRetry(options, expiration, fn);
    }

    public static void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args) {
        WorkflowInternal.getWorkflowInterceptor().continueAsNew(workflowType, options, args);
    }

    public static void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args, WorkflowOutboundCallsInterceptor outboundCallsInterceptor) {
        outboundCallsInterceptor.continueAsNew(workflowType, options, args);
    }

    public static Promise<Void> cancelWorkflow(WorkflowExecution execution) {
        return WorkflowInternal.getWorkflowInterceptor().cancelWorkflow(execution);
    }

    public static void sleep(Duration duration) {
        WorkflowInternal.getWorkflowInterceptor().sleep(duration);
    }

    public static Scope getMetricsScope() {
        return WorkflowInternal.getRootWorkflowContext().getMetricsScope();
    }

    private static boolean isLoggingEnabledInReplay() {
        return WorkflowInternal.getRootWorkflowContext().isLoggingEnabledInReplay();
    }

    public static UUID randomUUID() {
        return WorkflowInternal.getRootWorkflowContext().randomUUID();
    }

    public static Random newRandom() {
        return WorkflowInternal.getRootWorkflowContext().newRandom();
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        return new ReplayAwareLogger(logger, WorkflowInternal::isReplaying, WorkflowInternal::isLoggingEnabledInReplay);
    }

    public static Logger getLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new ReplayAwareLogger(logger, WorkflowInternal::isReplaying, WorkflowInternal::isLoggingEnabledInReplay);
    }

    public static <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        return WorkflowInternal.getRootWorkflowContext().getLastCompletionResult(resultClass, resultType);
    }

    public static void upsertSearchAttributes(Map<String, Object> searchAttributes) {
        WorkflowInternal.getWorkflowInterceptor().upsertSearchAttributes(searchAttributes);
    }

    public static DataConverter getDataConverter() {
        return WorkflowInternal.getRootWorkflowContext().getDataConverter();
    }

    public static String getWorkflowType(Class<?> workflowInterfaceClass) {
        POJOWorkflowInterfaceMetadata metadata = POJOWorkflowInterfaceMetadata.newInstance(workflowInterfaceClass);
        return metadata.getWorkflowType().get();
    }

    public static Optional<Exception> getPreviousRunFailure() {
        return WorkflowInternal.getRootWorkflowContext().getPreviousRunFailure().map(f -> FailureConverter.failureToException(f, DataConverter.getDefaultInstance()));
    }
}

