/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Defaults;
import io.temporal.failure.ActivityFailure;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.workflow.ActivityStub;
import io.temporal.workflow.Promise;
import java.lang.reflect.Type;

abstract class ActivityStubBase
implements ActivityStub {
    ActivityStubBase() {
    }

    public <T> T execute(String activityName, Class<T> resultClass, Object ... args) {
        return this.execute(activityName, resultClass, (Type)resultClass, args);
    }

    public <T> T execute(String activityName, Class<T> resultClass, Type resultType, Object ... args) {
        Promise<T> result = this.executeAsync(activityName, resultClass, resultType, args);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(result);
            return (T)Defaults.defaultValue(resultClass);
        }
        try {
            return result.get();
        }
        catch (ActivityFailure e) {
            StackTraceElement[] currentStackTrace = Thread.currentThread().getStackTrace();
            e.setStackTrace(currentStackTrace);
            throw e;
        }
    }

    @Override
    public <R> Promise<R> executeAsync(String activityName, Class<R> resultClass, Object ... args) {
        return this.executeAsync(activityName, resultClass, resultClass, args);
    }

    @Override
    public abstract <R> Promise<R> executeAsync(String var1, Class<R> var2, Type var3, Object ... var4);
}

