/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.ActivityCompletionClient;
import io.temporal.client.ActivityCompletionException;
import io.temporal.internal.external.ManualActivityCompletionClientFactory;
import java.util.Optional;

class ActivityCompletionClientImpl
implements ActivityCompletionClient {
    private final ManualActivityCompletionClientFactory factory;

    public ActivityCompletionClientImpl(ManualActivityCompletionClientFactory manualActivityCompletionClientFactory) {
        this.factory = manualActivityCompletionClientFactory;
    }

    @Override
    public <R> void complete(byte[] taskToken, R result) {
        this.factory.getClient(taskToken).complete(result);
    }

    @Override
    public <R> void complete(String workflowId, Optional<String> runId, String activityId, R result) {
        this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId).complete(result);
    }

    @Override
    public void completeExceptionally(byte[] taskToken, Exception result) {
        this.factory.getClient(taskToken).fail(result);
    }

    @Override
    public void completeExceptionally(String workflowId, Optional<String> runId, String activityId, Exception result) {
        this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId).fail(result);
    }

    @Override
    public <V> void reportCancellation(byte[] taskToken, V details) {
        this.factory.getClient(taskToken).reportCancellation(details);
    }

    @Override
    public <V> void reportCancellation(String workflowId, Optional<String> runId, String activityId, V details) {
        this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId).reportCancellation(details);
    }

    @Override
    public <V> void heartbeat(byte[] taskToken, V details) throws ActivityCompletionException {
        this.factory.getClient(taskToken).recordHeartbeat(details);
    }

    @Override
    public <V> void heartbeat(String workflowId, Optional<String> runId, String activityId, V details) throws ActivityCompletionException {
        this.factory.getClient(ActivityCompletionClientImpl.toExecution(workflowId, runId), activityId).recordHeartbeat(details);
    }

    private static WorkflowExecution toExecution(String workflowId, Optional<String> runId) {
        return WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId.orElse("")).build();
    }
}

