/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.CancelTimerCommandAttributes;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.StartTimerCommandAttributes;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.TimerCanceledEventAttributes;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.Functions;

final class TimerStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, TimerStateMachine> {
    private final StartTimerCommandAttributes startAttributes;
    private final Functions.Proc1<HistoryEvent> completionCallback;
    public static final StateMachineDefinition<State, ExplicitEvent, TimerStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("Timer", State.CREATED, State.FIRED, State.CANCELED).add(State.CREATED, ExplicitEvent.SCHEDULE, State.START_COMMAND_CREATED, TimerStateMachine::createStartTimerCommand).add(State.START_COMMAND_CREATED, CommandType.COMMAND_TYPE_START_TIMER, State.START_COMMAND_CREATED).add(State.START_COMMAND_CREATED, EventType.EVENT_TYPE_TIMER_STARTED, State.START_COMMAND_RECORDED, EntityStateMachineInitialCommand::setInitialCommandEventId).add(State.START_COMMAND_CREATED, ExplicitEvent.CANCEL, State.CANCELED, TimerStateMachine::cancelStartTimerCommand).add(State.START_COMMAND_RECORDED, EventType.EVENT_TYPE_TIMER_FIRED, State.FIRED, TimerStateMachine::notifyCompletion).add(State.START_COMMAND_RECORDED, ExplicitEvent.CANCEL, State.CANCEL_TIMER_COMMAND_CREATED, TimerStateMachine::createCancelTimerCommand).add(State.CANCEL_TIMER_COMMAND_CREATED, ExplicitEvent.CANCEL, State.CANCEL_TIMER_COMMAND_CREATED).add(State.CANCEL_TIMER_COMMAND_SENT, EventType.EVENT_TYPE_TIMER_CANCELED, State.CANCELED).add(State.CANCEL_TIMER_COMMAND_CREATED, CommandType.COMMAND_TYPE_CANCEL_TIMER, State.CANCEL_TIMER_COMMAND_SENT, TimerStateMachine::notifyCancellation);

    public static TimerStateMachine newInstance(StartTimerCommandAttributes attributes, Functions.Proc1<HistoryEvent> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new TimerStateMachine(attributes, completionCallback, commandSink, stateMachineSink);
    }

    private TimerStateMachine(StartTimerCommandAttributes attributes, Functions.Proc1<HistoryEvent> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.startAttributes = attributes;
        this.completionCallback = completionCallback;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    private void createStartTimerCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_START_TIMER).setStartTimerCommandAttributes(this.startAttributes).build());
    }

    public void cancel() {
        if (!this.isFinalState()) {
            this.explicitEvent(ExplicitEvent.CANCEL);
        }
    }

    private void cancelStartTimerCommand() {
        this.cancelCommand();
        this.notifyCancellation();
    }

    private void notifyCancellation() {
        this.completionCallback.apply(HistoryEvent.newBuilder().setEventType(EventType.EVENT_TYPE_TIMER_CANCELED).setTimerCanceledEventAttributes(TimerCanceledEventAttributes.newBuilder().setIdentity("workflow").setTimerId(this.startAttributes.getTimerId())).build());
    }

    private void notifyCompletion() {
        this.completionCallback.apply(this.currentEvent);
    }

    private void createCancelTimerCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_CANCEL_TIMER).setCancelTimerCommandAttributes(CancelTimerCommandAttributes.newBuilder().setTimerId(this.startAttributes.getTimerId())).build());
    }

    private void cancelTimerCommandFireTimer() {
        this.cancelCommand();
        this.notifyCompletion();
    }

    static enum State {
        CREATED,
        START_COMMAND_CREATED,
        START_COMMAND_RECORDED,
        CANCEL_TIMER_COMMAND_CREATED,
        CANCEL_TIMER_COMMAND_SENT,
        FIRED,
        CANCELED;

    }

    static enum ExplicitEvent {
        SCHEDULE,
        CANCEL;

    }
}

