/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class SideEffectStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, SideEffectStateMachine> {
    private static final String MARKER_HEADER_KEY = "header";
    static final String MARKER_DATA_KEY = "data";
    static final String SIDE_EFFECT_MARKER_NAME = "SideEffect";
    private final Functions.Proc1<Optional<Payloads>> callback;
    private final Functions.Func<Optional<Payloads>> func;
    private final Functions.Func<Boolean> replaying;
    private Optional<Payloads> result;
    public static final StateMachineDefinition<State, ExplicitEvent, SideEffectStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("SideEffect", State.CREATED, State.MARKER_COMMAND_RECORDED).add(State.CREATED, ExplicitEvent.SCHEDULE, (State[])new State[]{State.MARKER_COMMAND_CREATED, State.MARKER_COMMAND_CREATED_REPLAYING}, SideEffectStateMachine::createMarkerCommand).add(State.MARKER_COMMAND_CREATED_REPLAYING, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED_REPLAYING).add(State.MARKER_COMMAND_CREATED, CommandType.COMMAND_TYPE_RECORD_MARKER, State.RESULT_NOTIFIED, SideEffectStateMachine::markerResultFromFunc).add(State.RESULT_NOTIFIED, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED).add(State.RESULT_NOTIFIED_REPLAYING, EventType.EVENT_TYPE_MARKER_RECORDED, State.MARKER_COMMAND_RECORDED, SideEffectStateMachine::markerResultFromEvent);

    public static void newInstance(Functions.Func<Boolean> replaying, Functions.Func<Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        new SideEffectStateMachine(replaying, func, callback, commandSink, stateMachineSink);
    }

    private SideEffectStateMachine(Functions.Func<Boolean> replaying, Functions.Func<Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.replaying = replaying;
        this.func = func;
        this.callback = callback;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    private State createMarkerCommand() {
        State transitionTo;
        RecordMarkerCommandAttributes markerAttributes;
        if (this.replaying.apply().booleanValue()) {
            markerAttributes = RecordMarkerCommandAttributes.getDefaultInstance();
            transitionTo = State.MARKER_COMMAND_CREATED_REPLAYING;
        } else {
            this.result = this.func.apply();
            if (this.result == null) {
                throw new IllegalStateException("marker function returned null");
            }
            HashMap<String, Payloads> details = new HashMap<String, Payloads>();
            if (this.result.isPresent()) {
                details.put(MARKER_DATA_KEY, this.result.get());
            }
            markerAttributes = RecordMarkerCommandAttributes.newBuilder().setMarkerName(SIDE_EFFECT_MARKER_NAME).putAllDetails(details).build();
            transitionTo = State.MARKER_COMMAND_CREATED;
        }
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_RECORD_MARKER).setRecordMarkerCommandAttributes(markerAttributes).build());
        return transitionTo;
    }

    private void markerResultFromEvent() {
        MarkerRecordedEventAttributes attributes = this.currentEvent.getMarkerRecordedEventAttributes();
        if (!attributes.getMarkerName().equals(SIDE_EFFECT_MARKER_NAME)) {
            throw new IllegalStateException("Expected SideEffect, received: " + attributes);
        }
        Map map = attributes.getDetailsMap();
        Optional<Payloads> fromMarker = Optional.ofNullable((Payloads)map.get(MARKER_DATA_KEY));
        this.callback.apply(fromMarker);
    }

    private void markerResultFromFunc() {
        this.callback.apply(this.result);
    }

    static enum State {
        CREATED,
        MARKER_COMMAND_CREATED,
        RESULT_NOTIFIED,
        RESULT_NOTIFIED_REPLAYING,
        MARKER_COMMAND_CREATED_REPLAYING,
        MARKER_COMMAND_RECORDED;

    }

    static enum ExplicitEvent {
        SCHEDULE;

    }
}

