/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import java.util.HashMap;
import java.util.Map;

public class HeaderUtils {
    public static Header toHeaderGrpc(Map<String, Payload> headers) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        Header.Builder builder = Header.newBuilder();
        for (Map.Entry<String, Payload> item : headers.entrySet()) {
            builder.putFields(item.getKey(), item.getValue());
        }
        return builder.build();
    }

    public static Map<String, Payload> convertMapFromObjectToBytes(Map<String, Object> map, DataConverter dataConverter) {
        if (map == null) {
            return null;
        }
        HashMap<String, Payload> result = new HashMap<String, Payload>();
        for (Map.Entry<String, Object> item : map.entrySet()) {
            try {
                result.put(item.getKey(), dataConverter.toPayload(item.getValue()).get());
            }
            catch (DataConverterException e) {
                throw new DataConverterException("Cannot serialize key " + item.getKey(), e.getCause());
            }
        }
        return result;
    }

    private HeaderUtils() {
    }
}

