/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor;

import io.takari.maven.testing.TestProperties;
import io.takari.maven.testing.executor.Embedded3xLauncher;
import io.takari.maven.testing.executor.ForkedLauncher;
import io.takari.maven.testing.executor.LauncherException;
import io.takari.maven.testing.executor.MavenExecution;
import io.takari.maven.testing.executor.MavenInstallationUtils;
import io.takari.maven.testing.executor.MavenLauncher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MavenRuntime {
    private final MavenLauncher launcher;
    private final TestProperties properties;

    MavenRuntime(MavenLauncher launcher, TestProperties properties) {
        this.launcher = launcher;
        this.properties = properties;
    }

    public static MavenRuntimeBuilder builder(File mavenHome, File classworldsConf) {
        return new MavenRuntimeBuilder(mavenHome, classworldsConf);
    }

    public static ForkedMavenRuntimeBuilder forkedBuilder(File mavenHome) {
        return new ForkedMavenRuntimeBuilder(mavenHome, null);
    }

    public MavenExecution forProject(File multiModuleProjectDirectory) {
        return new MavenExecution(this.launcher, this.properties, multiModuleProjectDirectory, null);
    }

    public MavenExecution forProject(File multiModuleProjectDirectory, String moduleRelpath) throws IOException, LauncherException {
        String mavenVersion = this.launcher.getMavenVersion();
        if (!this.isVersion330plus(mavenVersion)) {
            throw new UnsupportedOperationException("Explicit multiModuleProjectDirectory requires Maven 3.3 or newer, current version is " + mavenVersion);
        }
        return new MavenExecution(this.launcher, this.properties, multiModuleProjectDirectory, moduleRelpath);
    }

    private boolean isVersion330plus(String version) {
        String[] split = version.split("\\.");
        if (split.length < 2) {
            return false;
        }
        if (Integer.parseInt(split[0]) < 3) {
            return false;
        }
        return Integer.parseInt(split[1]) >= 3;
    }

    public String getMavenVersion() throws IOException, LauncherException {
        return this.launcher.getMavenVersion();
    }

    public static class ForkedMavenRuntimeBuilder
    extends MavenRuntimeBuilder {
        private Map<String, String> environment;

        ForkedMavenRuntimeBuilder(File mavenHome, File classworldsConf) {
            super(mavenHome, classworldsConf);
        }

        ForkedMavenRuntimeBuilder(File mavenHome, File classworldsConf, List<String> extensions, List<String> args) {
            super(mavenHome, classworldsConf, extensions, args);
        }

        public ForkedMavenRuntimeBuilder withEnvironment(Map<String, String> environment) {
            this.environment = new HashMap<String, String>(environment);
            return this;
        }

        @Override
        public ForkedMavenRuntimeBuilder withExtension(File extensionLocation) {
            super.withExtension(extensionLocation);
            return this;
        }

        @Override
        public ForkedMavenRuntimeBuilder withExtensions(Collection<File> extensionLocations) {
            super.withExtensions(extensionLocations);
            return this;
        }

        @Override
        public ForkedMavenRuntimeBuilder withCliOptions(String ... options) {
            super.withCliOptions(options);
            return this;
        }

        @Override
        public MavenRuntime build() {
            ForkedLauncher launcher = new ForkedLauncher(this.mavenHome, this.classworldsConf, this.extensions, this.environment, this.args);
            return new MavenRuntime(launcher, this.properties);
        }
    }

    public static class MavenRuntimeBuilder {
        protected final TestProperties properties;
        protected final File mavenHome;
        protected final File classworldsConf;
        protected final List<String> extensions = new ArrayList<String>();
        protected final List<String> args = new ArrayList<String>();

        MavenRuntimeBuilder(File mavenHome, File classworldsConf) {
            this.properties = new TestProperties();
            this.mavenHome = mavenHome;
            this.classworldsConf = classworldsConf;
            StringBuilder workspaceState = new StringBuilder();
            this.appendLocation(workspaceState, System.getProperty("m2e.workspace.state"));
            this.appendLocation(workspaceState, this.properties.get("workspaceStateProperties"));
            String workspaceResolver = this.properties.get("workspaceResolver");
            if (workspaceState.length() > 0 && MavenRuntimeBuilder.isFile(workspaceResolver)) {
                if ("3.2.1".equals(MavenInstallationUtils.getMavenVersion(mavenHome, classworldsConf))) {
                    throw new IllegalArgumentException("Maven 3.2.1 is not supported, see https://jira.codehaus.org/browse/MNG-5591");
                }
                this.args.add("-Dm2e.workspace.state=" + workspaceState.toString());
                this.extensions.add(workspaceResolver);
            }
        }

        private void appendLocation(StringBuilder workspaceState, String location) {
            if (location != null) {
                if (!MavenRuntimeBuilder.isFile(location)) {
                    throw new IllegalArgumentException("Not a file " + location);
                }
                if (workspaceState.length() > 0) {
                    workspaceState.append(File.pathSeparator);
                }
                workspaceState.append(location);
            }
        }

        MavenRuntimeBuilder(File mavenHome, File classworldsConf, List<String> extensions, List<String> args) {
            this.properties = new TestProperties();
            this.mavenHome = mavenHome;
            this.classworldsConf = classworldsConf;
            this.extensions.addAll(extensions);
            this.args.addAll(args);
        }

        private static boolean isFile(String path) {
            return path != null && new File(path).isFile();
        }

        public MavenRuntimeBuilder withExtension(File extensionLocation) {
            this.assertFileExists("No such file or directory: " + extensionLocation, extensionLocation);
            this.extensions.add(extensionLocation.getAbsolutePath());
            return this;
        }

        public MavenRuntimeBuilder withExtensions(Collection<File> extensionLocations) {
            for (File extensionLocation : extensionLocations) {
                this.assertFileExists("No such file or directory: " + extensionLocation, extensionLocation);
                this.extensions.add(extensionLocation.getAbsolutePath());
            }
            return this;
        }

        private void assertFileExists(String message, File file) {
            if (!file.exists()) {
                throw new AssertionError((Object)("No such file or directory: " + file));
            }
        }

        public MavenRuntimeBuilder withCliOptions(String ... options) {
            String[] stringArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                this.args.add(option);
                ++n2;
            }
            return this;
        }

        public ForkedMavenRuntimeBuilder forkedBuilder() {
            return new ForkedMavenRuntimeBuilder(this.mavenHome, this.classworldsConf, this.extensions, this.args);
        }

        public MavenRuntime build() throws Exception {
            Embedded3xLauncher launcher = Embedded3xLauncher.createFromMavenHome(this.mavenHome, this.classworldsConf, this.extensions, this.args);
            return new MavenRuntime(launcher, this.properties);
        }
    }
}

