/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.sisu;

import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.aggregator.AggregatorBuildContext;
import io.takari.incrementalbuild.aggregator.InputSet;
import io.takari.incrementalbuild.aggregator.MetadataAggregator;
import io.takari.maven.plugins.TakariLifecycleMojo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;

abstract class AbstractSisuIndexMojo
extends TakariLifecycleMojo {
    @Component
    private AggregatorBuildContext context;

    AbstractSisuIndexMojo() {
    }

    @Override
    protected void executeMojo() throws MojoExecutionException {
        try {
            InputSet inputs = this.context.newInputSet();
            inputs.addInputs(this.getOutputDirectory(), Collections.singleton("**/*.class"), null);
            inputs.aggregateIfNecessary(this.getOutputFile(), (MetadataAggregator)new MetadataAggregator<String>(){

                public Map<String, String> glean(File input) throws IOException {
                    return AbstractSisuIndexMojo.this.gleanNamedType(input);
                }

                public void aggregate(Output<File> output, Map<String, String> metadata) throws IOException {
                    AbstractSisuIndexMojo.this.writeIndex(output, metadata.keySet());
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create sisu index " + this.getOutputFile(), (Exception)e);
        }
    }

    void writeIndex(Output<File> output, Set<String> types) throws IOException {
        TreeSet<String> sorted = new TreeSet<String>(types);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(output.newOutputStream(), StandardCharsets.UTF_8));){
            for (String type : sorted) {
                w.write(type);
                w.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    Map<String, String> gleanNamedType(File classfile) throws IOException {
        try {
            ClassFileReader type = ClassFileReader.read((File)classfile);
            IBinaryAnnotation[] annotations = type.getAnnotations();
            if (annotations != null) {
                IBinaryAnnotation[] iBinaryAnnotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinaryAnnotation annotation = iBinaryAnnotationArray[n2];
                    if ("Ljavax/inject/Named;".equals(new String(annotation.getTypeName()))) {
                        return Collections.singletonMap(new String(type.getName()).replace('/', '.'), null);
                    }
                    ++n2;
                }
            }
        }
        catch (ClassFormatException classFormatException) {}
        return null;
    }

    protected abstract File getOutputDirectory();

    protected abstract File getOutputFile();
}

