/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.PathNormalizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public abstract class DependencyClasspathEntry
implements ClasspathEntry {
    protected static final String PATH_EXPORT_PACKAGE = "META-INF/takari/export-package";
    protected static final String PATH_MANIFESTMF = "META-INF/MANIFEST.MF";
    protected final Path file;
    protected final Set<String> packageNames;
    protected final Set<String> exportedPackages;

    protected DependencyClasspathEntry(Path file, Collection<String> packageNames, Collection<String> exportedPackages) {
        this.file = PathNormalizer.getCanonicalPath(file);
        this.packageNames = Collections.unmodifiableSet(new LinkedHashSet<String>(packageNames));
        this.exportedPackages = exportedPackages != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(exportedPackages)) : null;
    }

    protected AccessRestriction getAccessRestriction(String packageName) {
        if (this.exportedPackages != null && !this.exportedPackages.contains(packageName)) {
            AccessRule rule = new AccessRule(null, 0x1000133, true);
            return new AccessRestriction(rule, 0, this.getEntryName());
        }
        return null;
    }

    @Override
    public Collection<String> getPackageNames() {
        return this.packageNames;
    }

    protected static Collection<String> parseExportPackage(InputStream is) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            return reader.lines().map(l -> l.replace('.', '/')).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static Collection<String> parseBundleManifest(InputStream is) throws IOException, BundleException {
        CaseInsensitiveDictionaryMap<String, String> headers = DependencyClasspathEntry.parseManifest(is);
        if (!headers.containsKey("Bundle-SymbolicName")) {
            return null;
        }
        String exportPackageHeader = (String)headers.get("Export-Package");
        if (exportPackageHeader == null) {
            return Collections.emptySet();
        }
        HashSet<String> packages = new HashSet<String>();
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Export-Package", (String)exportPackageHeader);
        int n = manifestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement element = manifestElementArray[n2];
            packages.add(element.getValue().replace('.', '/'));
            ++n2;
        }
        return packages;
    }

    private static CaseInsensitiveDictionaryMap<String, String> parseManifest(InputStream is) throws IOException, BundleException {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap();
        ManifestElement.parseBundleManifest((InputStream)is, (Map)headers);
        return headers;
    }

    @Override
    public String getEntryDescription() {
        StringBuilder sb = new StringBuilder(this.getEntryName());
        if (this.exportedPackages != null) {
            sb.append("[");
            int idx = 0;
            for (String exportedPackage : this.exportedPackages) {
                if (idx++ > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append('+').append(exportedPackage).append("/*");
            }
            if (idx > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append("?**/*");
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String typeName) {
        return this.findType(packageName, typeName, this.getAccessRestriction(packageName));
    }

    public abstract NameEnvironmentAnswer findType(String var1, String var2, AccessRestriction var3);

    public String getEntryName() {
        return this.file.toString();
    }
}

