/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefPath;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.OperationProcessor;
import io.swagger.parser.processors.ParameterProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PathsProcessor {
    private final Swagger swagger;
    private final ResolverCache cache;
    private final ParameterProcessor parameterProcessor;
    private final OperationProcessor operationProcessor;

    public PathsProcessor(ResolverCache cache, Swagger swagger) {
        this.swagger = swagger;
        this.cache = cache;
        this.parameterProcessor = new ParameterProcessor(cache, swagger);
        this.operationProcessor = new OperationProcessor(cache, swagger);
    }

    public void processPaths() {
        Map pathMap = this.swagger.getPaths();
        if (pathMap == null) {
            return;
        }
        for (String pathStr : pathMap.keySet()) {
            RefPath refPath;
            Path resolvedPath;
            List operations;
            Path path = (Path)pathMap.get(pathStr);
            List parameters = path.getParameters();
            if (parameters != null && (operations = path.getOperations()) != null) {
                for (Operation operation : operations) {
                    ArrayList<Parameter> parametersToAdd = new ArrayList<Parameter>();
                    boolean matched = false;
                    List existingParameters = operation.getParameters();
                    for (Parameter parameterToAdd : parameters) {
                        for (Parameter existingParameter : existingParameters) {
                            if (parameterToAdd.getIn() == null || !parameterToAdd.getIn().equals(existingParameter.getIn()) || !parameterToAdd.getName().equals(existingParameter.getName())) continue;
                            matched = true;
                        }
                        if (matched) continue;
                        parametersToAdd.add(parameterToAdd);
                    }
                    if (parametersToAdd.size() <= 0) continue;
                    operation.getParameters().addAll(0, parametersToAdd);
                }
            }
            path.setParameters(null);
            if (path instanceof RefPath && (resolvedPath = this.cache.loadRef((refPath = (RefPath)path).get$ref(), refPath.getRefFormat(), Path.class)) != null) {
                this.swagger.path(pathStr, resolvedPath);
                path = resolvedPath;
            }
            List<Parameter> processedPathParameters = this.parameterProcessor.processParameters(path.getParameters());
            path.setParameters(processedPathParameters);
            Map operationMap = path.getOperationMap();
            for (HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = (Operation)operationMap.get(httpMethod);
                this.operationProcessor.processOperation(operation);
            }
        }
    }
}

