/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Model;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.util.RefUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final Swagger swagger;

    public ExternalRefProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.swagger = swagger;
    }

    public String processRefToExternalDefinition(String $ref, RefFormat refFormat) {
        Map subProps;
        String possiblyConflictingDefinitionName;
        Model existingModel;
        Model model = this.cache.loadRef($ref, refFormat, Model.class);
        HashMap definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            definitions = new HashMap();
        }
        if ((existingModel = (Model)definitions.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingModel + " already exists");
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        String file = $ref.split("#/")[0];
        if (model instanceof RefModel) {
            RefModel refModel = (RefModel)model;
            if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
                refModel.set$ref(this.processRefToExternalDefinition(refModel.get$ref(), refModel.getRefFormat()));
            } else {
                this.processRefToExternalDefinition(file + refModel.get$ref(), RefFormat.RELATIVE);
            }
        }
        if ((subProps = model.getProperties()) != null) {
            for (Map.Entry prop : subProps.entrySet()) {
                if (!(prop.getValue() instanceof RefProperty)) continue;
                RefProperty subRef = (RefProperty)prop.getValue();
                if (RefUtils.isAnExternalRefFormat(subRef.getRefFormat())) {
                    subRef.set$ref(this.processRefToExternalDefinition(subRef.get$ref(), subRef.getRefFormat()));
                    continue;
                }
                this.processRefToExternalDefinition(file + subRef.get$ref(), RefFormat.RELATIVE);
            }
        }
        if (existingModel == null) {
            this.swagger.addDefinition(newRef, model);
        }
        return newRef;
    }
}

