/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ModelProcessor;
import java.util.ArrayList;
import java.util.List;

public class ParameterProcessor {
    private final ResolverCache cache;
    private final ModelProcessor modelProcessor;

    public ParameterProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.modelProcessor = new ModelProcessor(cache, swagger);
    }

    public List<Parameter> processParameters(List<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        List<Parameter> incomingParameterList = parameters;
        ArrayList<Parameter> processedPathLevelParameters = new ArrayList<Parameter>();
        for (Parameter parameter : incomingParameterList) {
            if (parameter instanceof RefParameter) {
                Parameter resolvedParameter;
                RefParameter refParameter = (RefParameter)parameter;
                parameter = resolvedParameter = this.cache.loadRef(refParameter.get$ref(), refParameter.getRefFormat(), Parameter.class);
            }
            if (parameter instanceof BodyParameter) {
                BodyParameter bodyParameter = (BodyParameter)parameter;
                Model schema = bodyParameter.getSchema();
                this.modelProcessor.processModel(schema);
            }
            processedPathLevelParameters.add(parameter);
        }
        return processedPathLevelParameters;
    }
}

