/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3;

import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.processors.ComponentsProcessor;
import io.swagger.parser.v3.processors.OperationProcessor;
import io.swagger.parser.v3.processors.PathsProcessor;
import java.util.List;

public class OpenAPIResolver {
    private final OpenAPI openApi;
    private final ResolverCache cache;
    private final ComponentsProcessor componentsProcessor;
    private final PathsProcessor pathProcessor;
    private final OperationProcessor operationsProcessor;
    private Settings settings = new Settings();

    public OpenAPIResolver(OpenAPI openApi) {
        this(openApi, null, null, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths) {
        this(openApi, auths, null, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this(openApi, auths, parentFileLocation, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Settings settings) {
        this.openApi = openApi;
        this.settings = settings != null ? settings : new Settings();
        this.cache = new ResolverCache(openApi, auths, parentFileLocation);
        this.componentsProcessor = new ComponentsProcessor(openApi, this.cache);
        this.pathProcessor = new PathsProcessor(this.cache, openApi, this.settings);
        this.operationsProcessor = new OperationProcessor(this.cache, openApi);
    }

    public OpenAPI resolve() {
        if (this.openApi == null) {
            return null;
        }
        this.pathProcessor.processPaths();
        this.componentsProcessor.processComponents();
        if (this.openApi.getPaths() != null) {
            for (String pathname : this.openApi.getPaths().keySet()) {
                PathItem pathItem = (PathItem)this.openApi.getPaths().get((Object)pathname);
                if (pathItem.readOperations() == null) continue;
                for (Operation operation : pathItem.readOperations()) {
                    this.operationsProcessor.processOperation(operation);
                }
            }
        }
        return this.openApi;
    }

    public static class Settings {
        private boolean addParametersToEachOperation = true;

        public boolean addParametersToEachOperation() {
            return this.addParametersToEachOperation;
        }

        public Settings addParametersToEachOperation(boolean addParametersToEachOperation) {
            this.addParametersToEachOperation = addParametersToEachOperation;
            return this;
        }
    }
}

