/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.properties;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.lang.constant.Constable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBuilder {
    static Logger LOGGER = LoggerFactory.getLogger(PropertyBuilder.class);

    public static Property build(String type, String format, Map<PropertyId, Object> args) {
        Processor processor = Processor.fromType(type, format);
        if (processor == null) {
            return null;
        }
        if (args == null) {
            args = Collections.emptyMap();
        }
        return processor.build(args);
    }

    public static Property merge(Property property, Map<PropertyId, Object> args) {
        Processor processor;
        if (args != null && !args.isEmpty() && (processor = Processor.fromProperty(property)) != null) {
            processor.merge(property, args);
        }
        return property;
    }

    public static Model toModel(Property property) {
        Processor processor = Processor.fromProperty(property);
        if (processor != null) {
            return processor.toModel(property);
        }
        return null;
    }

    private static enum Processor {
        BOOLEAN(BooleanProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return BooleanProperty.isType(type, format);
            }

            @Override
            protected BooleanProperty create() {
                return new BooleanProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof BooleanProperty) {
                    BooleanProperty resolved = (BooleanProperty)property;
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Boolean)null);
                        }
                    }
                }
                return property;
            }
        }
        ,
        STRING(StringProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return StringProperty.isType(type, format);
            }

            @Override
            protected StringProperty create() {
                return new StringProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof StringProperty) {
                    this.mergeString((StringProperty)property, args);
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        }
        ,
        DATE(DateProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DateProperty.isType(type, format);
            }

            @Override
            protected DateProperty create() {
                return new DateProperty();
            }
        }
        ,
        DATE_TIME(DateTimeProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DateTimeProperty.isType(type, format);
            }

            @Override
            protected DateTimeProperty create() {
                return new DateTimeProperty();
            }
        }
        ,
        INT(IntegerProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return IntegerProperty.isType(type, format);
            }

            @Override
            protected IntegerProperty create() {
                return new IntegerProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof IntegerProperty) {
                    IntegerProperty resolved = (IntegerProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Integer)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    IntegerProperty resolved = (IntegerProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    Integer defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        LONG(LongProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return LongProperty.isType(type, format);
            }

            @Override
            protected LongProperty create() {
                return new LongProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof LongProperty) {
                    LongProperty resolved = (LongProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Long)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    LongProperty resolved = (LongProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    Long defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        FLOAT(FloatProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return FloatProperty.isType(type, format);
            }

            @Override
            protected FloatProperty create() {
                return new FloatProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof FloatProperty) {
                    FloatProperty resolved = (FloatProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Float)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    FloatProperty resolved = (FloatProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    Float defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        DOUBLE(DoubleProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DoubleProperty.isType(type, format);
            }

            @Override
            protected DoubleProperty create() {
                return new DoubleProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof DoubleProperty) {
                    DoubleProperty resolved = (DoubleProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Double)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    DoubleProperty resolved = (DoubleProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    Double defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        INTEGER(BaseIntegerProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return BaseIntegerProperty.isType(type, format);
            }

            @Override
            protected BaseIntegerProperty create() {
                return new BaseIntegerProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof BaseIntegerProperty) {
                    BaseIntegerProperty resolved = (BaseIntegerProperty)property;
                    this.mergeNumeric(resolved, args);
                }
                return property;
            }
        }
        ,
        DECIMAL(DecimalProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DecimalProperty.isType(type, format);
            }

            @Override
            protected DecimalProperty create() {
                return new DecimalProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof DecimalProperty) {
                    DecimalProperty resolved = (DecimalProperty)property;
                    this.mergeNumeric(resolved, args);
                }
                return property;
            }
        }
        ,
        FILE(FileProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return FileProperty.isType(type, format);
            }

            @Override
            protected FileProperty create() {
                return new FileProperty();
            }
        }
        ,
        REFERENCE(RefProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return RefProperty.isType(type, format);
            }

            @Override
            protected RefProperty create() {
                return new RefProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof RefProperty) {
                    RefProperty resolved = (RefProperty)property;
                    RefModel model = new RefModel(resolved.get$ref());
                    model.setDescription(resolved.getDescription());
                    return model;
                }
                return null;
            }
        }
        ,
        E_MAIL(EmailProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return EmailProperty.isType(type, format);
            }

            @Override
            protected EmailProperty create() {
                return new EmailProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof EmailProperty) {
                    this.mergeString((EmailProperty)property, args);
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        }
        ,
        UUID(UUIDProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return UUIDProperty.isType(type, format);
            }

            @Override
            protected UUIDProperty create() {
                return new UUIDProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof UUIDProperty) {
                    Object value;
                    UUIDProperty resolved = (UUIDProperty)property;
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        value = (String)PropertyId.DEFAULT.findValue(args);
                        property.setDefault((String)value);
                    }
                    if (args.containsKey((Object)PropertyId.MIN_LENGTH)) {
                        value = (Integer)PropertyId.MIN_LENGTH.findValue(args);
                        resolved.setMinLength((Integer)value);
                    }
                    if (args.containsKey((Object)PropertyId.MAX_LENGTH)) {
                        value = (Integer)PropertyId.MAX_LENGTH.findValue(args);
                        resolved.setMaxLength((Integer)value);
                    }
                    if (args.containsKey((Object)PropertyId.PATTERN)) {
                        value = (String)PropertyId.PATTERN.findValue(args);
                        resolved.setPattern((String)value);
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    UUIDProperty resolved = (UUIDProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    model.setDefaultValue(resolved.getDefault());
                    return model;
                }
                return null;
            }
        }
        ,
        OBJECT(ObjectProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                if (ObjectProperty.isType(type, format)) {
                    return true;
                }
                if ("object".equals(type) && format == null) {
                    LOGGER.debug("no format specified for object type, falling back to object");
                    return true;
                }
                return false;
            }

            @Override
            protected ObjectProperty create() {
                return new ObjectProperty();
            }
        }
        ,
        ARRAY(ArrayProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return ArrayProperty.isType(type);
            }

            @Override
            protected ArrayProperty create() {
                return new ArrayProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof ArrayProperty) {
                    ArrayProperty resolved = (ArrayProperty)property;
                    ArrayModel model = new ArrayModel().items(resolved.getItems()).description(resolved.getDescription());
                    return model;
                }
                return null;
            }
        }
        ,
        MAP(MapProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return MapProperty.isType(type, format);
            }

            @Override
            protected MapProperty create() {
                return new MapProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof MapProperty) {
                    MapProperty resolved = (MapProperty)property;
                    return this.createModel(property).additionalProperties(resolved.getAdditionalProperties());
                }
                return null;
            }
        };

        private final Class<? extends Property> type;

        private Processor(Class<? extends Property> type) {
            this.type = type;
        }

        public static Processor fromType(String type, String format) {
            for (Processor item : Processor.values()) {
                if (!item.isType(type, format)) continue;
                return item;
            }
            LOGGER.debug("no property for " + type + ", " + format);
            return null;
        }

        public static Processor fromProperty(Property property) {
            for (Processor item : Processor.values()) {
                if (!item.isType(property)) continue;
                return item;
            }
            LOGGER.error("no property for " + (property == null ? "null" : property.getClass().getName()));
            return null;
        }

        protected abstract boolean isType(String var1, String var2);

        protected boolean isType(Property property) {
            return this.type.isInstance(property);
        }

        protected abstract Property create();

        protected <N extends AbstractNumericProperty> N mergeNumeric(N property, Map<PropertyId, Object> args) {
            Constable value;
            if (args.containsKey((Object)PropertyId.MINIMUM)) {
                value = (Double)PropertyId.MINIMUM.findValue(args);
                property.setMinimum((Double)value);
            }
            if (args.containsKey((Object)PropertyId.MAXIMUM)) {
                value = (Double)PropertyId.MAXIMUM.findValue(args);
                property.setMaximum((Double)value);
            }
            if (args.containsKey((Object)PropertyId.EXCLUSIVE_MINIMUM)) {
                value = (Boolean)PropertyId.EXCLUSIVE_MINIMUM.findValue(args);
                property.setExclusiveMinimum((Boolean)value);
            }
            if (args.containsKey((Object)PropertyId.EXCLUSIVE_MAXIMUM)) {
                value = (Boolean)PropertyId.EXCLUSIVE_MAXIMUM.findValue(args);
                property.setExclusiveMaximum((Boolean)value);
            }
            return property;
        }

        protected <N extends StringProperty> N mergeString(N property, Map<PropertyId, Object> args) {
            Object value;
            if (args.containsKey((Object)PropertyId.DEFAULT)) {
                value = (String)PropertyId.DEFAULT.findValue(args);
                property.setDefault((String)value);
            }
            if (args.containsKey((Object)PropertyId.MIN_LENGTH)) {
                value = (Integer)PropertyId.MIN_LENGTH.findValue(args);
                property.setMinLength((Integer)value);
            }
            if (args.containsKey((Object)PropertyId.MAX_LENGTH)) {
                value = (Integer)PropertyId.MAX_LENGTH.findValue(args);
                property.setMaxLength((Integer)value);
            }
            if (args.containsKey((Object)PropertyId.PATTERN)) {
                value = (String)PropertyId.PATTERN.findValue(args);
                property.setPattern((String)value);
            }
            if (args.containsKey((Object)PropertyId.ENUM)) {
                value = (List)PropertyId.ENUM.findValue(args);
                property.setEnum((List<String>)value);
            }
            return property;
        }

        protected ModelImpl createModel(Property property) {
            return new ModelImpl().type(property.getType()).format(property.getFormat()).description(property.getDescription());
        }

        protected ModelImpl createStringModel(StringProperty property) {
            ModelImpl model = this.createModel(property);
            model.setDefaultValue(property.getDefault());
            return model;
        }

        public Property build(Map<PropertyId, Object> args) {
            return this.merge(this.create(), args);
        }

        public Property merge(Property property, Map<PropertyId, Object> args) {
            if (property instanceof AbstractProperty) {
                String value;
                AbstractProperty resolved = (AbstractProperty)property;
                if (args.containsKey((Object)PropertyId.TITLE)) {
                    value = (String)PropertyId.TITLE.findValue(args);
                    resolved.setTitle(value);
                }
                if (args.containsKey((Object)PropertyId.DESCRIPTION)) {
                    value = (String)PropertyId.DESCRIPTION.findValue(args);
                    resolved.setDescription(value);
                }
                if (args.containsKey((Object)PropertyId.EXAMPLE)) {
                    value = (String)PropertyId.EXAMPLE.findValue(args);
                    resolved.setExample(value);
                }
            }
            return property;
        }

        public Model toModel(Property property) {
            return this.createModel(property);
        }
    }

    public static enum PropertyId {
        ENUM("enum"),
        TITLE("title"),
        DESCRIPTION("description"),
        DEFAULT("default"),
        PATTERN("pattern"),
        DESCRIMINATOR("discriminator"),
        MIN_ITEMS("minItems"),
        MAX_ITEMS("maxItems"),
        MIN_PROPERTIES("minProperties"),
        MAX_PROPERTIES("maxProperties"),
        MIN_LENGTH("minLength"),
        MAX_LENGTH("maxLength"),
        MINIMUM("minimum"),
        MAXIMUM("maximum"),
        EXCLUSIVE_MINIMUM("exclusiveMinimum"),
        EXCLUSIVE_MAXIMUM("exclusiveMaximum"),
        UNIQUE_ITEMS("uniqueItems"),
        EXAMPLE("example"),
        TYPE("type"),
        FORMAT("format");

        private String propertyName;

        private PropertyId(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public <T> T findValue(Map<PropertyId, Object> args) {
            Object value = args.get((Object)this);
            return (T)value;
        }
    }
}

