/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.migrate;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import io.swagger.transform.migrate.ApiOperationMigrator;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.util.MutableJsonTree;
import io.swagger.transform.util.SwaggerMigrationException;
import io.swagger.transform.util.SwaggerMigrators;
import java.io.IOException;
import javax.annotation.Nonnull;

public final class V11ApiDeclarationMigrator
implements SwaggerMigrator {
    private final SwaggerMigrator migrator = new ApiOperationMigrator();

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        MutableJsonTree tree = new MutableJsonTree(input);
        tree.applyMigrator(SwaggerMigrators.membersToString("swaggerVersion", "apiVersion"));
        tree.applyMigrator(SwaggerMigrators.patchFromResource("/patches/v1.1/versionChange.json"));
        tree.setPointer(JsonPointer.of((Object)"apis", (Object[])new Object[0]));
        tree.applyMigratorToElements(this.migrator);
        return tree.getBaseNode();
    }

    public static void main(String ... args) throws IOException, SwaggerMigrationException {
        JsonNode orig = JsonLoader.fromResource((String)"/samples/v1.1/callfire-broadcast.json");
        JsonNode orig2 = JsonLoader.fromResource((String)"/samples/v1.1/callfire-broadcast.json");
        V11ApiDeclarationMigrator migrator = new V11ApiDeclarationMigrator();
        System.out.println(JacksonUtils.prettyPrint((JsonNode)migrator.migrate(orig)));
        System.out.println(JsonNumEquals.getInstance().equivalent((Object)orig, (Object)orig2));
    }
}

