/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCppCodegen;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RestbedCodegen
extends AbstractCppCodegen {
    public static final String DECLSPEC = "declspec";
    public static final String DEFAULT_INCLUDE = "defaultInclude";
    protected String packageVersion = "1.0.0";
    protected String declspec = "";
    protected String defaultInclude = "";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "restbed";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API Server with Restbed (https://github.com/Corvusoft/restbed).";
    }

    public RestbedCodegen() {
        this.apiPackage = "io.swagger.server.api";
        this.modelPackage = "io.swagger.server.model";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.templateDir = "restbed";
        this.embeddedTemplateDir = "restbed";
        this.cliOptions.clear();
        this.addOption("modelPackage", "C++ namespace for models (convention: name.space.model).", this.modelPackage);
        this.addOption("apiPackage", "C++ namespace for apis (convention: name.space.api).", this.apiPackage);
        this.addOption("packageVersion", "C++ package version.", this.packageVersion);
        this.addOption(DECLSPEC, "C++ preprocessor to place before the class name for handling dllexport/dllimport.", this.declspec);
        this.addOption(DEFAULT_INCLUDE, "The default include statement that should be placed in all headers for including things like the declspec (convention: #include \"Commons.h\" ", this.defaultInclude);
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "std::string");
        this.typeMapping.put("DateTime", "std::string");
        this.typeMapping.put("string", "std::string");
        this.typeMapping.put("integer", "int32_t");
        this.typeMapping.put("long", "int64_t");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::vector");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("file", "std::string");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "restbed::Bytes");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("UUID", "std::string");
        this.importMapping = new HashMap();
        this.importMapping.put("std::vector", "#include <vector>");
        this.importMapping.put("std::map", "#include <map>");
        this.importMapping.put("std::string", "#include <string>");
        this.importMapping.put("Object", "#include \"Object.h\"");
        this.importMapping.put("restbed::Bytes", "#include <corvusoft/restbed/byte.hpp>");
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(DECLSPEC)) {
            this.declspec = this.additionalProperties.get(DECLSPEC).toString();
        }
        if (this.additionalProperties.containsKey(DEFAULT_INCLUDE)) {
            this.defaultInclude = this.additionalProperties.get(DEFAULT_INCLUDE).toString();
        }
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put(DECLSPEC, this.declspec);
        this.additionalProperties.put(DEFAULT_INCLUDE, this.defaultInclude);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/model").replace("/", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/api").replace("/", File.separator);
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel codegenModel = super.fromModel(name, schema, allSchemas);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        return codegenModel;
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.initialCaps(name) + "Api";
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        ArrayList<CodegenOperation> newOpList = new ArrayList<CodegenOperation>();
        for (CodegenOperation op : operationList) {
            String path = new String(op.path);
            String[] items = path.split("/", -1);
            String resourceNameCamelCase = "";
            op.path = "";
            for (String item : items) {
                if (item.length() > 1) {
                    if (item.matches("^\\{(.*)\\}$")) {
                        String tmpResourceName = item.substring(1, item.length() - 1);
                        resourceNameCamelCase = resourceNameCamelCase + Character.toUpperCase(tmpResourceName.charAt(0)) + tmpResourceName.substring(1);
                        item = item.substring(0, item.length() - 1);
                        item = item + ": .*}";
                    } else {
                        resourceNameCamelCase = resourceNameCamelCase + Character.toUpperCase(item.charAt(0)) + item.substring(1);
                    }
                } else if (item.length() == 1) {
                    resourceNameCamelCase = resourceNameCamelCase + Character.toUpperCase(item.charAt(0));
                }
                op.path = op.path + item + "/";
            }
            op.vendorExtensions.put("x-codegen-resourceName", resourceNameCamelCase);
            boolean foundInNewList = false;
            for (CodegenOperation op1 : newOpList) {
                if (foundInNewList || !op1.path.equals(op.path)) continue;
                foundInNewList = true;
                ArrayList<CodegenOperation> currentOtherMethodList = (ArrayList<CodegenOperation>)op1.vendorExtensions.get("x-codegen-otherMethods");
                if (currentOtherMethodList == null) {
                    currentOtherMethodList = new ArrayList<CodegenOperation>();
                }
                op.operationIdCamelCase = op1.operationIdCamelCase;
                currentOtherMethodList.add(op);
                op1.vendorExtensions.put("x-codegen-otherMethods", currentOtherMethodList);
            }
            if (foundInNewList) continue;
            newOpList.add(op);
        }
        operations.put("operation", newOpList);
        return objs;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        String swaggerType = this.getSchemaType(schema);
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema inner = arraySchema.getItems();
            return this.getSchemaType(schema) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (schema instanceof MapSchema && RestbedCodegen.hasSchemaProperties(schema)) {
            return this.getSchemaType(schema) + "<std::string, " + this.getTypeDeclaration((Schema)schema.getAdditionalProperties()) + ">";
        }
        if (schema instanceof StringSchema || schema instanceof DateSchema || schema instanceof DateTimeSchema || schema instanceof FileSchema || this.languageSpecificPrimitives.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return "std::shared_ptr<" + swaggerType + ">";
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema instanceof StringSchema) {
            return "\"\"";
        }
        if (schema instanceof BooleanSchema) {
            return "false";
        }
        if (schema instanceof DateSchema) {
            return "\"\"";
        }
        if (schema instanceof DateTimeSchema) {
            return "\"\"";
        }
        if (schema instanceof NumberSchema) {
            if ("float".equals(schema.getFormat())) {
                return "0.0f";
            }
            return "0.0";
        }
        if (schema instanceof IntegerSchema) {
            if ("int64".equals(schema.getFormat())) {
                return "0.0L";
            }
            return "0";
        }
        if (schema instanceof MapSchema) {
            return "std::map<std::string, " + schema.getAdditionalProperties() + ">()";
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String inner = this.getSchemaType(arraySchema.getItems());
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = "std::shared_ptr<" + inner + ">";
            }
            return "std::vector<" + inner + ">()";
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            return "new " + this.toModelName(schema.get$ref()) + "()";
        }
        return "nullptr";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        boolean isPrimitiveType = ExtensionHelper.getBooleanValue(parameter, "x-is-primitive-type");
        boolean isListContainer = ExtensionHelper.getBooleanValue(parameter, "x-is-list-container");
        boolean isString = ExtensionHelper.getBooleanValue(parameter, "x-is-string");
        if (!(isPrimitiveType || isListContainer || isString || parameter.dataType.startsWith("std::shared_ptr"))) {
            parameter.dataType = "std::shared_ptr<" + parameter.dataType + ">";
        }
    }

    @Override
    public String getSchemaType(Schema schema) {
        String swaggerType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toApiName(String type) {
        return Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

