/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCppCodegen;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.codegen.utils.ModelUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CppRestClientCodegen
extends AbstractCppCodegen {
    public static final String DECLSPEC = "declspec";
    public static final String DEFAULT_INCLUDE = "defaultInclude";
    protected String packageVersion = "1.0.0";
    protected String declspec = "";
    protected String defaultInclude = "";
    private final Set<String> parentModels = new HashSet<String>();
    private final Multimap<String, CodegenModel> childrenByParent = ArrayListMultimap.create();

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "cpprest";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API client with C++ REST SDK (https://github.com/Microsoft/cpprestsdk).";
    }

    public CppRestClientCodegen() {
        this.apiPackage = "io.swagger.client.api";
        this.modelPackage = "io.swagger.client.model";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.templateDir = "cpprest";
        this.embeddedTemplateDir = "cpprest";
        this.cliOptions.clear();
        this.addOption("modelPackage", "C++ namespace for models (convention: name.space.model).", this.modelPackage);
        this.addOption("apiPackage", "C++ namespace for apis (convention: name.space.api).", this.apiPackage);
        this.addOption("packageVersion", "C++ package version.", this.packageVersion);
        this.addOption(DECLSPEC, "C++ preprocessor to place before the class name for handling dllexport/dllimport.", this.declspec);
        this.addOption(DEFAULT_INCLUDE, "The default include statement that should be placed in all headers for including things like the declspec (convention: #include \"Commons.h\" ", this.defaultInclude);
        this.supportingFiles.add(new SupportingFile("modelbase-header.mustache", "", "ModelBase.h"));
        this.supportingFiles.add(new SupportingFile("modelbase-source.mustache", "", "ModelBase.cpp"));
        this.supportingFiles.add(new SupportingFile("object-header.mustache", "", "Object.h"));
        this.supportingFiles.add(new SupportingFile("object-source.mustache", "", "Object.cpp"));
        this.supportingFiles.add(new SupportingFile("apiclient-header.mustache", "", "ApiClient.h"));
        this.supportingFiles.add(new SupportingFile("apiclient-source.mustache", "", "ApiClient.cpp"));
        this.supportingFiles.add(new SupportingFile("apiconfiguration-header.mustache", "", "ApiConfiguration.h"));
        this.supportingFiles.add(new SupportingFile("apiconfiguration-source.mustache", "", "ApiConfiguration.cpp"));
        this.supportingFiles.add(new SupportingFile("apiexception-header.mustache", "", "ApiException.h"));
        this.supportingFiles.add(new SupportingFile("apiexception-source.mustache", "", "ApiException.cpp"));
        this.supportingFiles.add(new SupportingFile("ihttpbody-header.mustache", "", "IHttpBody.h"));
        this.supportingFiles.add(new SupportingFile("jsonbody-header.mustache", "", "JsonBody.h"));
        this.supportingFiles.add(new SupportingFile("jsonbody-source.mustache", "", "JsonBody.cpp"));
        this.supportingFiles.add(new SupportingFile("httpcontent-header.mustache", "", "HttpContent.h"));
        this.supportingFiles.add(new SupportingFile("httpcontent-source.mustache", "", "HttpContent.cpp"));
        this.supportingFiles.add(new SupportingFile("multipart-header.mustache", "", "MultipartFormData.h"));
        this.supportingFiles.add(new SupportingFile("multipart-source.mustache", "", "MultipartFormData.cpp"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("cmake-lists.mustache", "", "CMakeLists.txt"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "utility::datetime");
        this.typeMapping.put("DateTime", "utility::datetime");
        this.typeMapping.put("string", "utility::string_t");
        this.typeMapping.put("integer", "int32_t");
        this.typeMapping.put("long", "int64_t");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::vector");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("file", "HttpContent");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "std::string");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("UUID", "utility::string_t");
        this.importMapping = new HashMap();
        this.importMapping.put("std::vector", "#include <vector>");
        this.importMapping.put("std::map", "#include <map>");
        this.importMapping.put("std::string", "#include <string>");
        this.importMapping.put("HttpContent", "#include \"HttpContent.h\"");
        this.importMapping.put("Object", "#include \"Object.h\"");
        this.importMapping.put("utility::string_t", "#include <cpprest/details/basic_types.h>");
        this.importMapping.put("utility::datetime", "#include <cpprest/details/basic_types.h>");
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(DECLSPEC)) {
            this.declspec = this.additionalProperties.get(DECLSPEC).toString();
        }
        if (this.additionalProperties.containsKey(DEFAULT_INCLUDE)) {
            this.defaultInclude = this.additionalProperties.get(DEFAULT_INCLUDE).toString();
        }
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("modelHeaderGuardPrefix", this.modelPackage.replaceAll("\\.", "_").toUpperCase());
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiHeaderGuardPrefix", this.apiPackage.replaceAll("\\.", "_").toUpperCase());
        this.additionalProperties.put(DECLSPEC, this.declspec);
        this.additionalProperties.put(DEFAULT_INCLUDE, this.defaultInclude);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/model";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/api";
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel codegenModel = super.fromModel(name, schema, allSchemas);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, schemas, openAPI);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            ApiResponse methodResponse = this.findMethodResponse(operation.getResponses());
            if (methodResponse == null) {
                return codegenOperation;
            }
            Schema responseSchema = this.getSchemaFromResponse(methodResponse);
            if (responseSchema != null) {
                CodegenProperty cm = this.fromProperty("response", responseSchema);
                codegenOperation.vendorExtensions.put("x-codegen-response", cm);
                if (cm.datatype == "HttpContent") {
                    codegenOperation.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
                }
            }
        }
        return codegenOperation;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (this.isFileProperty(property)) {
            property.vendorExtensions.put("x-codegen-file", true);
        }
        if (!Strings.isNullOrEmpty((String)model.parent)) {
            this.parentModels.add(model.parent);
            if (!this.childrenByParent.containsEntry((Object)model.parent, (Object)model)) {
                this.childrenByParent.put((Object)model.parent, (Object)model);
            }
        }
    }

    protected boolean isFileProperty(CodegenProperty property) {
        return property.baseType.equals("HttpContent");
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        String schemaType = this.getSchemaType(propertySchema);
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s<%s>", schemaType, this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s<utility::string_t, %s>", schemaType, this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof StringSchema || propertySchema instanceof DateSchema || propertySchema instanceof DateTimeSchema || propertySchema instanceof FileSchema || this.languageSpecificPrimitives.contains(schemaType)) {
            return this.toModelName(schemaType);
        }
        return "std::shared_ptr<" + schemaType + ">";
    }

    @Override
    public String toDefaultValue(Schema propertySchema) {
        if (propertySchema instanceof StringSchema) {
            return "utility::conversions::to_string_t(\"\")";
        }
        if (propertySchema instanceof BooleanSchema) {
            return "false";
        }
        if (propertySchema instanceof DateSchema) {
            return "utility::datetime()";
        }
        if (propertySchema instanceof DateTimeSchema) {
            return "utility::datetime()";
        }
        if (propertySchema instanceof NumberSchema) {
            if ("float".equals(propertySchema.getFormat())) {
                return "0.0f";
            }
            return "0.0";
        }
        if (propertySchema instanceof IntegerSchema) {
            if ("int64".equals(propertySchema.getFormat())) {
                return "0L";
            }
            return "0";
        }
        if (propertySchema instanceof MapSchema && CppRestClientCodegen.hasSchemaProperties(propertySchema)) {
            String inner = this.getSchemaType((Schema)propertySchema.getAdditionalProperties());
            return String.format("std::map<utility::string_t, %s>()", inner);
        }
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            String inner = this.getSchemaType(arraySchema.getItems());
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = String.format("std::shared_ptr<%s>", inner);
            }
            return String.format("std::vector<%s>()", inner);
        }
        if (StringUtils.isNotBlank((CharSequence)propertySchema.get$ref())) {
            return String.format("new %s()", this.toModelName(propertySchema.get$ref()));
        }
        return "nullptr";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        boolean isPrimitiveType = ExtensionHelper.getBooleanValue(parameter, "x-is-primitive-type");
        boolean isListContainer = ExtensionHelper.getBooleanValue(parameter, "x-is-list-container");
        boolean isString = ExtensionHelper.getBooleanValue(parameter, "x-is-string");
        if (!(isPrimitiveType || isListContainer || isString || parameter.dataType.startsWith("std::shared_ptr"))) {
            parameter.dataType = "std::shared_ptr<" + parameter.dataType + ">";
        }
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String swaggerType = super.getSchemaType(propertySchema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toApiName(String type) {
        return Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> models) {
        Map<String, Object> processed = super.postProcessAllModels(models);
        this.postProcessParentModels(models);
        return processed;
    }

    private void postProcessParentModels(Map<String, Object> models) {
        for (String parent : this.parentModels) {
            CodegenModel parentModel = ModelUtils.getModelByName(parent, models);
            Collection childrenModels = this.childrenByParent.get((Object)parent);
            for (CodegenModel child : childrenModels) {
                this.processParentPropertiesInChildModel(parentModel, child);
            }
        }
    }

    private void processParentPropertiesInChildModel(CodegenModel parent, CodegenModel child) {
        HashMap<String, CodegenProperty> childPropertiesByName = new HashMap<String, CodegenProperty>(child.vars.size());
        for (CodegenProperty childProperty : child.vars) {
            childPropertiesByName.put(childProperty.name, childProperty);
        }
        for (CodegenProperty parentProperty : parent.vars) {
            CodegenProperty duplicatedByParent = (CodegenProperty)childPropertiesByName.get(parentProperty.name);
            if (duplicatedByParent == null) continue;
            duplicatedByParent.getVendorExtensions().put("x-is-inherited", Boolean.TRUE);
        }
    }
}

