/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.codegen.CodegenModelType;
import java.util.HashMap;
import java.util.Map;

public final class CodegenModelFactory {
    private static final Map<CodegenModelType, Class<?>> typeMapping = new HashMap();

    public static void setTypeMapping(CodegenModelType type, Class<?> implementation) {
        if (!type.getDefaultImplementation().isAssignableFrom(implementation)) {
            throw new IllegalArgumentException(implementation.getSimpleName() + " doesn't extend " + type.getDefaultImplementation().getSimpleName());
        }
        try {
            implementation.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        typeMapping.put(type, implementation);
    }

    public static <T> T newInstance(CodegenModelType type) {
        Class<?> classType = typeMapping.get((Object)type);
        try {
            return (T)(classType != null ? classType : type.getDefaultImplementation()).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

