/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenModelFactory;
import io.swagger.codegen.CodegenModelType;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.examples.ExampleGenerator;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.models.properties.UntypedProperty;
import io.swagger.util.Json;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCodegen {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultCodegen.class);
    protected String inputSpec;
    protected String outputFolder = "";
    protected Set<String> defaultIncludes = new HashSet<String>();
    protected Map<String, String> typeMapping = new HashMap<String, String>();
    protected Map<String, String> instantiationTypes = new HashMap<String, String>();
    protected Set<String> reservedWords = new HashSet<String>();
    protected Set<String> languageSpecificPrimitives = new HashSet<String>();
    protected Map<String, String> importMapping = new HashMap<String, String>();
    protected String modelPackage = "";
    protected String apiPackage = "";
    protected String fileSuffix;
    protected String modelNamePrefix = "";
    protected String modelNameSuffix = "";
    protected String testPackage = "";
    protected Map<String, String> apiTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> reservedWordsMappings = new HashMap<String, String>();
    protected String templateDir;
    protected String embeddedTemplateDir;
    protected String commonTemplateDir = "_common";
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected Map<String, Object> vendorExtensions = new HashMap<String, Object>();
    protected List<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();
    protected List<CliOption> cliOptions = new ArrayList<CliOption>();
    protected boolean skipOverwrite;
    protected boolean removeOperationIdPrefix;
    protected boolean supportsInheritance;
    protected boolean supportsMixins;
    protected Map<String, String> supportedLibraries = new LinkedHashMap<String, String>();
    protected String library;
    protected Boolean sortParamsByRequiredFlag = true;
    protected Boolean ensureUniqueParams = true;
    protected Boolean allowUnicodeIdentifiers = false;
    protected String gitUserId;
    protected String gitRepoId;
    protected String releaseNote;
    protected String httpUserAgent;
    protected Boolean hideGenerationTimestamp = true;
    protected Boolean skipAliasGeneration;
    protected boolean ignoreImportMapping;
    protected Map<String, String> specialCharReplacements = new HashMap<String, String>();
    protected Map<String, String> typeAliases = null;
    protected String ignoreFilePathOverride;

    public List<CliOption> cliOptions() {
        return this.cliOptions;
    }

    public void processOpts() {
        if (this.additionalProperties.containsKey("templateDir")) {
            this.setTemplateDir((String)this.additionalProperties.get("templateDir"));
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.setModelPackage((String)this.additionalProperties.get("modelPackage"));
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.setApiPackage((String)this.additionalProperties.get("apiPackage"));
        }
        if (this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.setHideGenerationTimestamp(this.convertPropertyToBooleanAndWriteBack("hideGenerationTimestamp"));
        } else {
            this.additionalProperties.put("hideGenerationTimestamp", this.hideGenerationTimestamp);
        }
        if (this.additionalProperties.containsKey("sortParamsByRequiredFlag")) {
            this.setSortParamsByRequiredFlag(Boolean.valueOf(this.additionalProperties.get("sortParamsByRequiredFlag").toString()));
        }
        if (this.additionalProperties.containsKey("ensureUniqueParams")) {
            this.setEnsureUniqueParams(Boolean.valueOf(this.additionalProperties.get("ensureUniqueParams").toString()));
        }
        if (this.additionalProperties.containsKey("allowUnicodeIdentifiers")) {
            this.setAllowUnicodeIdentifiers(Boolean.valueOf(this.additionalProperties.get("allowUnicodeIdentifiers").toString()));
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.setModelNamePrefix((String)this.additionalProperties.get("modelNamePrefix"));
        }
        if (this.additionalProperties.containsKey("modelNameSuffix")) {
            this.setModelNameSuffix((String)this.additionalProperties.get("modelNameSuffix"));
        }
        if (this.additionalProperties.containsKey("removeOperationIdPrefix")) {
            this.setRemoveOperationIdPrefix(Boolean.valueOf(this.additionalProperties.get("removeOperationIdPrefix").toString()));
        }
        if (this.additionalProperties.get("ignoreImportMappings") != null) {
            this.setIgnoreImportMapping(Boolean.parseBoolean(this.additionalProperties.get("ignoreImportMappings").toString()));
        } else {
            this.setIgnoreImportMapping(this.defaultIgnoreImportMappingOption());
        }
    }

    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        if (this.supportsInheritance) {
            HashMap<Object, CodegenModel> allModels = new HashMap<Object, CodegenModel>();
            for (Map.Entry<String, Object> entry : objs.entrySet()) {
                String modelName = this.toModelName(entry.getKey());
                Map inner = (Map)entry.getValue();
                List models = (List)inner.get("models");
                for (Map mo : models) {
                    CodegenModel cm = (CodegenModel)mo.get("model");
                    allModels.put(modelName, cm);
                }
            }
            for (CodegenModel cm : allModels.values()) {
                if (cm.parent != null) {
                    cm.parentModel = (CodegenModel)allModels.get(cm.parent);
                }
                if (cm.interfaces == null || cm.interfaces.isEmpty()) continue;
                cm.interfaceModels = new ArrayList<CodegenModel>(cm.interfaces.size());
                for (String intf : cm.interfaces) {
                    CodegenModel intfModel = (CodegenModel)allModels.get(intf);
                    if (intfModel == null) continue;
                    cm.interfaceModels.add(intfModel);
                }
            }
            for (String name : allModels.keySet()) {
                CodegenModel cm = (CodegenModel)allModels.get(name);
                CodegenModel parent = (CodegenModel)allModels.get(cm.parent);
                while (parent != null) {
                    if (parent.children == null) {
                        parent.children = new ArrayList<CodegenModel>();
                    }
                    parent.children.add(cm);
                    if (parent.discriminator == null) {
                        parent = (CodegenModel)allModels.get(parent.parent);
                        continue;
                    }
                    parent = null;
                }
            }
        }
        return objs;
    }

    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        HashMap<String, Integer> uniqueNames = new HashMap<String, Integer>();
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null) {
                Map<String, Object> allowableValues = cm.allowableValues;
                List values = (List)allowableValues.get("values");
                ArrayList enumVars = new ArrayList();
                String commonPrefix = this.findCommonPrefixOfVars(values);
                int truncateIdx = commonPrefix.length();
                uniqueNames.clear();
                for (Object value : values) {
                    String enumName;
                    HashMap<String, String> enumVar = new HashMap<String, String>();
                    if (truncateIdx == 0) {
                        enumName = value.toString();
                    } else {
                        enumName = value.toString().substring(truncateIdx);
                        if ("".equals(enumName)) {
                            enumName = value.toString();
                        }
                    }
                    String varName = this.toEnumVarName(enumName, cm.dataType);
                    enumVar.put("name", this.ensureUniqueName(uniqueNames, varName));
                    enumVar.put("value", this.toEnumValue(value.toString(), cm.dataType));
                    enumVars.add(enumVar);
                }
                cm.allowableValues.put("enumVars", enumVars);
            }
            for (CodegenProperty var : cm.vars) {
                this.updateCodegenPropertyEnum(var);
            }
            if (cm.vars == cm.allVars) continue;
            for (CodegenProperty var : cm.allVars) {
                this.updateCodegenPropertyEnum(var);
            }
        }
        return objs;
    }

    public String findCommonPrefixOfVars(List<Object> vars) {
        if (vars.size() > 1) {
            try {
                String[] listStr = vars.toArray(new String[vars.size()]);
                String prefix = StringUtils.getCommonPrefix((String[])listStr);
                return prefix.replaceAll("[a-zA-Z0-9]+\\z", "");
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return "";
    }

    protected String ensureUniqueName(Map<String, Integer> uniqueNames, String name) {
        int count;
        int n = count = uniqueNames.containsKey(name) ? uniqueNames.get(name) + 1 : 1;
        if (uniqueNames.put(name, count) != null) {
            name = name + '_' + count;
        }
        return name;
    }

    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "." + value;
    }

    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase();
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        return objs;
    }

    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        return objs;
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
    }

    public void postProcessParameter(CodegenParameter parameter) {
    }

    public void preprocessSwagger(Swagger swagger) {
    }

    public void processSwagger(Swagger swagger) {
    }

    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return compiler;
    }

    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    public String escapeUnsafeCharacters(String input) {
        LOGGER.warn("escapeUnsafeCharacters should be overridden in the code generator with proper logic to escape unsafe characters");
        return input;
    }

    public String escapeQuotationMark(String input) {
        LOGGER.warn("escapeQuotationMark should be overridden in the code generator with proper logic to escape single/double quote");
        return input.replace("\"", "\\\"");
    }

    public Set<String> defaultIncludes() {
        return this.defaultIncludes;
    }

    public Map<String, String> typeMapping() {
        return this.typeMapping;
    }

    public Map<String, String> instantiationTypes() {
        return this.instantiationTypes;
    }

    public Set<String> reservedWords() {
        return this.reservedWords;
    }

    public Set<String> languageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    public Map<String, String> importMapping() {
        return this.importMapping;
    }

    public String testPackage() {
        return this.testPackage;
    }

    public String modelPackage() {
        return this.modelPackage;
    }

    public String apiPackage() {
        return this.apiPackage;
    }

    public String fileSuffix() {
        return this.fileSuffix;
    }

    public String templateDir() {
        return this.templateDir;
    }

    public String embeddedTemplateDir() {
        if (this.embeddedTemplateDir != null) {
            return this.embeddedTemplateDir;
        }
        return this.templateDir;
    }

    public String getCommonTemplateDir() {
        return this.commonTemplateDir;
    }

    public void setCommonTemplateDir(String commonTemplateDir) {
        this.commonTemplateDir = commonTemplateDir;
    }

    public Map<String, String> apiDocTemplateFiles() {
        return this.apiDocTemplateFiles;
    }

    public Map<String, String> modelDocTemplateFiles() {
        return this.modelDocTemplateFiles;
    }

    public Map<String, String> reservedWordsMappings() {
        return this.reservedWordsMappings;
    }

    public Map<String, String> apiTestTemplateFiles() {
        return this.apiTestTemplateFiles;
    }

    public Map<String, String> modelTestTemplateFiles() {
        return this.modelTestTemplateFiles;
    }

    public Map<String, String> apiTemplateFiles() {
        return this.apiTemplateFiles;
    }

    public Map<String, String> modelTemplateFiles() {
        return this.modelTemplateFiles;
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', '/');
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', '/');
    }

    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.testPackage().replace('.', '/');
    }

    public String modelTestFileFolder() {
        return this.outputFolder + "/" + this.testPackage().replace('.', '/');
    }

    public String apiDocFileFolder() {
        return this.outputFolder;
    }

    public String modelDocFileFolder() {
        return this.outputFolder;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, Object> vendorExtensions() {
        return this.vendorExtensions;
    }

    public List<SupportingFile> supportingFiles() {
        return this.supportingFiles;
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public void setOutputDir(String dir) {
        this.outputFolder = dir;
    }

    public String getOutputDir() {
        return this.outputFolder();
    }

    public String getInputSpec() {
        return this.inputSpec;
    }

    public void setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public void setSortParamsByRequiredFlag(Boolean sortParamsByRequiredFlag) {
        this.sortParamsByRequiredFlag = sortParamsByRequiredFlag;
    }

    public void setEnsureUniqueParams(Boolean ensureUniqueParams) {
        this.ensureUniqueParams = ensureUniqueParams;
    }

    public void setAllowUnicodeIdentifiers(Boolean allowUnicodeIdentifiers) {
        this.allowUnicodeIdentifiers = allowUnicodeIdentifiers;
    }

    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(this.escapeText(pattern));
    }

    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    public String toApiVarName(String name) {
        return this.snakeCase(name);
    }

    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    public String toModelTestFilename(String name) {
        return this.initialCaps(name) + "Test";
    }

    public String toModelDocFilename(String name) {
        return this.initialCaps(name);
    }

    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return operationId;
    }

    public String toVarName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String toParamName(String name) {
        if (this.reservedWords.contains(name = this.removeNonNameElementToCamelCase(name))) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String toEnumName(CodegenProperty property) {
        return StringUtils.capitalize((String)property.name) + "Enum";
    }

    public String escapeReservedWord(String name) {
        throw new RuntimeException("reserved word " + name + " not allowed");
    }

    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    public String toApiImport(String name) {
        return this.apiPackage() + "." + name;
    }

    public DefaultCodegen() {
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "int", "long", "short", "char", "float", "String", "boolean", "Boolean", "Double", "Void", "Integer", "Long", "Float"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("UUID", "UUID");
        this.instantiationTypes = new HashMap<String, String>();
        this.reservedWords = new HashSet<String>();
        this.importMapping = new HashMap<String, String>();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("List", "java.util.*");
        this.importMapping.put("Set", "java.util.*");
        this.importMapping.put("DateTime", "org.joda.time.*");
        this.importMapping.put("LocalDateTime", "org.joda.time.*");
        this.importMapping.put("LocalDate", "org.joda.time.*");
        this.importMapping.put("LocalTime", "org.joda.time.*");
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("ensureUniqueParams", "Whether to ensure parameter names are unique in an operation (rename parameters that are not).").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.FALSE.toString()));
        this.initalizeSpecialCharacterMapping();
    }

    protected void initalizeSpecialCharacterMapping() {
        this.specialCharReplacements.put("$", "Dollar");
        this.specialCharReplacements.put("^", "Caret");
        this.specialCharReplacements.put("|", "Pipe");
        this.specialCharReplacements.put("=", "Equal");
        this.specialCharReplacements.put("*", "Star");
        this.specialCharReplacements.put("-", "Minus");
        this.specialCharReplacements.put("&", "Ampersand");
        this.specialCharReplacements.put("%", "Percent");
        this.specialCharReplacements.put("#", "Hash");
        this.specialCharReplacements.put("@", "At");
        this.specialCharReplacements.put("!", "Exclamation");
        this.specialCharReplacements.put("+", "Plus");
        this.specialCharReplacements.put(":", "Colon");
        this.specialCharReplacements.put(">", "Greater_Than");
        this.specialCharReplacements.put("<", "Less_Than");
        this.specialCharReplacements.put(".", "Period");
        this.specialCharReplacements.put("_", "Underscore");
        this.specialCharReplacements.put("?", "Question_Mark");
        this.specialCharReplacements.put(",", "Comma");
        this.specialCharReplacements.put("'", "Quote");
        this.specialCharReplacements.put("\"", "Double_Quote");
        this.specialCharReplacements.put("/", "Slash");
        this.specialCharReplacements.put("\\", "Back_Slash");
        this.specialCharReplacements.put("(", "Left_Parenthesis");
        this.specialCharReplacements.put(")", "Right_Parenthesis");
        this.specialCharReplacements.put("{", "Left_Curly_Bracket");
        this.specialCharReplacements.put("}", "Right_Curly_Bracket");
        this.specialCharReplacements.put("[", "Left_Square_Bracket");
        this.specialCharReplacements.put("]", "Right_Square_Bracket");
        this.specialCharReplacements.put("~", "Tilde");
        this.specialCharReplacements.put("`", "Backtick");
        this.specialCharReplacements.put("<=", "Less_Than_Or_Equal_To");
        this.specialCharReplacements.put(">=", "Greater_Than_Or_Equal_To");
        this.specialCharReplacements.put("!=", "Not_Equal");
    }

    protected String getSymbolName(String input) {
        return this.specialCharReplacements.get(input);
    }

    public String generateExamplePath(String path, Operation operation) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (operation.getParameters() != null) {
            int count = 0;
            for (Parameter param : operation.getParameters()) {
                if (!(param instanceof QueryParameter)) continue;
                StringBuilder paramPart = new StringBuilder();
                QueryParameter qp = (QueryParameter)param;
                if (count == 0) {
                    paramPart.append("?");
                } else {
                    paramPart.append(",");
                }
                ++count;
                if (!param.getRequired()) {
                    paramPart.append("[");
                }
                paramPart.append(param.getName()).append("=");
                paramPart.append("{");
                if (qp.getCollectionFormat() != null) {
                    paramPart.append(param.getName()).append("1");
                    if ("csv".equals(qp.getCollectionFormat())) {
                        paramPart.append(",");
                    } else if ("pipes".equals(qp.getCollectionFormat())) {
                        paramPart.append("|");
                    } else if ("tsv".equals(qp.getCollectionFormat())) {
                        paramPart.append("\t");
                    } else if ("multi".equals(qp.getCollectionFormat())) {
                        paramPart.append("&").append(param.getName()).append("=");
                        paramPart.append(param.getName()).append("2");
                    }
                } else {
                    paramPart.append(param.getName());
                }
                paramPart.append("}");
                if (!param.getRequired()) {
                    paramPart.append("]");
                }
                sb.append(paramPart.toString());
            }
        }
        return sb.toString();
    }

    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            Property additionalProperties2 = ap.getAdditionalProperties();
            String type = additionalProperties2.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties2 + "\n\tIn Property: " + p);
            }
            String inner = this.getSwaggerType(additionalProperties2);
            return this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    public void setParameterExampleValue(CodegenParameter p) {
    }

    public String toExampleValue(Property p) {
        if (p.getExample() != null) {
            return p.getExample().toString();
        }
        if (p instanceof StringProperty) {
            return "null";
        }
        if (p instanceof BooleanProperty) {
            return "null";
        }
        if (p instanceof DateProperty) {
            return "null";
        }
        if (p instanceof DateTimeProperty) {
            return "null";
        }
        if (p instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)p;
            if (dp.getExample() != null) {
                return dp.getExample().toString();
            }
            return "null";
        }
        if (p instanceof FloatProperty) {
            FloatProperty dp = (FloatProperty)p;
            if (dp.getExample() != null) {
                return dp.getExample().toString();
            }
            return "null";
        }
        if (p instanceof IntegerProperty) {
            IntegerProperty dp = (IntegerProperty)p;
            if (dp.getExample() != null) {
                return dp.getExample().toString();
            }
            return "null";
        }
        if (p instanceof LongProperty) {
            LongProperty dp = (LongProperty)p;
            if (dp.getExample() != null) {
                return dp.getExample().toString();
            }
            return "null";
        }
        return "null";
    }

    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "null";
        }
        if (p instanceof BooleanProperty) {
            return "null";
        }
        if (p instanceof DateProperty) {
            return "null";
        }
        if (p instanceof DateTimeProperty) {
            return "null";
        }
        if (p instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "null";
        }
        if (p instanceof FloatProperty) {
            FloatProperty dp = (FloatProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "null";
        }
        if (p instanceof IntegerProperty) {
            IntegerProperty dp = (IntegerProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "null";
        }
        if (p instanceof LongProperty) {
            LongProperty dp = (LongProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "null";
        }
        return "null";
    }

    public String toDefaultValueWithParam(String name, Property p) {
        return " = data." + name + ";";
    }

    public String getSwaggerType(Property p) {
        String datatype = null;
        if (p instanceof StringProperty && "number".equals(p.getFormat())) {
            datatype = "BigDecimal";
        } else if (p instanceof ByteArrayProperty || p instanceof StringProperty && "byte".equals(p.getFormat())) {
            datatype = "ByteArray";
        } else if (p instanceof BinaryProperty) {
            datatype = "binary";
        } else if (p instanceof FileProperty) {
            datatype = "file";
        } else if (p instanceof BooleanProperty) {
            datatype = "boolean";
        } else if (p instanceof DateProperty) {
            datatype = "date";
        } else if (p instanceof DateTimeProperty) {
            datatype = "DateTime";
        } else if (p instanceof DoubleProperty) {
            datatype = "double";
        } else if (p instanceof FloatProperty) {
            datatype = "float";
        } else if (p instanceof IntegerProperty) {
            datatype = "integer";
        } else if (p instanceof LongProperty) {
            datatype = "long";
        } else if (p instanceof MapProperty) {
            datatype = "map";
        } else if (p instanceof DecimalProperty) {
            datatype = "number";
        } else if (p instanceof UUIDProperty) {
            datatype = "UUID";
        } else if (p instanceof RefProperty) {
            try {
                RefProperty r = (RefProperty)p;
                datatype = r.get$ref();
                if (datatype.indexOf("#/definitions/") >= 0) {
                    datatype = datatype.substring(datatype.indexOf("#/definitions/") + "#/definitions/".length());
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error obtaining the datatype from RefProperty:" + p + ". Datatype default to Object");
                datatype = "Object";
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else if (p instanceof StringProperty) {
            datatype = "string";
        } else if (p instanceof UntypedProperty) {
            datatype = "object";
        } else if (p != null) {
            datatype = p.getType();
        }
        return datatype;
    }

    public String snakeCase(String name) {
        return name.length() > 0 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : "";
    }

    public String initialCaps(String name) {
        return StringUtils.capitalize((String)name);
    }

    public String getTypeDeclaration(String name) {
        return name;
    }

    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return this.typeMapping.get(swaggerType);
        }
        return swaggerType;
    }

    public String getAlias(String name) {
        return name;
    }

    public String toBooleanGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    public String toGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    public String toSetter(String name) {
        return "set" + this.getterAndSetterCapitalize(name);
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return this.initialCaps(name) + "Api";
    }

    public String toModelName(String name) {
        return this.initialCaps(this.modelNamePrefix + name + this.modelNameSuffix);
    }

    public CodegenModel fromModel(String name, Model model) {
        return this.fromModel(name, model, null);
    }

    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        if (this.typeAliases == null) {
            this.typeAliases = DefaultCodegen.getAllAliases(allDefinitions);
        }
        CodegenModel m = (CodegenModel)CodegenModelFactory.newInstance(CodegenModelType.MODEL);
        m.name = this.reservedWords.contains(name) ? this.escapeReservedWord(name) : name;
        m.title = this.escapeText(model.getTitle());
        m.description = this.escapeText(model.getDescription());
        m.unescapedDescription = model.getDescription();
        m.classname = this.toModelName(name);
        m.classVarName = this.toVarName(name);
        m.classFilename = this.toModelFilename(name);
        m.modelJson = Json.pretty((Object)model);
        m.externalDocs = model.getExternalDocs();
        m.vendorExtensions = model.getVendorExtensions();
        m.isAlias = this.typeAliases.containsKey(name);
        if (model instanceof ModelImpl) {
            ModelImpl modelImpl = (ModelImpl)model;
            m.discriminator = modelImpl.getDiscriminator();
            if (m.discriminator != null) {
                m.discriminatorClassVarName = this.toParamName(m.discriminator);
            }
            if (modelImpl.getXml() != null) {
                m.xmlPrefix = modelImpl.getXml().getPrefix();
                m.xmlNamespace = modelImpl.getXml().getNamespace();
                m.xmlName = modelImpl.getXml().getName();
            }
        }
        if (model instanceof ArrayModel) {
            ArrayModel am = (ArrayModel)model;
            ArrayProperty arrayProperty = new ArrayProperty(am.getItems());
            m.isArrayModel = true;
            m.arrayModelType = this.fromProperty((String)name, (Property)arrayProperty).complexType;
            this.addParentContainer(m, name, (Property)arrayProperty);
        } else if (!(model instanceof RefModel)) {
            if (model instanceof ComposedModel) {
                Model child;
                ArrayList<String> allRequired;
                LinkedHashMap<String, Property> allProperties;
                ComposedModel composed = (ComposedModel)model;
                LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
                ArrayList<String> required = new ArrayList<String>();
                if (this.supportsInheritance || this.supportsMixins) {
                    allProperties = new LinkedHashMap<String, Property>();
                    allRequired = new ArrayList<String>();
                    m.allVars = new ArrayList<CodegenProperty>();
                    int modelImplCnt = 0;
                    for (Model innerModel : ((ComposedModel)model).getAllOf()) {
                        if (!(innerModel instanceof ModelImpl)) continue;
                        ModelImpl modelImpl = (ModelImpl)innerModel;
                        if (m.discriminator == null) {
                            m.discriminator = modelImpl.getDiscriminator();
                            if (m.discriminator != null) {
                                m.discriminatorClassVarName = this.toParamName(m.discriminator);
                            }
                        }
                        if (modelImpl.getXml() != null) {
                            m.xmlPrefix = modelImpl.getXml().getPrefix();
                            m.xmlNamespace = modelImpl.getXml().getNamespace();
                            m.xmlName = modelImpl.getXml().getName();
                        }
                        if (modelImplCnt++ <= 1) continue;
                        LOGGER.warn("More than one inline schema specified in allOf:. Only the first one is recognized. All others are ignored.");
                        break;
                    }
                } else {
                    allProperties = null;
                    allRequired = null;
                }
                Model parent = composed.getParent();
                if (composed.getInterfaces() != null) {
                    if (m.interfaces == null) {
                        m.interfaces = new ArrayList<String>();
                    }
                    for (RefModel _interface : composed.getInterfaces()) {
                        Model interfaceModel = null;
                        if (allDefinitions != null) {
                            interfaceModel = allDefinitions.get(_interface.getSimpleRef());
                        }
                        if (parent == null && (interfaceModel instanceof ModelImpl && ((ModelImpl)interfaceModel).getDiscriminator() != null || interfaceModel instanceof ComposedModel && this.isDiscriminatorInInterfaceTree((ComposedModel)interfaceModel, allDefinitions))) {
                            parent = _interface;
                            continue;
                        }
                        String interfaceRef = this.toModelName(_interface.getSimpleRef());
                        m.interfaces.add(interfaceRef);
                        this.addImport(m, interfaceRef);
                        if (allDefinitions == null) continue;
                        if (!this.supportsMixins) {
                            this.addProperties(properties, required, interfaceModel, allDefinitions);
                        }
                        if (!this.supportsInheritance) continue;
                        this.addProperties(allProperties, allRequired, interfaceModel, allDefinitions);
                    }
                }
                if (parent != null) {
                    ModelImpl parentImpl;
                    String parentName = null;
                    if (parent instanceof RefModel) {
                        parentName = ((RefModel)parent).getSimpleRef();
                    } else if (parent instanceof ModelImpl && StringUtils.isNotBlank((CharSequence)(parentImpl = (ModelImpl)parent).getTitle())) {
                        parentName = parentImpl.getTitle();
                    }
                    if (parentName != null) {
                        m.parentSchema = parentName;
                        m.parent = this.toModelName(parentName);
                        this.addImport(m, m.parent);
                        if (allDefinitions != null) {
                            Model parentModel = allDefinitions.get(m.parentSchema);
                            if (this.supportsInheritance) {
                                this.addProperties(allProperties, allRequired, parentModel, allDefinitions);
                            } else {
                                this.addProperties(properties, required, parentModel, allDefinitions);
                            }
                        }
                    }
                }
                if (model.getProperties() != null) {
                    properties.putAll(model.getProperties());
                }
                if ((child = composed.getChild()) != null && child instanceof RefModel && allDefinitions != null) {
                    String childRef = ((RefModel)child).getSimpleRef();
                    child = allDefinitions.get(childRef);
                }
                if (child != null && child instanceof ModelImpl) {
                    this.addProperties(properties, required, child, allDefinitions);
                    if (this.supportsInheritance) {
                        this.addProperties(allProperties, allRequired, child, allDefinitions);
                    }
                }
                this.addVars(m, properties, required, allDefinitions, allProperties, allRequired);
            } else {
                ModelImpl impl = (ModelImpl)model;
                if (impl.getType() != null) {
                    Property p = PropertyBuilder.build((String)impl.getType(), (String)impl.getFormat(), null);
                    m.dataType = this.getSwaggerType(p);
                }
                if (impl.getEnum() != null && impl.getEnum().size() > 0) {
                    m.isEnum = true;
                    m.allowableValues = new HashMap<String, Object>();
                    m.allowableValues.put("values", impl.getEnum());
                }
                if (impl.getAdditionalProperties() != null) {
                    this.addAdditionPropertiesToCodeGenModel(m, impl);
                }
                this.addVars(m, impl.getProperties(), impl.getRequired(), allDefinitions);
            }
        }
        if (m.vars != null) {
            for (CodegenProperty prop : m.vars) {
                this.postProcessModelProperty(m, prop);
            }
        }
        return m;
    }

    private boolean isDiscriminatorInInterfaceTree(ComposedModel model, Map<String, Model> allDefinitions) {
        if (model == null || allDefinitions == null) {
            return false;
        }
        Model child = model.getChild();
        if (child instanceof ModelImpl && ((ModelImpl)child).getDiscriminator() != null) {
            return true;
        }
        for (RefModel _interface : model.getInterfaces()) {
            Model interfaceModel = allDefinitions.get(_interface.getSimpleRef());
            if (interfaceModel instanceof ModelImpl && ((ModelImpl)interfaceModel).getDiscriminator() != null) {
                return true;
            }
            if (!(interfaceModel instanceof ComposedModel)) continue;
            return this.isDiscriminatorInInterfaceTree((ComposedModel)interfaceModel, allDefinitions);
        }
        return false;
    }

    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, ModelImpl swaggerModel) {
        MapProperty mapProperty = new MapProperty(swaggerModel.getAdditionalProperties());
        this.addParentContainer(codegenModel, codegenModel.name, (Property)mapProperty);
    }

    protected void addProperties(Map<String, Property> properties, List<String> required, Model model, Map<String, Model> allDefinitions) {
        if (model instanceof ModelImpl) {
            ModelImpl mi = (ModelImpl)model;
            if (mi.getProperties() != null) {
                properties.putAll(mi.getProperties());
            }
            if (mi.getRequired() != null) {
                required.addAll(mi.getRequired());
            }
        } else if (model instanceof RefModel) {
            String interfaceRef = ((RefModel)model).getSimpleRef();
            if (allDefinitions != null) {
                Model interfaceModel = allDefinitions.get(interfaceRef);
                this.addProperties(properties, required, interfaceModel, allDefinitions);
            }
        } else if (model instanceof ComposedModel) {
            if (model.getProperties() != null) {
                properties.putAll(model.getProperties());
            }
            for (Model component : ((ComposedModel)model).getAllOf()) {
                this.addProperties(properties, required, component, allDefinitions);
            }
        }
    }

    public String getterAndSetterCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return DefaultCodegen.camelize(this.toVarName(name));
    }

    public CodegenProperty fromProperty(String name, Property p) {
        return this.fromProperty(name, p, null);
    }

    private CodegenProperty fromProperty(String name, Property p, Integer itemsDepth) {
        MapProperty ap;
        HashMap<String, Object> allowableValues;
        List _enum;
        StringProperty sp;
        if (p == null) {
            LOGGER.error("unexpected missing property for name " + name);
            return null;
        }
        CodegenProperty property = (CodegenProperty)CodegenModelFactory.newInstance(CodegenModelType.PROPERTY);
        property.itemsDepth = itemsDepth;
        property.name = this.toVarName(name);
        property.baseName = name;
        property.nameInCamelCase = DefaultCodegen.camelize(property.name, false);
        property.description = this.escapeText(p.getDescription());
        property.unescapedDescription = p.getDescription();
        property.title = p.getTitle();
        property.getter = this.toGetter(name);
        property.setter = this.toSetter(name);
        String example = this.toExampleValue(p);
        if (!"null".equals(example)) {
            property.example = example;
        }
        property.defaultValue = this.toDefaultValue(p);
        property.defaultValueWithParam = this.toDefaultValueWithParam(name, p);
        property.jsonSchema = Json.pretty((Object)p);
        if (p.getReadOnly() != null) {
            property.isReadOnly = p.getReadOnly();
        }
        if (p.getXml() != null) {
            if (p.getXml().getAttribute() != null) {
                property.isXmlAttribute = p.getXml().getAttribute();
            }
            property.xmlPrefix = p.getXml().getPrefix();
            property.xmlName = p.getXml().getName();
            property.xmlNamespace = p.getXml().getNamespace();
        }
        property.vendorExtensions = p.getVendorExtensions();
        String type = this.getSwaggerType(p);
        if (p instanceof AbstractNumericProperty) {
            AbstractNumericProperty np = (AbstractNumericProperty)p;
            if (np.getMinimum() != null) {
                property.minimum = p instanceof BaseIntegerProperty ? String.valueOf(np.getMinimum().longValue()) : String.valueOf(np.getMinimum());
            }
            if (np.getMaximum() != null) {
                property.maximum = p instanceof BaseIntegerProperty ? String.valueOf(np.getMaximum().longValue()) : String.valueOf(np.getMaximum());
            }
            if (np.getExclusiveMinimum() != null) {
                property.exclusiveMinimum = np.getExclusiveMinimum();
            }
            if (np.getExclusiveMaximum() != null) {
                property.exclusiveMaximum = np.getExclusiveMaximum();
            }
            if (property.minimum != null || property.maximum != null) {
                property.hasValidation = true;
            }
            HashMap<String, Object> allowableValues2 = new HashMap<String, Object>();
            if (np.getMinimum() != null) {
                allowableValues2.put("min", np.getMinimum());
            }
            if (np.getMaximum() != null) {
                allowableValues2.put("max", np.getMaximum());
            }
            if (allowableValues2.size() > 0) {
                property.allowableValues = allowableValues2;
            }
        }
        if (p instanceof StringProperty) {
            sp = (StringProperty)p;
            property.maxLength = sp.getMaxLength();
            property.minLength = sp.getMinLength();
            property.pattern = this.toRegularExpression(sp.getPattern());
            if (property.pattern != null || property.minLength != null || property.maxLength != null) {
                property.hasValidation = true;
            }
            property.isString = true;
            if (sp.getEnum() != null) {
                property._enum = _enum = sp.getEnum();
                property.isEnum = true;
                allowableValues = new HashMap<String, Object>();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        if (p instanceof BaseIntegerProperty && !(p instanceof IntegerProperty) && !(p instanceof LongProperty)) {
            sp = (BaseIntegerProperty)p;
            property.isInteger = true;
            property.isNumeric = true;
        }
        if (p instanceof IntegerProperty) {
            sp = (IntegerProperty)p;
            property.isInteger = true;
            property.isNumeric = true;
            if (sp.getEnum() != null) {
                _enum = sp.getEnum();
                property._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    property._enum.add(((Integer)i).toString());
                }
                property.isEnum = true;
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        if (p instanceof LongProperty) {
            sp = (LongProperty)p;
            property.isLong = true;
            property.isNumeric = true;
            if (sp.getEnum() != null) {
                _enum = sp.getEnum();
                property._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    property._enum.add(((Long)i).toString());
                }
                property.isEnum = true;
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        if (p instanceof BooleanProperty) {
            property.isBoolean = true;
            property.getter = this.toBooleanGetter(name);
        }
        if (p instanceof BinaryProperty) {
            property.isBinary = true;
        }
        if (p instanceof FileProperty) {
            property.isFile = true;
        }
        if (p instanceof UUIDProperty) {
            property.isString = true;
            property.isUuid = true;
        }
        if (p instanceof ByteArrayProperty) {
            property.isByteArray = true;
        }
        if (p instanceof DecimalProperty && !(p instanceof DoubleProperty) && !(p instanceof FloatProperty)) {
            sp = (DecimalProperty)p;
            property.isNumber = true;
        }
        if (p instanceof DoubleProperty) {
            sp = (DoubleProperty)p;
            property.isDouble = true;
            property.isNumeric = true;
            if (sp.getEnum() != null) {
                _enum = sp.getEnum();
                property._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    property._enum.add(((Double)i).toString());
                }
                property.isEnum = true;
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        if (p instanceof FloatProperty) {
            sp = (FloatProperty)p;
            property.isFloat = true;
            property.isNumeric = true;
            if (sp.getEnum() != null) {
                _enum = sp.getEnum();
                property._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    property._enum.add(((Float)i).toString());
                }
                property.isEnum = true;
                allowableValues = new HashMap<String, Object>();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        if (p instanceof DateProperty) {
            sp = (DateProperty)p;
            property.isDate = true;
            if (sp.getEnum() != null) {
                _enum = sp.getEnum();
                property._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    property._enum.add((String)i);
                }
                property.isEnum = true;
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        if (p instanceof DateTimeProperty) {
            sp = (DateTimeProperty)p;
            property.isDateTime = true;
            if (sp.getEnum() != null) {
                _enum = sp.getEnum();
                property._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    property._enum.add((String)i);
                }
                property.isEnum = true;
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        property.datatype = this.getTypeDeclaration(p);
        property.dataFormat = p.getFormat();
        if (property.isEnum) {
            property.datatypeWithEnum = this.toEnumName(property);
            property.enumName = this.toEnumName(property);
        } else {
            property.datatypeWithEnum = property.datatype;
        }
        property.baseType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            property.isContainer = true;
            property.isListContainer = true;
            property.containerType = "array";
            property.baseType = this.getSwaggerType(p);
            if (p.getXml() != null) {
                property.isXmlWrapped = p.getXml().getWrapped() == null ? false : p.getXml().getWrapped();
                property.xmlPrefix = p.getXml().getPrefix();
                property.xmlNamespace = p.getXml().getNamespace();
                property.xmlName = p.getXml().getName();
            }
            ap = (ArrayProperty)p;
            property.maxItems = ap.getMaxItems();
            property.minItems = ap.getMinItems();
            String itemName = (String)p.getVendorExtensions().get("x-item-name");
            if (itemName == null) {
                itemName = property.name;
            }
            CodegenProperty cp = this.fromProperty(itemName, ap.getItems(), itemsDepth == null ? 1 : itemsDepth + 1);
            this.updatePropertyForArray(property, cp);
        } else if (p instanceof MapProperty) {
            ap = (MapProperty)p;
            property.isContainer = true;
            property.isMapContainer = true;
            property.containerType = "map";
            property.baseType = this.getSwaggerType(p);
            property.minItems = ap.getMinProperties();
            property.maxItems = ap.getMaxProperties();
            CodegenProperty cp = this.fromProperty("inner", ap.getAdditionalProperties(), itemsDepth == null ? 1 : itemsDepth + 1);
            this.updatePropertyForMap(property, cp);
        } else {
            this.setNonArrayMapProperty(property, type);
        }
        return property;
    }

    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid array property " + Json.pretty((Object)property));
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            this.updateDataTypeWithEnumForArray(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected void updatePropertyForMap(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid map property " + Json.pretty((Object)property));
            return;
        }
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        property.dataFormat = innerProperty.dataFormat;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            this.updateDataTypeWithEnumForMap(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected Boolean isPropertyInnerMostEnum(CodegenProperty property) {
        CodegenProperty currentProperty = property;
        while (currentProperty != null && (Boolean.TRUE.equals(currentProperty.isMapContainer) || Boolean.TRUE.equals(currentProperty.isListContainer))) {
            currentProperty = currentProperty.items;
        }
        return currentProperty == null ? false : currentProperty.isEnum;
    }

    protected Map<String, Object> getInnerEnumAllowableValues(CodegenProperty property) {
        CodegenProperty currentProperty = property;
        while (currentProperty != null && (Boolean.TRUE.equals(currentProperty.isMapContainer) || Boolean.TRUE.equals(currentProperty.isListContainer))) {
            currentProperty = currentProperty.items;
        }
        return currentProperty == null ? new HashMap() : currentProperty.allowableValues;
    }

    protected void updateDataTypeWithEnumForArray(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMapContainer) || Boolean.TRUE.equals(baseItem.isListContainer))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(baseItem.baseType, this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(baseItem.baseType, this.toEnumName(baseItem));
            }
            this.updateCodegenPropertyEnum(property);
        }
    }

    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMapContainer) || Boolean.TRUE.equals(baseItem.isListContainer))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(", " + baseItem.baseType, ", " + this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
        }
    }

    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        property.isNotContainer = true;
        if (this.languageSpecificPrimitives().contains(type)) {
            property.isPrimitiveType = true;
        } else {
            property.complexType = property.baseType;
        }
    }

    protected Response findMethodResponse(Map<String, Response> responses) {
        String code = null;
        for (String responseCode : responses.keySet()) {
            if (!responseCode.startsWith("2") && !responseCode.equals("default") || code != null && code.compareTo(responseCode) <= 0) continue;
            code = responseCode;
        }
        if (code == null) {
            return null;
        }
        return responses.get(code);
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions) {
        return this.fromOperation(path, httpMethod, operation, definitions, null);
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        int offset;
        CodegenOperation op = (CodegenOperation)CodegenModelFactory.newInstance(CodegenModelType.OPERATION);
        HashSet<String> imports = new HashSet<String>();
        op.vendorExtensions = operation.getVendorExtensions();
        op.operationIdOriginal = operation.getOperationId();
        String operationId = this.getOrGenerateOperationId(operation, path, httpMethod);
        if (this.removeOperationIdPrefix && (offset = operationId.indexOf(95)) > -1) {
            operationId = operationId.substring(offset + 1);
        }
        operationId = this.removeNonNameElementToCamelCase(operationId);
        op.path = path;
        op.operationId = this.toOperationId(operationId);
        op.summary = this.escapeText(operation.getSummary());
        op.unescapedNotes = operation.getDescription();
        op.notes = this.escapeText(operation.getDescription());
        op.hasConsumes = false;
        op.hasProduces = false;
        if (operation.isDeprecated() != null) {
            op.isDeprecated = operation.isDeprecated();
        }
        List<String> consumes = new ArrayList();
        if (operation.getConsumes() != null) {
            if (operation.getConsumes().size() > 0) {
                consumes = operation.getConsumes();
            }
        } else if (swagger != null && swagger.getConsumes() != null && swagger.getConsumes().size() > 0) {
            consumes = swagger.getConsumes();
            LOGGER.debug("No consumes defined in operation. Using global consumes (" + swagger.getConsumes() + ") for " + op.operationId);
        }
        if (consumes != null && consumes.size() > 0) {
            ArrayList<Map<String, String>> c = new ArrayList<Map<String, String>>();
            int count = 0;
            for (String string : consumes) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                if ("*/*".equals(string)) {
                    mediaType.put("mediaType", string);
                } else {
                    mediaType.put("mediaType", this.escapeText(this.escapeQuotationMark(string)));
                }
                if (++count < consumes.size()) {
                    mediaType.put("hasMore", "true");
                } else {
                    mediaType.put("hasMore", null);
                }
                c.add(mediaType);
            }
            op.consumes = c;
            op.hasConsumes = true;
        }
        List produces = new ArrayList();
        if (operation.getProduces() != null) {
            if (operation.getProduces().size() > 0) {
                produces = operation.getProduces();
            }
        } else if (swagger != null && swagger.getProduces() != null && swagger.getProduces().size() > 0) {
            produces = swagger.getProduces();
            LOGGER.debug("No produces defined in operation. Using global produces (" + swagger.getProduces() + ") for " + op.operationId);
        }
        if (produces != null && !produces.isEmpty()) {
            ArrayList<Map<String, String>> c = new ArrayList<Map<String, String>>();
            int count = 0;
            for (String key : produces) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                if ("*/*".equals(key)) {
                    mediaType.put("mediaType", key);
                } else {
                    mediaType.put("mediaType", this.escapeText(this.escapeQuotationMark(key)));
                }
                if (++count < produces.size()) {
                    mediaType.put("hasMore", "true");
                } else {
                    mediaType.put("hasMore", null);
                }
                c.add(mediaType);
            }
            op.produces = c;
            op.hasProduces = true;
        }
        if (operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            Response methodResponse = this.findMethodResponse(operation.getResponses());
            for (Map.Entry entry : operation.getResponses().entrySet()) {
                Response response = (Response)entry.getValue();
                CodegenResponse r = this.fromResponse((String)entry.getKey(), response);
                r.hasMore = true;
                if (r.baseType != null && !this.defaultIncludes.contains(r.baseType) && !this.languageSpecificPrimitives.contains(r.baseType)) {
                    imports.add(r.baseType);
                }
                r.isDefault = response == methodResponse;
                op.responses.add(r);
                if (Boolean.TRUE.equals(r.isBinary) && Boolean.TRUE.equals(r.isDefault)) {
                    op.isResponseBinary = Boolean.TRUE;
                }
                if (!Boolean.TRUE.equals(r.isFile) || !Boolean.TRUE.equals(r.isDefault)) continue;
                op.isResponseFile = Boolean.TRUE;
            }
            op.responses.get((int)(op.responses.size() - 1)).hasMore = false;
            if (methodResponse != null) {
                Property responseProperty = methodResponse.getSchema();
                if (responseProperty != null) {
                    Model m;
                    CodegenProperty innerProperty;
                    ArrayProperty ap;
                    responseProperty.setRequired(true);
                    CodegenProperty codegenProperty = this.fromProperty("response", responseProperty);
                    if (responseProperty instanceof ArrayProperty) {
                        ap = (ArrayProperty)responseProperty;
                        innerProperty = this.fromProperty("response", ap.getItems());
                        op.returnBaseType = innerProperty.baseType;
                    } else if (responseProperty instanceof MapProperty) {
                        ap = (MapProperty)responseProperty;
                        innerProperty = this.fromProperty("response", ap.getAdditionalProperties());
                        op.returnBaseType = innerProperty.baseType;
                    } else {
                        op.returnBaseType = codegenProperty.complexType != null ? codegenProperty.complexType : codegenProperty.baseType;
                    }
                    op.examples = this.getExamples(definitions, methodResponse.getExamples(), operation.getProduces(), responseProperty);
                    op.defaultResponse = this.toDefaultValue(responseProperty);
                    op.returnType = codegenProperty.datatype;
                    boolean bl = op.hasReference = definitions != null && definitions.containsKey(op.returnBaseType);
                    if (definitions != null && (m = definitions.get(op.returnBaseType)) != null) {
                        CodegenModel cmod = this.fromModel(op.returnBaseType, m, definitions);
                        op.discriminator = cmod.discriminator;
                    }
                    if (codegenProperty.isContainer) {
                        op.returnContainer = codegenProperty.containerType;
                        if ("map".equals(codegenProperty.containerType)) {
                            op.isMapContainer = true;
                        } else if ("list".equalsIgnoreCase(codegenProperty.containerType)) {
                            op.isListContainer = true;
                        } else if ("array".equalsIgnoreCase(codegenProperty.containerType)) {
                            op.isListContainer = true;
                        }
                    } else {
                        op.returnSimpleType = true;
                    }
                    if (this.languageSpecificPrimitives().contains(op.returnBaseType) || op.returnBaseType == null) {
                        op.returnTypeIsPrimitive = true;
                    }
                }
                this.addHeaders(methodResponse, op.responseHeaders);
            }
        }
        List parameters = operation.getParameters();
        CodegenParameter bodyParam = null;
        ArrayList<CodegenParameter> arrayList = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> formParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
        if (parameters != null) {
            for (Parameter param : parameters) {
                CodegenParameter p = this.fromParameter(param, imports);
                if (this.ensureUniqueParams.booleanValue()) {
                    while (true) {
                        boolean exists = false;
                        for (CodegenParameter cp : arrayList) {
                            if (!p.paramName.equals(cp.paramName)) continue;
                            exists = true;
                            break;
                        }
                        if (!exists) break;
                        p.paramName = DefaultCodegen.generateNextName(p.paramName);
                    }
                }
                arrayList.add(p);
                if (param instanceof QueryParameter) {
                    queryParams.add(p.copy());
                } else if (param instanceof PathParameter) {
                    pathParams.add(p.copy());
                } else if (param instanceof HeaderParameter) {
                    headerParams.add(p.copy());
                } else if (param instanceof CookieParameter) {
                    cookieParams.add(p.copy());
                } else if (param instanceof BodyParameter) {
                    bodyParam = p;
                    bodyParams.add(p.copy());
                    if (definitions != null) {
                        op.requestBodyExamples = this.getExamples(definitions, null, consumes, bodyParam.dataType);
                    }
                } else if (param instanceof FormParameter) {
                    formParams.add(p.copy());
                }
                if (p.required) {
                    requiredParams.add(p.copy());
                    continue;
                }
                op.hasOptionalParams = true;
            }
        }
        for (String i : imports) {
            if (!this.needToImport(i)) continue;
            op.imports.add(i);
        }
        op.bodyParam = bodyParam;
        op.httpMethod = httpMethod.toUpperCase();
        if (this.sortParamsByRequiredFlag.booleanValue()) {
            Collections.sort(arrayList, new Comparator<CodegenParameter>(){

                @Override
                public int compare(CodegenParameter one, CodegenParameter another) {
                    if (one.required == another.required) {
                        return 0;
                    }
                    if (one.required) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        op.allParams = DefaultCodegen.addHasMore(arrayList);
        op.bodyParams = DefaultCodegen.addHasMore(bodyParams);
        op.pathParams = DefaultCodegen.addHasMore(pathParams);
        op.queryParams = DefaultCodegen.addHasMore(queryParams);
        op.headerParams = DefaultCodegen.addHasMore(headerParams);
        op.formParams = DefaultCodegen.addHasMore(formParams);
        op.requiredParams = DefaultCodegen.addHasMore(requiredParams);
        op.externalDocs = operation.getExternalDocs();
        op.nickname = op.operationId;
        if (op.allParams.size() > 0) {
            op.hasParams = true;
        }
        op.hasRequiredParams = op.requiredParams.size() > 0;
        op.isRestfulShow = op.isRestfulShow();
        op.isRestfulIndex = op.isRestfulIndex();
        op.isRestfulCreate = op.isRestfulCreate();
        op.isRestfulUpdate = op.isRestfulUpdate();
        op.isRestfulDestroy = op.isRestfulDestroy();
        op.isRestful = op.isRestful();
        return op;
    }

    public CodegenResponse fromResponse(String responseCode, Response response) {
        CodegenResponse r = (CodegenResponse)CodegenModelFactory.newInstance(CodegenModelType.RESPONSE);
        r.code = "default".equals(responseCode) ? "0" : responseCode;
        r.message = this.escapeText(response.getDescription());
        r.schema = response.getSchema();
        r.examples = this.toExamples(response.getExamples());
        r.jsonSchema = Json.pretty((Object)response);
        r.vendorExtensions = response.getVendorExtensions();
        this.addHeaders(response, r.headers);
        boolean bl = r.hasHeaders = !r.headers.isEmpty();
        if (r.schema != null) {
            Property responseProperty = response.getSchema();
            responseProperty.setRequired(true);
            CodegenProperty cm = this.fromProperty("response", responseProperty);
            if (responseProperty instanceof ArrayProperty) {
                ArrayProperty ap = (ArrayProperty)responseProperty;
                CodegenProperty innerProperty = this.fromProperty("response", ap.getItems());
                r.baseType = innerProperty.baseType;
            } else {
                r.baseType = cm.complexType != null ? cm.complexType : cm.baseType;
            }
            r.dataType = cm.datatype;
            if (Boolean.TRUE.equals(cm.isString) && Boolean.TRUE.equals(cm.isUuid)) {
                r.isUuid = true;
            } else if (Boolean.TRUE.equals(cm.isByteArray)) {
                r.isByteArray = true;
            } else if (Boolean.TRUE.equals(cm.isString)) {
                r.isString = true;
            } else if (Boolean.TRUE.equals(cm.isBoolean)) {
                r.isBoolean = true;
            } else if (Boolean.TRUE.equals(cm.isLong)) {
                r.isLong = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cm.isInteger)) {
                r.isInteger = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cm.isNumber)) {
                r.isNumber = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cm.isDouble)) {
                r.isDouble = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cm.isFloat)) {
                r.isFloat = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cm.isBinary)) {
                r.isBinary = true;
            } else if (Boolean.TRUE.equals(cm.isFile)) {
                r.isFile = true;
            } else if (Boolean.TRUE.equals(cm.isDate)) {
                r.isDate = true;
            } else if (Boolean.TRUE.equals(cm.isDateTime)) {
                r.isDateTime = true;
            } else {
                LOGGER.debug("Property type is not primitive: " + cm.datatype);
            }
            if (cm.isContainer) {
                r.simpleType = false;
                r.containerType = cm.containerType;
                r.isMapContainer = "map".equals(cm.containerType);
                r.isListContainer = "list".equalsIgnoreCase(cm.containerType) || "array".equalsIgnoreCase(cm.containerType);
            } else {
                r.simpleType = true;
            }
            boolean bl2 = r.primitiveType = r.baseType == null || this.languageSpecificPrimitives().contains(r.baseType);
        }
        if (r.baseType == null) {
            r.isMapContainer = false;
            r.isListContainer = false;
            r.primitiveType = true;
            r.simpleType = true;
        }
        return r;
    }

    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        FormParameter fp;
        QueryParameter qp;
        CodegenParameter p = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        p.baseName = param.getName();
        p.description = this.escapeText(param.getDescription());
        p.unescapedDescription = param.getDescription();
        if (param.getRequired()) {
            p.required = param.getRequired();
        }
        p.jsonSchema = Json.pretty((Object)param);
        if (System.getProperty("debugParser") != null) {
            LOGGER.info("working on Parameter " + param.getName());
        }
        if (param instanceof QueryParameter) {
            qp = (QueryParameter)param;
            if (qp.getDefaultValue() != null) {
                p.defaultValue = qp.getDefaultValue().toString();
            }
        } else if (param instanceof HeaderParameter) {
            HeaderParameter hp = (HeaderParameter)param;
            if (hp.getDefaultValue() != null) {
                p.defaultValue = hp.getDefaultValue().toString();
            }
        } else if (param instanceof FormParameter && (fp = (FormParameter)param).getDefaultValue() != null) {
            p.defaultValue = fp.getDefaultValue().toString();
        }
        p.vendorExtensions = param.getVendorExtensions();
        if (param instanceof SerializableParameter) {
            CodegenProperty pr;
            ArrayProperty property;
            Property inner;
            qp = (SerializableParameter)param;
            String collectionFormat = null;
            String type = qp.getType();
            if (null == type) {
                LOGGER.warn("Type is NULL for Serializable Parameter: " + param.getName());
            }
            if ("array".equals(type)) {
                inner = qp.getItems();
                if (inner == null) {
                    LOGGER.warn("warning!  No inner type supplied for array parameter \"" + qp.getName() + "\", using String");
                    inner = new StringProperty().description("//TODO automatically added by swagger-codegen");
                }
                property = new ArrayProperty(inner);
                collectionFormat = qp.getCollectionFormat();
                if (collectionFormat == null) {
                    collectionFormat = "csv";
                }
                p.items = pr = this.fromProperty("inner", inner);
                p.baseType = pr.datatype;
                p.isContainer = true;
                p.isListContainer = true;
                while (pr != null) {
                    imports.add(pr.baseType);
                    pr = pr.items;
                }
            } else if ("object".equals(type)) {
                inner = qp.getItems();
                if (inner == null) {
                    LOGGER.warn("warning!  No inner type supplied for map parameter \"" + qp.getName() + "\", using String");
                    inner = new StringProperty().description("//TODO automatically added by swagger-codegen");
                }
                property = new MapProperty(inner);
                collectionFormat = qp.getCollectionFormat();
                p.items = pr = this.fromProperty("inner", inner);
                p.baseType = pr.datatype;
                p.isContainer = true;
                p.isMapContainer = true;
                while (pr != null) {
                    imports.add(pr.baseType);
                    pr = pr.items;
                }
            } else {
                HashMap<PropertyBuilder.PropertyId, List> args = new HashMap<PropertyBuilder.PropertyId, List>();
                String format = qp.getFormat();
                args.put(PropertyBuilder.PropertyId.ENUM, qp.getEnum());
                property = PropertyBuilder.build((String)type, (String)format, args);
            }
            if (property == null) {
                LOGGER.warn("warning!  Property type \"" + type + "\" not found for parameter \"" + param.getName() + "\", using String");
                property = new StringProperty().description("//TODO automatically added by swagger-codegen.  Type was " + type + " but not supported");
            }
            property.setRequired(param.getRequired());
            CodegenProperty cp = this.fromProperty(qp.getName(), (Property)property);
            this.setParameterBooleanFlagWithCodegenProperty(p, cp);
            String parameterDataType = this.getParameterDataType(param, (Property)property);
            p.dataType = parameterDataType != null ? parameterDataType : cp.datatype;
            p.dataFormat = cp.dataFormat;
            if (cp.isEnum) {
                p.datatypeWithEnum = cp.datatypeWithEnum;
                p.enumName = cp.enumName;
            }
            this.updateCodegenPropertyEnum(cp);
            p.isEnum = cp.isEnum;
            p._enum = cp._enum;
            p.allowableValues = cp.allowableValues;
            if (cp.items != null && cp.items.isEnum) {
                p.datatypeWithEnum = cp.datatypeWithEnum;
                p.enumName = cp.enumName;
                p.items = cp.items;
            }
            p.collectionFormat = collectionFormat;
            if (collectionFormat != null && collectionFormat.equals("multi")) {
                p.isCollectionFormatMulti = true;
            }
            p.paramName = this.toParamName(qp.getName());
            if (cp.complexType != null) {
                imports.add(cp.complexType);
            }
            if ("integer".equals(qp.getType())) {
                p.maximum = qp.getMaximum() == null ? null : String.valueOf(qp.getMaximum().longValue());
                p.minimum = qp.getMinimum() == null ? null : String.valueOf(qp.getMinimum().longValue());
            } else {
                p.maximum = qp.getMaximum() == null ? null : String.valueOf(qp.getMaximum());
                p.minimum = qp.getMinimum() == null ? null : String.valueOf(qp.getMinimum());
            }
            p.exclusiveMaximum = qp.isExclusiveMaximum() == null ? false : qp.isExclusiveMaximum();
            p.exclusiveMinimum = qp.isExclusiveMinimum() == null ? false : qp.isExclusiveMinimum();
            p.maxLength = qp.getMaxLength();
            p.minLength = qp.getMinLength();
            p.pattern = this.toRegularExpression(qp.getPattern());
            p.maxItems = qp.getMaxItems();
            p.minItems = qp.getMinItems();
            p.uniqueItems = qp.isUniqueItems() == null ? false : qp.isUniqueItems();
            p.multipleOf = qp.getMultipleOf();
            if (p.maximum != null || p.minimum != null || p.maxLength != null || p.minLength != null || p.maxItems != null || p.minItems != null || p.pattern != null) {
                p.hasValidation = true;
            }
        } else {
            BodyParameter bp;
            Model model;
            if (!(param instanceof BodyParameter)) {
                LOGGER.error("Cannot use Parameter " + param + " as Body Parameter");
            }
            if ((model = (bp = (BodyParameter)param).getSchema()) instanceof ModelImpl) {
                ModelImpl impl = (ModelImpl)model;
                CodegenModel cm = this.fromModel(bp.getName(), (Model)impl);
                if (!cm.emptyVars) {
                    p.dataType = this.getTypeDeclaration(cm.classname);
                    imports.add(p.dataType);
                } else {
                    Property prop = PropertyBuilder.build((String)impl.getType(), (String)impl.getFormat(), null);
                    prop.setRequired(bp.getRequired());
                    CodegenProperty cp = this.fromProperty("property", prop);
                    if (cp != null) {
                        p.baseType = cp.baseType;
                        p.dataType = cp.datatype;
                        p.isPrimitiveType = cp.isPrimitiveType;
                        p.isBinary = this.isDataTypeBinary(cp.datatype);
                        p.isFile = this.isDataTypeFile(cp.datatype);
                        if (cp.complexType != null) {
                            imports.add(cp.complexType);
                        }
                    }
                    this.setParameterBooleanFlagWithCodegenProperty(p, cp);
                }
            } else if (model instanceof ArrayModel) {
                ArrayModel impl = (ArrayModel)model;
                ArrayProperty ap = new ArrayProperty().items(impl.getItems());
                ap.setRequired(param.getRequired());
                CodegenProperty cp = this.fromProperty("inner", (Property)ap);
                if (cp.complexType != null) {
                    imports.add(cp.complexType);
                }
                imports.add(cp.baseType);
                CodegenProperty innerCp = cp;
                while (innerCp != null) {
                    if (innerCp.complexType != null) {
                        imports.add(innerCp.complexType);
                    }
                    innerCp = innerCp.items;
                }
                p.items = cp;
                p.dataType = cp.datatype;
                p.baseType = cp.complexType;
                p.isPrimitiveType = cp.isPrimitiveType;
                p.isContainer = true;
                p.isListContainer = true;
                this.setParameterBooleanFlagWithCodegenProperty(p, cp);
            } else {
                Model sub = bp.getSchema();
                if (sub instanceof RefModel) {
                    String name = ((RefModel)sub).getSimpleRef();
                    try {
                        name = URLDecoder.decode(name, StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error("Could not decoded string: " + name, (Throwable)e);
                    }
                    name = this.getAlias(name);
                    if (this.typeMapping.containsKey(name)) {
                        p.baseType = name = this.typeMapping.get(name);
                    } else {
                        p.baseType = name = this.toModelName(name);
                        if (this.defaultIncludes.contains(name)) {
                            imports.add(name);
                        }
                        imports.add(name);
                        name = this.getTypeDeclaration(name);
                    }
                    p.dataType = name;
                } else if (sub instanceof ComposedModel) {
                    p.dataType = "object";
                }
            }
            p.paramName = this.toParamName(bp.getName());
        }
        if (param instanceof QueryParameter) {
            p.isQueryParam = true;
        } else if (param instanceof PathParameter) {
            p.required = true;
            p.isPathParam = true;
        } else if (param instanceof HeaderParameter) {
            p.isHeaderParam = true;
        } else if (param instanceof CookieParameter) {
            p.isCookieParam = true;
        } else if (param instanceof BodyParameter) {
            p.isBodyParam = true;
            p.isBinary = this.isDataTypeBinary(p.dataType);
        } else if (param instanceof FormParameter) {
            if ("file".equalsIgnoreCase(((FormParameter)param).getType()) || "file".equals(p.baseType)) {
                p.isFile = true;
            } else {
                p.notFile = true;
            }
            p.isFormParam = true;
        }
        if (p.vendorExtensions != null && p.vendorExtensions.containsKey("x-example")) {
            boolean isObject;
            boolean bl = isObject = "object".equalsIgnoreCase(p.baseType) || "object".equalsIgnoreCase(p.dataType);
            p.example = isObject ? Json.pretty((Object)p.vendorExtensions.get("x-example")) : p.vendorExtensions.get("x-example").toString();
        } else if (Boolean.TRUE.equals(p.isUuid) && Boolean.TRUE.equals(p.isString)) {
            p.example = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
        } else if (Boolean.TRUE.equals(p.isString)) {
            p.example = p.paramName + "_example";
        } else if (Boolean.TRUE.equals(p.isBoolean)) {
            p.example = "true";
        } else if (Boolean.TRUE.equals(p.isLong)) {
            p.example = "789";
        } else if (Boolean.TRUE.equals(p.isInteger)) {
            p.example = "56";
        } else if (Boolean.TRUE.equals(p.isFloat)) {
            p.example = "3.4";
        } else if (Boolean.TRUE.equals(p.isNumber)) {
            p.example = "8.14";
        } else if (Boolean.TRUE.equals(p.isDouble)) {
            p.example = "1.2";
        } else if (Boolean.TRUE.equals(p.isBinary)) {
            p.example = "BINARY_DATA_HERE";
        } else if (Boolean.TRUE.equals(p.isByteArray)) {
            p.example = "B";
        } else if (Boolean.TRUE.equals(p.isFile)) {
            p.example = "/path/to/file.txt";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            p.example = "2013-10-20";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            p.example = "2013-10-20T19:20:30+01:00";
        } else if (Boolean.TRUE.equals(p.isFile)) {
            p.example = "/path/to/file.txt";
        }
        this.setParameterExampleValue(p);
        this.postProcessParameter(p);
        return p;
    }

    protected String getParameterDataType(Parameter parameter, Property property) {
        return null;
    }

    public boolean isDataTypeBinary(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase().startsWith("byte");
        }
        return false;
    }

    public boolean isDataTypeFile(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase().equals("file");
        }
        return false;
    }

    public List<CodegenSecurity> fromSecurity(Map<String, SecuritySchemeDefinition> schemes) {
        if (schemes == null) {
            return Collections.emptyList();
        }
        ArrayList<CodegenSecurity> secs = new ArrayList<CodegenSecurity>(schemes.size());
        for (Map.Entry<String, SecuritySchemeDefinition> entry : schemes.entrySet()) {
            SecuritySchemeDefinition schemeDefinition = entry.getValue();
            CodegenSecurity sec = (CodegenSecurity)CodegenModelFactory.newInstance(CodegenModelType.SECURITY);
            sec.name = entry.getKey();
            sec.type = schemeDefinition.getType();
            sec.isApplication = sec.isImplicit = Boolean.valueOf(false);
            sec.isPassword = sec.isImplicit;
            sec.isCode = sec.isImplicit;
            sec.vendorExtensions = schemeDefinition.getVendorExtensions();
            if (schemeDefinition instanceof ApiKeyAuthDefinition) {
                ApiKeyAuthDefinition apiKeyDefinition = (ApiKeyAuthDefinition)schemeDefinition;
                sec.isBasic = sec.isOAuth = Boolean.valueOf(false);
                sec.isApiKey = true;
                sec.keyParamName = apiKeyDefinition.getName();
                sec.isKeyInHeader = apiKeyDefinition.getIn() == In.HEADER;
                sec.isKeyInQuery = sec.isKeyInHeader == false;
            } else if (schemeDefinition instanceof BasicAuthDefinition) {
                sec.isApiKey = sec.isOAuth = Boolean.valueOf(false);
                sec.isKeyInQuery = sec.isOAuth;
                sec.isKeyInHeader = sec.isOAuth;
                sec.isBasic = true;
            } else {
                OAuth2Definition oauth2Definition = (OAuth2Definition)schemeDefinition;
                sec.isApiKey = sec.isBasic = Boolean.valueOf(false);
                sec.isKeyInQuery = sec.isBasic;
                sec.isKeyInHeader = sec.isBasic;
                sec.isOAuth = true;
                sec.flow = oauth2Definition.getFlow();
                if (sec.flow == null) {
                    throw new RuntimeException("missing oauth flow in " + sec.name);
                }
                switch (sec.flow) {
                    case "accessCode": {
                        sec.isCode = true;
                        break;
                    }
                    case "password": {
                        sec.isPassword = true;
                        break;
                    }
                    case "application": {
                        sec.isApplication = true;
                        break;
                    }
                    case "implicit": {
                        sec.isImplicit = true;
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown oauth flow: " + sec.flow);
                    }
                }
                sec.authorizationUrl = oauth2Definition.getAuthorizationUrl();
                sec.tokenUrl = oauth2Definition.getTokenUrl();
                if (oauth2Definition.getScopes() != null) {
                    ArrayList<Map<String, Object>> scopes = new ArrayList<Map<String, Object>>();
                    int count = 0;
                    int numScopes = oauth2Definition.getScopes().size();
                    for (Map.Entry scopeEntry : oauth2Definition.getScopes().entrySet()) {
                        HashMap scope = new HashMap();
                        scope.put("scope", scopeEntry.getKey());
                        scope.put("description", this.escapeText((String)scopeEntry.getValue()));
                        if (++count < numScopes) {
                            scope.put("hasMore", "true");
                        } else {
                            scope.put("hasMore", null);
                        }
                        scopes.add(scope);
                    }
                    sec.scopes = scopes;
                }
            }
            secs.add(sec);
        }
        Collections.sort(secs, new Comparator<CodegenSecurity>(){

            @Override
            public int compare(CodegenSecurity one, CodegenSecurity another) {
                return ObjectUtils.compare((Comparable)((Object)one.name), (Comparable)((Object)another.name));
            }
        });
        Iterator<Map.Entry<String, Object>> it = secs.iterator();
        while (it.hasNext()) {
            CodegenSecurity security = (CodegenSecurity)((Object)it.next());
            security.hasMore = it.hasNext();
        }
        return secs;
    }

    protected void setReservedWordsLowerCase(List<String> words) {
        this.reservedWords = new HashSet<String>();
        for (String word : words) {
            this.reservedWords.add(word.toLowerCase());
        }
    }

    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word.toLowerCase());
    }

    protected String getOrGenerateOperationId(Operation operation, String path, String httpMethod) {
        String operationId = operation.getOperationId();
        if (StringUtils.isBlank((CharSequence)operationId)) {
            String tmpPath = path;
            tmpPath = tmpPath.replaceAll("\\{", "");
            tmpPath = tmpPath.replaceAll("\\}", "");
            String[] parts = (tmpPath + "/" + httpMethod).split("/");
            StringBuilder builder = new StringBuilder();
            if ("/".equals(tmpPath)) {
                builder.append("root");
            }
            for (String part : parts) {
                if (part.length() <= 0) continue;
                part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : this.initialCaps(part);
                builder.append(part);
            }
            operationId = this.sanitizeName(builder.toString());
            LOGGER.warn("Empty operationId found for path: " + httpMethod + " " + path + ". Renamed to auto-generated operationId: " + operationId);
        }
        return operationId;
    }

    protected boolean needToImport(String type) {
        return StringUtils.isNotBlank((CharSequence)type) && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    protected List<Map<String, Object>> toExamples(Map<String, Object> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(examples.size());
        for (Map.Entry<String, Object> entry : examples.entrySet()) {
            HashMap<String, Object> kv = new HashMap<String, Object>();
            kv.put("contentType", entry.getKey());
            kv.put("example", entry.getValue());
            output.add(kv);
        }
        return output;
    }

    private void addHeaders(Response response, List<CodegenProperty> target) {
        if (response.getHeaders() != null) {
            for (Map.Entry headers : response.getHeaders().entrySet()) {
                target.add(this.fromProperty((String)headers.getKey(), (Property)headers.getValue()));
            }
        }
    }

    private static List<CodegenParameter> addHasMore(List<CodegenParameter> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                if (i > 0) {
                    objs.get((int)i).secondaryParam = true;
                }
                if (i >= objs.size() - 1) continue;
                objs.get((int)i).hasMore = true;
            }
        }
        return objs;
    }

    private static Map<String, Object> addHasMore(Map<String, Object> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size() - 1; ++i) {
                if (i > 0) {
                    objs.put("secondaryParam", true);
                }
                if (i >= objs.size() - 1) continue;
                objs.put("hasMore", true);
            }
        }
        return objs;
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        String uniqueName = co.operationId;
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!uniqueName.equals(op.operationId)) continue;
            uniqueName = co.operationId + "_" + counter;
            ++counter;
        }
        if (!co.operationId.equals(uniqueName)) {
            LOGGER.warn("generated unique operationId `" + uniqueName + "`");
        }
        co.operationId = uniqueName;
        co.operationIdLowerCase = uniqueName.toLowerCase();
        co.operationIdCamelCase = DefaultCodegen.camelize(uniqueName);
        co.operationIdSnakeCase = DefaultCodegen.underscore(uniqueName);
        opList.add(co);
        co.baseName = tag;
    }

    private void addParentContainer(CodegenModel m, String name, Property property) {
        String mappedType;
        m.parentContainer = this.fromProperty(name, property);
        this.addImport(m, m.parentContainer.complexType);
        m.parent = this.toInstantiationType(property);
        String containerType = m.parentContainer.containerType;
        String instantiationType = this.instantiationTypes.get(containerType);
        if (instantiationType != null) {
            this.addImport(m, instantiationType);
        }
        if ((mappedType = this.typeMapping.get(containerType)) != null) {
            this.addImport(m, mappedType);
        }
    }

    public static String underscore(String word) {
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        word = word.replaceAll("\\.", "/");
        word = word.replaceAll("\\$", "__");
        word = word.replaceAll(firstPattern, replacementPattern);
        word = word.replaceAll(secondPattern, replacementPattern);
        word = word.replace('-', '_');
        word = word.replace(' ', '_');
        word = word.toLowerCase();
        return word;
    }

    protected String dashize(String word) {
        return DefaultCodegen.underscore(word).replaceAll("[_ ]", "-");
    }

    private static String generateNextName(String name) {
        Pattern pattern = Pattern.compile("\\d+\\z");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr) + 1;
            return name.substring(0, name.length() - numStr.length()) + num;
        }
        return name + "2";
    }

    protected void addImport(CodegenModel m, String type) {
        if (type != null && this.needToImport(type)) {
            m.imports.add(type);
        }
    }

    private void addVars(CodegenModel m, Map<String, Property> properties, List<String> required, Map<String, Model> allDefinitions) {
        this.addVars(m, properties, required, allDefinitions, null, null);
    }

    private void addVars(CodegenModel m, Map<String, Property> properties, List<String> required, Map<String, Model> allDefinitions, Map<String, Property> allProperties, List<String> allRequired) {
        m.hasRequired = false;
        if (properties != null && !properties.isEmpty()) {
            m.hasVars = true;
            m.hasEnums = false;
            TreeSet<String> mandatory = required == null ? Collections.emptySet() : new TreeSet<String>(required);
            this.addVars(m, m.vars, properties, mandatory, allDefinitions);
            m.mandatory = mandatory;
            m.allMandatory = m.mandatory;
        } else {
            m.emptyVars = true;
            m.hasVars = false;
            m.hasEnums = false;
        }
        if (allProperties != null) {
            TreeSet<String> allMandatory = allRequired == null ? Collections.emptySet() : new TreeSet<String>(allRequired);
            this.addVars(m, m.allVars, allProperties, allMandatory, allDefinitions);
            m.allMandatory = allMandatory;
        }
    }

    private void addVars(CodegenModel m, List<CodegenProperty> vars, Map<String, Property> properties, Set<String> mandatory, Map<String, Model> allDefinitions) {
        ArrayList<Map.Entry<String, Property>> propertyList = new ArrayList<Map.Entry<String, Property>>(properties.entrySet());
        int totalCount = propertyList.size();
        for (int i = 0; i < totalCount; ++i) {
            RefProperty refProperty;
            Model model;
            Map.Entry entry = (Map.Entry)propertyList.get(i);
            String key = (String)entry.getKey();
            Property prop = (Property)entry.getValue();
            if (prop == null) {
                LOGGER.warn("null property for " + key);
                continue;
            }
            CodegenProperty cp = this.fromProperty(key, prop);
            cp.required = mandatory.contains(key);
            m.hasRequired = m.hasRequired || cp.required;
            boolean bl = m.hasOptional = m.hasOptional || !cp.required;
            if (cp.isEnum) {
                m.hasEnums = true;
            }
            if (allDefinitions != null && prop instanceof RefProperty && (model = allDefinitions.get((refProperty = (RefProperty)prop).getSimpleRef())) instanceof ModelImpl) {
                ModelImpl modelImpl = (ModelImpl)model;
                cp.pattern = modelImpl.getPattern();
                cp.minLength = modelImpl.getMinLength();
                cp.maxLength = modelImpl.getMaxLength();
            }
            if (!Boolean.TRUE.equals(cp.isReadOnly)) {
                m.hasOnlyReadOnly = false;
            }
            if (i + 1 != totalCount) {
                cp.hasMore = true;
                if (!Boolean.TRUE.equals(((Property)((Map.Entry)propertyList.get(i + 1)).getValue()).getReadOnly())) {
                    cp.hasMoreNonReadOnly = true;
                }
            }
            if (cp.isContainer) {
                this.addImport(m, this.typeMapping.get("array"));
            }
            this.addImport(m, cp.baseType);
            CodegenProperty innerCp = cp;
            while (innerCp != null) {
                this.addImport(m, innerCp.complexType);
                innerCp = innerCp.items;
            }
            vars.add(cp);
            if (Boolean.TRUE.equals(cp.required)) {
                m.requiredVars.add(cp);
            } else {
                m.optionalVars.add(cp);
            }
            if (Boolean.TRUE.equals(cp.isReadOnly)) {
                m.readOnlyVars.add(cp);
            } else {
                m.readWriteVars.add(cp);
            }
            if (m.discriminator == null || !cp.name.equals(m.discriminator) || !cp.isEnum) continue;
            m.vendorExtensions.put("x-discriminator-is-enum", true);
        }
    }

    private static Map<String, String> getAllAliases(Map<String, Model> allDefinitions) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        if (allDefinitions != null) {
            for (Map.Entry<String, Model> entry : allDefinitions.entrySet()) {
                ModelImpl impl;
                String swaggerName = entry.getKey();
                Model m = entry.getValue();
                if (!(m instanceof ModelImpl) || (impl = (ModelImpl)m).getType() == null || impl.getType().equals("object") || impl.getEnum() != null) continue;
                aliases.put(swaggerName, impl.getType());
            }
        }
        return aliases;
    }

    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-_:;#]");
    }

    protected String removeNonNameElementToCamelCase(String name, String nonNameElementPattern) {
        String result = StringUtils.join((Iterable)Lists.transform((List)Lists.newArrayList((Object[])name.split(nonNameElementPattern)), (Function)new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                return StringUtils.capitalize((String)input);
            }
        }), (String)"");
        if (result.length() > 0) {
            result = result.substring(0, 1).toLowerCase() + result.substring(1);
        }
        return result;
    }

    public static String camelize(String word) {
        return DefaultCodegen.camelize(word, false);
    }

    public static String camelize(String word, boolean lowercaseFirstLetter) {
        Pattern p = Pattern.compile("\\/(.?)");
        Matcher m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher(word);
        }
        String[] parts = word.split("\\.");
        StringBuilder f = new StringBuilder();
        for (String z : parts) {
            if (z.length() <= 0) continue;
            f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
        }
        word = f.toString();
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("" + Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
            m = p.matcher(word);
        }
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher(word);
        if (m.find()) {
            String rep = m.group(1) + m.group(2).toUpperCase() + m.group(3);
            rep = rep.replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll(rep);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher(word);
        while (m.find()) {
            String upperCase;
            String original = m.group(2);
            word = original.equals(upperCase = original.toUpperCase()) ? word.replaceFirst("_", "") : m.replaceFirst(upperCase);
            m = p.matcher(word);
        }
        p = Pattern.compile("(-)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst(m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        if (lowercaseFirstLetter && word.length() > 0) {
            word = word.substring(0, 1).toLowerCase() + word.substring(1);
        }
        return word;
    }

    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + suffix;
    }

    public String apiDocFilename(String templateName, String tag) {
        String suffix = this.apiDocTemplateFiles().get(templateName);
        return this.apiDocFileFolder() + File.separator + this.toApiDocFilename(tag) + suffix;
    }

    public String apiTestFilename(String templateName, String tag) {
        String suffix = this.apiTestTemplateFiles().get(templateName);
        return this.apiTestFileFolder() + File.separator + this.toApiTestFilename(tag) + suffix;
    }

    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }

    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    public void setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
    }

    public void setSkipAliasGeneration(Boolean skipAliasGeneration) {
        this.skipAliasGeneration = skipAliasGeneration;
    }

    public Boolean getSkipAliasGeneration() {
        return this.skipAliasGeneration;
    }

    public boolean isRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    public void setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.removeOperationIdPrefix = removeOperationIdPrefix;
    }

    public boolean isHideGenerationTimestamp() {
        return this.hideGenerationTimestamp;
    }

    public void setHideGenerationTimestamp(boolean hideGenerationTimestamp) {
        this.hideGenerationTimestamp = hideGenerationTimestamp;
    }

    public Map<String, String> supportedLibraries() {
        return this.supportedLibraries;
    }

    public void setLibrary(String library) {
        if (library != null && !this.supportedLibraries.containsKey(library)) {
            StringBuilder sb = new StringBuilder("Unknown library: " + library + "\nAvailable libraries:");
            if (this.supportedLibraries.size() == 0) {
                sb.append("\n  ").append("NONE");
            } else {
                for (String lib : this.supportedLibraries.keySet()) {
                    sb.append("\n  ").append(lib);
                }
            }
            throw new RuntimeException(sb.toString());
        }
        this.library = library;
    }

    public String getLibrary() {
        return this.library;
    }

    public void setGitUserId(String gitUserId) {
        this.gitUserId = gitUserId;
    }

    public String getGitUserId() {
        return this.gitUserId;
    }

    public void setGitRepoId(String gitRepoId) {
        this.gitRepoId = gitRepoId;
    }

    public String getGitRepoId() {
        return this.gitRepoId;
    }

    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    public void setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
    }

    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    protected CliOption buildLibraryCliOption(Map<String, String> supportedLibraries) {
        StringBuilder sb = new StringBuilder("library template (sub-template) to use:");
        for (String lib : supportedLibraries.keySet()) {
            sb.append("\n").append(lib).append(" - ").append(supportedLibraries.get(lib));
        }
        return new CliOption("library", sb.toString());
    }

    public String sanitizeName(String name) {
        if (name == null) {
            LOGGER.error("String to be sanitized is null. Default to ERROR_UNKNOWN");
            return "ERROR_UNKNOWN";
        }
        if ("$".equals(name)) {
            return "value";
        }
        name = name.replaceAll("\\[\\]", "");
        name = name.replaceAll("\\[", "_");
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("\\(", "_");
        name = name.replaceAll("\\)", "");
        name = name.replaceAll("\\.", "_");
        name = name.replaceAll("-", "_");
        name = name.replaceAll(" ", "_");
        name = this.allowUnicodeIdentifiers != false ? Pattern.compile("\\W", 256).matcher(name).replaceAll("") : name.replaceAll("\\W", "");
        return name;
    }

    public String sanitizeTag(String tag) {
        if ((tag = DefaultCodegen.camelize(this.sanitizeName(tag))).matches("^\\d.*")) {
            tag = "Class" + tag;
        }
        return tag;
    }

    public void writeOptional(String outputFolder, SupportingFile supportingFile) {
        String folder = "";
        if (outputFolder != null && !"".equals(outputFolder)) {
            folder = folder + outputFolder + File.separator;
        }
        if (!new File(folder = !"".equals(folder = folder + supportingFile.folder) ? folder + File.separator + supportingFile.destinationFilename : supportingFile.destinationFilename).exists()) {
            this.supportingFiles.add(supportingFile);
        } else {
            LOGGER.info("Skipped overwriting " + supportingFile.destinationFilename + " as the file already exists in " + folder);
        }
    }

    public void setParameterBooleanFlagWithCodegenProperty(CodegenParameter parameter, CodegenProperty property) {
        if (parameter == null) {
            LOGGER.error("Codegen Parameter cannot be null.");
            return;
        }
        if (property == null) {
            LOGGER.error("Codegen Property cannot be null.");
            return;
        }
        if (Boolean.TRUE.equals(property.isUuid) && Boolean.TRUE.equals(property.isString)) {
            parameter.isUuid = true;
        } else if (Boolean.TRUE.equals(property.isByteArray)) {
            parameter.isByteArray = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isString)) {
            parameter.isString = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isBoolean)) {
            parameter.isBoolean = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isLong)) {
            parameter.isLong = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isInteger)) {
            parameter.isInteger = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDouble)) {
            parameter.isDouble = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isFloat)) {
            parameter.isFloat = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isNumber)) {
            parameter.isNumber = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isBinary)) {
            parameter.isByteArray = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isFile)) {
            parameter.isFile = true;
        } else if (Boolean.TRUE.equals(property.isDate)) {
            parameter.isDate = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDateTime)) {
            parameter.isDateTime = true;
            parameter.isPrimitiveType = true;
        } else {
            LOGGER.debug("Property type is not primitive: " + property.datatype);
        }
    }

    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.items != null) {
            allowableValues = var.items.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        ArrayList enumVars = new ArrayList();
        String commonPrefix = this.findCommonPrefixOfVars(values);
        int truncateIdx = commonPrefix.length();
        HashMap<String, Integer> uniqueNames = new HashMap<String, Integer>();
        for (Object value : values) {
            String enumName;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (truncateIdx == 0) {
                enumName = value.toString();
            } else {
                enumName = value.toString().substring(truncateIdx);
                if ("".equals(enumName)) {
                    enumName = value.toString();
                }
            }
            String varName = this.toEnumVarName(enumName, var.datatype);
            hashMap.put("name", this.ensureUniqueName(uniqueNames, varName));
            hashMap.put("value", this.toEnumValue(value.toString(), var.datatype));
            enumVars.add(hashMap);
        }
        allowableValues.put("enumVars", enumVars);
        if (var.defaultValue != null) {
            String enumName = null;
            for (Map map : enumVars) {
                if (!this.toEnumValue(var.defaultValue, var.datatype).equals(map.get("value"))) continue;
                enumName = (String)map.get("name");
                break;
            }
            if (enumName != null) {
                var.defaultValue = this.toEnumDefaultValue(enumName, var.datatypeWithEnum);
            }
        }
    }

    public String addRegularExpressionDelimiter(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("/", "\\\\/") + "/";
        }
        return pattern;
    }

    public boolean convertPropertyToBooleanAndWriteBack(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = this.convertPropertyToBoolean(propertyKey);
            this.writePropertyBack(propertyKey, booleanValue);
        }
        return booleanValue;
    }

    public String getIgnoreFilePathOverride() {
        return this.ignoreFilePathOverride;
    }

    public void setIgnoreFilePathOverride(String ignoreFileOverride) {
        this.ignoreFilePathOverride = ignoreFileOverride;
    }

    public boolean convertPropertyToBoolean(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = Boolean.valueOf(this.additionalProperties.get(propertyKey).toString());
        }
        return booleanValue;
    }

    protected List<Map<String, String>> getExamples(Map<String, Model> definitions, Map<String, Object> examples, List<String> mediaTypes, Object object) {
        if (object instanceof Property) {
            Property responseProperty = (Property)object;
            return new ExampleGenerator(definitions).generate(examples, mediaTypes, responseProperty);
        }
        return new ExampleGenerator(definitions).generate(examples, mediaTypes, object.toString());
    }

    public void writePropertyBack(String propertyKey, boolean value) {
        this.additionalProperties.put(propertyKey, value);
    }

    protected void addOption(String key, String description) {
        this.addOption(key, description, null);
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    protected void addSwitch(String key, String description, Boolean defaultValue) {
        CliOption option = CliOption.newBoolean(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue.toString());
        }
        this.cliOptions.add(option);
    }

    protected void configureDataForTestTemplate(CodegenOperation codegenOperation) {
        String httpMethod = codegenOperation.httpMethod;
        String path = codegenOperation.path;
        if ("GET".equalsIgnoreCase(httpMethod)) {
            codegenOperation.vendorExtensions.put("x-is-get-method", Boolean.TRUE);
        }
        if ("POST".equalsIgnoreCase(httpMethod)) {
            codegenOperation.vendorExtensions.put("x-is-post-method", Boolean.TRUE);
        }
        if ("PUT".equalsIgnoreCase(httpMethod)) {
            codegenOperation.vendorExtensions.put("x-is-put-method", Boolean.TRUE);
        }
        if ("DELETE".equalsIgnoreCase(httpMethod)) {
            codegenOperation.vendorExtensions.put("x-is-delete-method", Boolean.TRUE);
        }
        if ("HEAD".equalsIgnoreCase(httpMethod)) {
            codegenOperation.vendorExtensions.put("x-is-head-method", Boolean.TRUE);
        }
        if ("TRACE".equalsIgnoreCase(httpMethod)) {
            codegenOperation.vendorExtensions.put("x-is-trace-method", Boolean.TRUE);
        }
        if ("PATCH".equalsIgnoreCase(httpMethod)) {
            codegenOperation.vendorExtensions.put("x-is-head-method", Boolean.TRUE);
        }
        if ("OPTIONS".equalsIgnoreCase(httpMethod)) {
            codegenOperation.vendorExtensions.put("x-is-options-method", Boolean.TRUE);
        }
        if (path.contains("{")) {
            while (path.contains("{")) {
                String pathParam = path.substring(path.indexOf("{"), path.indexOf("}") + 1);
                String paramName = pathParam.replace("{", "").replace("}", "");
                CodegenParameter codegenParameter = null;
                for (CodegenParameter parameter : codegenOperation.pathParams) {
                    if (!parameter.baseName.equalsIgnoreCase(paramName)) continue;
                    codegenParameter = parameter;
                    break;
                }
                if (codegenParameter == null || codegenParameter.testExample == null) {
                    return;
                }
                path = path.replace(pathParam, codegenParameter.testExample);
            }
        }
        codegenOperation.testPath = path;
    }

    public boolean getIgnoreImportMapping() {
        return this.ignoreImportMapping;
    }

    public void setIgnoreImportMapping(boolean ignoreImportMapping) {
        this.ignoreImportMapping = ignoreImportMapping;
    }

    public boolean defaultIgnoreImportMappingOption() {
        return false;
    }

    protected boolean isModelObject(ModelImpl model) {
        if ("object".equalsIgnoreCase(model.getType())) {
            return true;
        }
        return ("".equalsIgnoreCase(model.getType()) || model.getType() == null) && model.getProperties() != null && !model.getProperties().isEmpty();
    }
}

