/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractKotlinCodegen;
import io.swagger.codegen.mustache.CamelCaseLambda;
import io.swagger.codegen.mustache.IndentedLambda;
import io.swagger.codegen.mustache.LowercaseLambda;
import io.swagger.codegen.mustache.TitlecaseLambda;
import io.swagger.codegen.mustache.UppercaseLambda;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinServerCodegen
extends AbstractKotlinCodegen {
    public static final String DEFAULT_LIBRARY = "ktor";
    static Logger LOGGER = LoggerFactory.getLogger(KotlinServerCodegen.class);
    private Boolean autoHeadFeatureEnabled = true;
    private Boolean conditionalHeadersFeatureEnabled = false;
    private Boolean hstsFeatureEnabled = true;
    private Boolean corsFeatureEnabled = false;
    private Boolean compressionFeatureEnabled = true;
    private Map<String, List<String>> optionsSupportedPerFramework = new ImmutableMap.Builder().put((Object)"ktor", Arrays.asList("featureAutoHead", "featureConditionalHeaders", "featureHSTS", "featureCORS", "featureCompression")).build();

    public KotlinServerCodegen() {
        this.artifactId = "kotlin-server";
        this.packageName = "io.swagger.server";
        this.outputFolder = "generated-code" + File.separator + "kotlin-server";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.templateDir = "kotlin-server";
        this.embeddedTemplateDir = "kotlin-server";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.supportedLibraries.put(DEFAULT_LIBRARY, "ktor framework");
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault(DEFAULT_LIBRARY);
        library.setEnum(this.supportedLibraries);
        this.cliOptions.add(library);
        this.addSwitch("featureAutoHead", "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.", this.getAutoHeadFeatureEnabled());
        this.addSwitch("featureConditionalHeaders", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getConditionalHeadersFeatureEnabled());
        this.addSwitch("featureHSTS", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getHstsFeatureEnabled());
        this.addSwitch("featureCORS", "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.", this.getCorsFeatureEnabled());
        this.addSwitch("featureCompression", "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.", this.getCompressionFeatureEnabled());
    }

    public Boolean getAutoHeadFeatureEnabled() {
        return this.autoHeadFeatureEnabled;
    }

    public void setAutoHeadFeatureEnabled(Boolean autoHeadFeatureEnabled) {
        this.autoHeadFeatureEnabled = autoHeadFeatureEnabled;
    }

    public Boolean getCompressionFeatureEnabled() {
        return this.compressionFeatureEnabled;
    }

    public void setCompressionFeatureEnabled(Boolean compressionFeatureEnabled) {
        this.compressionFeatureEnabled = compressionFeatureEnabled;
    }

    public Boolean getConditionalHeadersFeatureEnabled() {
        return this.conditionalHeadersFeatureEnabled;
    }

    public void setConditionalHeadersFeatureEnabled(Boolean conditionalHeadersFeatureEnabled) {
        this.conditionalHeadersFeatureEnabled = conditionalHeadersFeatureEnabled;
    }

    public Boolean getCorsFeatureEnabled() {
        return this.corsFeatureEnabled;
    }

    public void setCorsFeatureEnabled(Boolean corsFeatureEnabled) {
        this.corsFeatureEnabled = corsFeatureEnabled;
    }

    @Override
    public String getHelp() {
        return "Generates a kotlin server.";
    }

    public Boolean getHstsFeatureEnabled() {
        return this.hstsFeatureEnabled;
    }

    public void setHstsFeatureEnabled(Boolean hstsFeatureEnabled) {
        this.hstsFeatureEnabled = hstsFeatureEnabled;
    }

    @Override
    public String getName() {
        return "kotlin-server";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        }
        if (this.additionalProperties.containsKey("featureAutoHead")) {
            this.setAutoHeadFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureAutoHead"));
        } else {
            this.additionalProperties.put("featureAutoHead", this.getAutoHeadFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureConditionalHeaders")) {
            this.setConditionalHeadersFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureConditionalHeaders"));
        } else {
            this.additionalProperties.put("featureConditionalHeaders", this.getConditionalHeadersFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureHSTS")) {
            this.setHstsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureHSTS"));
        } else {
            this.additionalProperties.put("featureHSTS", this.getHstsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCORS")) {
            this.setCorsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCORS"));
        } else {
            this.additionalProperties.put("featureCORS", this.getCorsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCompression")) {
            this.setCompressionFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCompression"));
        } else {
            this.additionalProperties.put("featureCompression", this.getCompressionFeatureEnabled());
        }
        Boolean generateApis = this.additionalProperties.containsKey("generateApis") && (Boolean)this.additionalProperties.get("generateApis") != false;
        String packageFolder = (this.sourceFolder + File.separator + this.packageName).replace(".", File.separator);
        String resourcesFolder = "src/main/resources";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("gradle.properties", "", "gradle.properties"));
        this.supportingFiles.add(new SupportingFile("AppMain.kt.mustache", packageFolder, "AppMain.kt"));
        this.supportingFiles.add(new SupportingFile("Configuration.kt.mustache", packageFolder, "Configuration.kt"));
        if (generateApis.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("Paths.kt.mustache", packageFolder, "Paths.kt"));
        }
        this.supportingFiles.add(new SupportingFile("application.conf.mustache", resourcesFolder, "application.conf"));
        this.supportingFiles.add(new SupportingFile("logback.xml", resourcesFolder, "logback.xml"));
        String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("ApiKeyAuth.kt.mustache", infrastructureFolder, "ApiKeyAuth.kt"));
        this.addMustacheLambdas(this.additionalProperties);
    }

    private void addMustacheLambdas(Map<String, Object> objs) {
        ImmutableMap lambdas = new ImmutableMap.Builder().put((Object)"lowercase", (Object)new LowercaseLambda().generator(this)).put((Object)"uppercase", (Object)new UppercaseLambda()).put((Object)"titlecase", (Object)new TitlecaseLambda()).put((Object)"camelcase", (Object)new CamelCaseLambda().generator(this)).put((Object)"indented", (Object)new IndentedLambda()).put((Object)"indented_8", (Object)new IndentedLambda(8, " ")).put((Object)"indented_12", (Object)new IndentedLambda(12, " ")).put((Object)"indented_16", (Object)new IndentedLambda(16, " ")).build();
        if (objs.containsKey("lambda")) {
            LOGGER.warn("An property named 'lambda' already exists. Mustache lambdas renamed from 'lambda' to '_lambda'. You'll likely need to use a custom template, see https://github.com/swagger-api/swagger-codegen#modifying-the-client-library-format. ");
            objs.put("_lambda", lambdas);
        } else {
            objs.put("lambda", lambdas);
        }
    }

    public static class Constants {
        public static final String KTOR = "ktor";
        public static final String AUTOMATIC_HEAD_REQUESTS = "featureAutoHead";
        public static final String AUTOMATIC_HEAD_REQUESTS_DESC = "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.";
        public static final String CONDITIONAL_HEADERS = "featureConditionalHeaders";
        public static final String CONDITIONAL_HEADERS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String HSTS = "featureHSTS";
        public static final String HSTS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String CORS = "featureCORS";
        public static final String CORS_DESC = "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.";
        public static final String COMPRESSION = "featureCompression";
        public static final String COMPRESSION_DESC = "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.";
    }
}

