/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Yaml;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlaskConnexionCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlaskConnexionCodegen.class);
    public static final String CONTROLLER_PACKAGE = "controllerPackage";
    public static final String DEFAULT_CONTROLLER = "defaultController";
    public static final String SUPPORT_PYTHON2 = "supportPython2";
    protected int serverPort = 8080;
    protected String packageName;
    protected String packageVersion;
    protected String controllerPackage;
    protected String defaultController;
    protected Map<Character, String> regexModifiers;

    public FlaskConnexionCodegen() {
        this.modelPackage = "models";
        this.testPackage = "test";
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("List");
        this.languageSpecificPrimitives.add("Dict");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.languageSpecificPrimitives.add("date");
        this.languageSpecificPrimitives.add("file");
        this.languageSpecificPrimitives.add("object");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Dict");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("file", "file");
        this.typeMapping.put("UUID", "str");
        this.setReservedWordsLowerCase(Arrays.asList("property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "None", "True", "False", "nonlocal"));
        this.outputFolder = "generated-code/connexion";
        this.apiTemplateFiles.put("controller.mustache", ".py");
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTestTemplateFiles().put("controller_test.mustache", ".py");
        this.templateDir = "flaskConnexion";
        this.embeddedTemplateDir = "flaskConnexion";
        this.additionalProperties.put("serverPort", this.serverPort);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("setup.mustache", "", "setup.py"));
        this.supportingFiles.add(new SupportingFile("tox.mustache", "", "tox.ini"));
        this.supportingFiles.add(new SupportingFile("test-requirements.mustache", "", "test-requirements.txt"));
        this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("dockerignore.mustache", "", ".dockerignore"));
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("swagger_server"));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(CONTROLLER_PACKAGE, "controller package").defaultValue("controllers"));
        this.cliOptions.add(new CliOption(DEFAULT_CONTROLLER, "default controller").defaultValue("default_controller"));
        this.cliOptions.add(new CliOption(SUPPORT_PYTHON2, "support python2").defaultValue("false"));
        this.cliOptions.add(new CliOption("serverPort", "TCP port to listen to in app.run").defaultValue("8080"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger_server");
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey(CONTROLLER_PACKAGE)) {
            this.controllerPackage = this.additionalProperties.get(CONTROLLER_PACKAGE).toString();
        } else {
            this.controllerPackage = "controllers";
            this.additionalProperties.put(CONTROLLER_PACKAGE, this.controllerPackage);
        }
        if (this.additionalProperties.containsKey(DEFAULT_CONTROLLER)) {
            this.defaultController = this.additionalProperties.get(DEFAULT_CONTROLLER).toString();
        } else {
            this.defaultController = "default_controller";
            this.additionalProperties.put(DEFAULT_CONTROLLER, this.defaultController);
        }
        if (Boolean.TRUE.equals(this.additionalProperties.get(SUPPORT_PYTHON2))) {
            this.additionalProperties.put(SUPPORT_PYTHON2, Boolean.TRUE);
            this.typeMapping.put("long", "long");
        }
        this.supportingFiles.add(new SupportingFile("__init__.mustache", this.packageName, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__main__.mustache", this.packageName, "__main__.py"));
        this.supportingFiles.add(new SupportingFile("encoder.mustache", this.packageName, "encoder.py"));
        this.supportingFiles.add(new SupportingFile("util.mustache", this.packageName, "util.py"));
        this.supportingFiles.add(new SupportingFile("__init__.mustache", this.packageName + File.separatorChar + this.controllerPackage, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", this.packageName + File.separatorChar + this.modelPackage, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("base_model_.mustache", this.packageName + File.separatorChar + this.modelPackage, "base_model_.py"));
        this.supportingFiles.add(new SupportingFile("__init__test.mustache", this.packageName + File.separatorChar + this.testPackage, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("swagger.mustache", this.packageName + File.separatorChar + "swagger", "swagger.yaml"));
        this.modelPackage = this.packageName + "." + this.modelPackage;
        this.controllerPackage = this.packageName + "." + this.controllerPackage;
        this.testPackage = this.packageName + "." + this.testPackage;
    }

    private static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public String apiPackage() {
        return this.controllerPackage;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "python-flask";
    }

    @Override
    public String getHelp() {
        return "Generates a Python server library using the Connexion project. By default, it will also generate service classes -- which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name == null || name.length() == 0) {
            return "DefaultController";
        }
        return FlaskConnexionCodegen.camelize(name, false) + "Controller";
    }

    @Override
    public String toApiFilename(String name) {
        return FlaskConnexionCodegen.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return "test_" + this.toApiFilename(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[str, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(swaggerType);
        }
        return type;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        Map paths = swagger.getPaths();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                Path path = (Path)paths.get(pathname);
                Map operationMap = path.getOperationMap();
                if (operationMap == null) continue;
                for (HttpMethod method : operationMap.keySet()) {
                    String operationId;
                    Operation operation = (Operation)operationMap.get(method);
                    String tag = "default";
                    if (operation.getTags() != null && operation.getTags().size() > 0) {
                        tag = (String)operation.getTags().get(0);
                    }
                    if ((operationId = operation.getOperationId()) == null) {
                        operationId = this.getOrGenerateOperationId(operation, pathname, method.toString());
                    }
                    operation.setOperationId(this.toOperationId(operationId));
                    if (operation.getVendorExtensions().get("x-swagger-router-controller") == null) {
                        operation.getVendorExtensions().put("x-swagger-router-controller", this.controllerPackage + "." + this.toApiFilename(tag));
                    }
                    for (Parameter param : operation.getParameters()) {
                        String name = param.getName();
                        String paramName = this.sanitizeName(name);
                        if (!paramName.equals(name)) {
                            LOGGER.warn(name + " cannot be used as parameter name with flask-connexion and was sanitized as " + paramName);
                        }
                        param.setName(paramName);
                    }
                }
            }
        }
    }

    private static List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            result.add((Map)api.get("operations"));
        }
        return result;
    }

    private static List<Map<String, Object>> sortOperationsByPath(List<CodegenOperation> ops) {
        ArrayListMultimap opsByPath = ArrayListMultimap.create();
        for (CodegenOperation op : ops) {
            opsByPath.put((Object)op.path, (Object)op);
        }
        ArrayList<Map<String, Object>> opsByPathList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : opsByPath.asMap().entrySet()) {
            HashMap<String, Object> opsByPathEntry = new HashMap<String, Object>();
            opsByPathList.add(opsByPathEntry);
            opsByPathEntry.put("path", entry.getKey());
            opsByPathEntry.put("operation", entry.getValue());
            ArrayList operationsForThisPath = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            ((CodegenOperation)operationsForThisPath.get((int)(operationsForThisPath.size() - 1))).hasMore = false;
            if (opsByPathList.size() >= opsByPath.asMap().size()) continue;
            opsByPathEntry.put("hasMore", "true");
        }
        return opsByPathList;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Swagger swagger = (Swagger)objs.get("swagger");
        if (swagger != null) {
            try {
                objs.put("swagger-yaml", Yaml.mapper().writeValueAsString((Object)swagger));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        for (Map<String, Object> operations : FlaskConnexionCodegen.getOperations(objs)) {
            List ops = (List)operations.get("operation");
            List<Map<String, Object>> opsByPathList = FlaskConnexionCodegen.sortOperationsByPath(ops);
            operations.put("operationsByPath", opsByPathList);
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("$", "")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        name = FlaskConnexionCodegen.underscore(name);
        if (this.isReservedWord(name = name.replaceAll("^_*", "")) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return FlaskConnexionCodegen.underscore(FlaskConnexionCodegen.dropDots(this.toModelName(name)));
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + FlaskConnexionCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + FlaskConnexionCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        return FlaskConnexionCodegen.camelize(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + FlaskConnexionCodegen.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return FlaskConnexionCodegen.underscore(this.sanitizeName(operationId));
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getDefault() != null) {
                return "'" + dp.getDefault() + "'";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getDefault() != null) {
                if (dp.getDefault().toString().equalsIgnoreCase("false")) {
                    return "False";
                }
                return "True";
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getDefault() != null) {
                    return dp2.getDefault().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getDefault() != null) {
                    return dp3.getDefault().toString();
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getDefault() != null) {
                    return dp4.getDefault().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getDefault() != null) {
                return dp.getDefault().toString();
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type) || "str".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (p.minimum != null) {
                example = "" + (Integer.valueOf(p.minimum) + 1);
            }
            if (p.maximum != null) {
                example = "" + p.maximum;
            } else if (example == null) {
                example = "56";
            }
        } else if ("Long".equalsIgnoreCase(type)) {
            if (p.minimum != null) {
                example = "" + (Long.valueOf(p.minimum) + 1L);
            }
            if (p.maximum != null) {
                example = "" + p.maximum;
            } else if (example == null) {
                example = "789";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (p.minimum != null) {
                example = "" + p.minimum;
            } else if (p.maximum != null) {
                example = "" + p.maximum;
            } else if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("file".equalsIgnoreCase(type)) {
            example = "(BytesIO(b'some file data'), 'file.txt')";
        } else if ("Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = type + "()";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        if (p.items != null && p.items.defaultValue != null) {
            example = p.items.defaultValue;
        }
        if (example == null) {
            example = "None";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            if (Boolean.TRUE.equals(p.isBodyParam)) {
                example = "[" + example + "]";
            }
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "{'key': " + example + "}";
        }
        p.example = example;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("'''", "'_'_'");
    }

    @Override
    public String toModelImport(String name) {
        String modelImport;
        if (StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"import", "from"})) {
            modelImport = name;
        } else {
            modelImport = "from ";
            if (!"".equals(this.modelPackage())) {
                modelImport = modelImport + this.modelPackage() + ".";
            }
            modelImport = modelImport + this.toModelFilename(name) + " import " + name;
        }
        return modelImport;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (StringUtils.isNotEmpty((CharSequence)property.pattern)) {
            this.addImport(model, "import re");
        }
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }
}

