/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Xml;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private Swagger swagger;
    private boolean skipMatches;
    static Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);
    Map<String, Model> addedModels = new HashMap<String, Model>();
    Map<String, String> generatedSignature = new HashMap<String, String>();

    public void flatten(Swagger swagger) {
        this.swagger = swagger;
        if (swagger.getDefinitions() == null) {
            swagger.setDefinitions(new HashMap());
        }
        Map paths = swagger.getPaths();
        Map models = swagger.getDefinitions();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                Path path = (Path)paths.get(pathname);
                for (Operation operation : path.getOperations()) {
                    Map responses;
                    Parameter parameter2;
                    List parameters = operation.getParameters();
                    if (parameters != null) {
                        for (Parameter parameter2 : parameters) {
                            RefProperty refProperty;
                            ObjectProperty op;
                            ArrayModel am;
                            Property inner;
                            BodyParameter bp;
                            if (!(parameter2 instanceof BodyParameter) || (bp = (BodyParameter)parameter2).getSchema() == null) continue;
                            Model model = bp.getSchema();
                            if (model instanceof ModelImpl) {
                                ModelImpl obj = (ModelImpl)model;
                                if (obj.getType() != null && !"object".equals(obj.getType()) || obj.getProperties() == null || obj.getProperties().size() <= 0) continue;
                                this.flattenProperties(obj.getProperties(), pathname);
                                String modelName = this.resolveModelName(obj.getTitle(), bp.getName());
                                bp.setSchema((Model)new RefModel(modelName));
                                this.addGenerated(modelName, model);
                                swagger.addDefinition(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArrayModel) || !((inner = (am = (ArrayModel)model).getItems()) instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), bp.getName());
                            Model innerModel = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                refProperty = new RefProperty(existing);
                                refProperty.setRequired(op.getRequired());
                                am.setItems((Property)refProperty);
                                continue;
                            }
                            refProperty = new RefProperty(modelName);
                            refProperty.setRequired(op.getRequired());
                            am.setItems((Property)refProperty);
                            this.addGenerated(modelName, innerModel);
                            swagger.addDefinition(modelName, innerModel);
                        }
                    }
                    if ((responses = operation.getResponses()) == null) continue;
                    parameter2 = responses.keySet().iterator();
                    while (parameter2.hasNext()) {
                        MapProperty mp;
                        Property innerProperty;
                        Property refProperty;
                        String existing;
                        Model innerModel;
                        String modelName;
                        ObjectProperty op;
                        String key = (String)parameter2.next();
                        Response response = (Response)responses.get(key);
                        if (response.getSchema() == null) continue;
                        Property property = response.getSchema();
                        if (property instanceof ObjectProperty) {
                            Property refProperty2;
                            ObjectProperty op2 = (ObjectProperty)property;
                            if (op2.getProperties() == null || op2.getProperties().size() <= 0) continue;
                            String modelName2 = this.resolveModelName(op2.getTitle(), "inline_response_" + key);
                            Model model = this.modelFromProperty(op2, modelName2);
                            String existing2 = this.matchGenerated(model);
                            if (existing2 != null) {
                                refProperty2 = this.makeRefProperty(existing2, property);
                                refProperty2.setRequired(op2.getRequired());
                                response.setSchema(refProperty2);
                                continue;
                            }
                            refProperty2 = this.makeRefProperty(modelName2, property);
                            refProperty2.setRequired(op2.getRequired());
                            response.setSchema(refProperty2);
                            this.addGenerated(modelName2, model);
                            swagger.addDefinition(modelName2, model);
                            continue;
                        }
                        if (property instanceof ArrayProperty) {
                            ArrayProperty ap = (ArrayProperty)property;
                            Property inner = ap.getItems();
                            if (!(inner instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key);
                            innerModel = this.modelFromProperty(op, modelName);
                            existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                refProperty = this.makeRefProperty(existing, (Property)op);
                                refProperty.setRequired(op.getRequired());
                                ap.setItems(refProperty);
                                continue;
                            }
                            refProperty = this.makeRefProperty(modelName, (Property)op);
                            refProperty.setRequired(op.getRequired());
                            ap.setItems(refProperty);
                            this.addGenerated(modelName, innerModel);
                            swagger.addDefinition(modelName, innerModel);
                            continue;
                        }
                        if (!(property instanceof MapProperty) || !((innerProperty = (mp = (MapProperty)property).getAdditionalProperties()) instanceof ObjectProperty) || (op = (ObjectProperty)innerProperty).getProperties() == null || op.getProperties().size() <= 0) continue;
                        this.flattenProperties(op.getProperties(), pathname);
                        modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key);
                        innerModel = this.modelFromProperty(op, modelName);
                        existing = this.matchGenerated(innerModel);
                        if (existing != null) {
                            refProperty = new RefProperty(existing);
                            refProperty.setRequired(op.getRequired());
                            mp.setAdditionalProperties(refProperty);
                            continue;
                        }
                        refProperty = new RefProperty(modelName);
                        refProperty.setRequired(op.getRequired());
                        mp.setAdditionalProperties(refProperty);
                        this.addGenerated(modelName, innerModel);
                        swagger.addDefinition(modelName, innerModel);
                    }
                }
            }
        }
        if (models != null) {
            ArrayList modelNames = new ArrayList(models.keySet());
            for (String modelName : modelNames) {
                Map properties;
                ModelImpl m;
                Model model = (Model)models.get(modelName);
                if (model instanceof ModelImpl) {
                    m = (ModelImpl)model;
                    properties = m.getProperties();
                    this.flattenProperties(properties, modelName);
                    this.fixStringModel(m);
                    continue;
                }
                if (model instanceof ArrayModel) {
                    RefProperty refProperty;
                    ObjectProperty op;
                    m = (ArrayModel)model;
                    Property inner = m.getItems();
                    if (!(inner instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                    String innerModelName = this.resolveModelName(op.getTitle(), modelName + "_inner");
                    Model innerModel = this.modelFromProperty(op, innerModelName);
                    String existing = this.matchGenerated(innerModel);
                    if (existing == null) {
                        swagger.addDefinition(innerModelName, innerModel);
                        this.addGenerated(innerModelName, innerModel);
                        refProperty = new RefProperty(innerModelName);
                        refProperty.setRequired(op.getRequired());
                        m.setItems((Property)refProperty);
                        continue;
                    }
                    refProperty = new RefProperty(existing);
                    refProperty.setRequired(op.getRequired());
                    m.setItems((Property)refProperty);
                    continue;
                }
                if (!(model instanceof ComposedModel) || (m = (ComposedModel)model).getChild() == null) continue;
                properties = m.getChild().getProperties();
                this.flattenProperties(properties, modelName);
            }
        }
    }

    private void fixStringModel(ModelImpl m) {
        String example;
        if (m.getType() != null && m.getType().equals("string") && m.getExample() != null && (example = m.getExample().toString()).substring(0, 1).equals("\"") && example.substring(example.length() - 1).equals("\"")) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            return this.uniqueName(key);
        }
        return this.uniqueName(title);
    }

    public String matchGenerated(Model model) {
        if (this.skipMatches) {
            return null;
        }
        String json = Json.pretty((Object)model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    public void addGenerated(String name, Model model) {
        this.generatedSignature.put(Json.pretty((Object)model), name);
    }

    public String uniqueName(String key) {
        int count = 0;
        boolean done = false;
        key = key.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        while (!done) {
            String name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.swagger.getDefinitions() == null) {
                return name;
            }
            if (!this.swagger.getDefinitions().containsKey(name)) {
                return name;
            }
            ++count;
        }
        return key;
    }

    public void flattenProperties(Map<String, Property> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, RefProperty> propsToUpdate = new HashMap<String, RefProperty>();
        HashMap<String, Model> modelsToAdd = new HashMap<String, Model>();
        for (String key : properties.keySet()) {
            MapProperty mp;
            RefProperty refProperty;
            String existing;
            Model innerModel;
            String modelName;
            ObjectProperty op;
            Property inner;
            Property property = properties.get(key);
            if (property instanceof ObjectProperty && ((ObjectProperty)property).getProperties() != null && ((ObjectProperty)property).getProperties().size() > 0) {
                RefProperty refProperty2;
                ObjectProperty op2 = (ObjectProperty)property;
                String modelName2 = this.resolveModelName(op2.getTitle(), path + "_" + key);
                Model model = this.modelFromProperty(op2, modelName2);
                String existing2 = this.matchGenerated(model);
                if (existing2 != null) {
                    refProperty2 = new RefProperty(existing2);
                    refProperty2.setRequired(op2.getRequired());
                    propsToUpdate.put(key, refProperty2);
                    continue;
                }
                refProperty2 = new RefProperty(modelName2);
                refProperty2.setRequired(op2.getRequired());
                propsToUpdate.put(key, refProperty2);
                modelsToAdd.put(modelName2, model);
                this.addGenerated(modelName2, model);
                this.swagger.addDefinition(modelName2, model);
                continue;
            }
            if (property instanceof ArrayProperty) {
                ArrayProperty ap = (ArrayProperty)property;
                inner = ap.getItems();
                if (!(inner instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                this.flattenProperties(op.getProperties(), path);
                modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
                innerModel = this.modelFromProperty(op, modelName);
                existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    refProperty = new RefProperty(existing);
                    refProperty.setRequired(op.getRequired());
                    ap.setItems((Property)refProperty);
                    continue;
                }
                refProperty = new RefProperty(modelName);
                refProperty.setRequired(op.getRequired());
                ap.setItems((Property)refProperty);
                this.addGenerated(modelName, innerModel);
                this.swagger.addDefinition(modelName, innerModel);
                continue;
            }
            if (!(property instanceof MapProperty) || !((inner = (mp = (MapProperty)property).getAdditionalProperties()) instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(op.getProperties(), path);
            modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
            innerModel = this.modelFromProperty(op, modelName);
            existing = this.matchGenerated(innerModel);
            if (existing != null) {
                refProperty = new RefProperty(existing);
                refProperty.setRequired(op.getRequired());
                mp.setAdditionalProperties((Property)refProperty);
                continue;
            }
            refProperty = new RefProperty(modelName);
            refProperty.setRequired(op.getRequired());
            mp.setAdditionalProperties((Property)refProperty);
            this.addGenerated(modelName, innerModel);
            this.swagger.addDefinition(modelName, innerModel);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Property)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.swagger.addDefinition(key, (Model)modelsToAdd.get(key));
            this.addedModels.put(key, (Model)modelsToAdd.get(key));
        }
    }

    public Model modelFromProperty(ArrayProperty object, String path) {
        Property inner;
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        if ((inner = object.getItems()) instanceof ObjectProperty) {
            ArrayModel model = new ArrayModel();
            model.setDescription(description);
            model.setExample((Object)example);
            model.setItems(object.getItems());
            return model;
        }
        return null;
    }

    public Model modelFromProperty(ObjectProperty object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        String name = object.getName();
        Xml xml = object.getXml();
        Map properties = object.getProperties();
        ModelImpl model = new ModelImpl();
        model.setDescription(description);
        model.setExample((Object)example);
        model.setName(name);
        model.setXml(xml);
        if (properties != null) {
            this.flattenProperties(properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    public Model modelFromProperty(MapProperty object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        ArrayModel model = new ArrayModel();
        model.setDescription(description);
        model.setExample((Object)example);
        model.setItems(object.getAdditionalProperties());
        return model;
    }

    public Property makeRefProperty(String ref, Property property) {
        RefProperty newProperty = new RefProperty(ref);
        this.copyVendorExtensions(property, (AbstractProperty)newProperty);
        return newProperty;
    }

    public void copyVendorExtensions(Property source, AbstractProperty target) {
        Map vendorExtensions = source.getVendorExtensions();
        for (String extName : vendorExtensions.keySet()) {
            target.setVendorExtension(extName, vendorExtensions.get(extName));
        }
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }
}

