/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(KotlinClientCodegen.class);
    protected String groupId = "io.swagger";
    protected String artifactId = "kotlin-client";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "src/main/kotlin";
    protected String packageName = "io.swagger.client";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public KotlinClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "kotlin-client";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "kotlin-client";
        this.embeddedTemplateDir = "kotlin-client";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.String", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Map", "kotlin.collections.Set"));
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "as", "break", "case", "catch", "class", "continue", "do", "else", "false", "final", "finally", "for", "fun", "if", "in", "interface", "is", "it", "lazy", "null", "object", "override", "package", "private", "protected", "public", "return", "sealed", "super", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "when", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Set", "kotlin.collections.Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "kotlin.String");
        this.typeMapping.put("boolean", "kotlin.Boolean");
        this.typeMapping.put("integer", "kotlin.Int");
        this.typeMapping.put("float", "kotlin.Float");
        this.typeMapping.put("long", "kotlin.Long");
        this.typeMapping.put("double", "kotlin.Double");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("date-time", "java.time.LocalDateTime");
        this.typeMapping.put("date", "java.time.LocalDateTime");
        this.typeMapping.put("file", "java.io.File");
        this.typeMapping.put("array", "kotlin.Array");
        this.typeMapping.put("list", "kotlin.Array");
        this.typeMapping.put("map", "kotlin.collections.Map");
        this.typeMapping.put("object", "kotlin.Any");
        this.typeMapping.put("binary", "kotlin.Array<kotlin.Byte>");
        this.typeMapping.put("Date", "java.time.LocalDateTime");
        this.typeMapping.put("DateTime", "java.time.LocalDateTime");
        this.instantiationTypes.put("array", "arrayOf");
        this.instantiationTypes.put("list", "arrayOf");
        this.instantiationTypes.put("map", "mapOf");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Client package name (e.g. io.swagger).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("groupId", "Client package's organization (i.e. maven groupId).").defaultValue(this.groupId));
        this.cliOptions.add(new CliOption("artifactId", "Client artifact id (name of generated jar).").defaultValue(this.artifactId));
        this.cliOptions.add(new CliOption("artifactVersion", "Client package version.").defaultValue(this.artifactVersion));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "kotlin";
    }

    @Override
    public String getHelp() {
        return "Generates a kotlin client.";
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            LOGGER.warn("invokerPackage with " + this.getName() + " generator is ignored. Use " + "packageName" + ".");
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            LOGGER.warn("modelPackage with " + this.getName() + " generator is ignored. Setting this value independently of " + "packageName" + " is not currently supported.");
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            LOGGER.warn("apiPackage with " + this.getName() + " generator is ignored. Setting this value independently of " + "packageName" + " is not currently supported.");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", "/");
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiClient.kt.mustache", infrastructureFolder, "ApiClient.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiAbstractions.kt.mustache", infrastructureFolder, "ApiAbstractions.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiInfrastructureResponse.kt.mustache", infrastructureFolder, "ApiInfrastructureResponse.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApplicationDelegates.kt.mustache", infrastructureFolder, "ApplicationDelegates.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/RequestConfig.kt.mustache", infrastructureFolder, "RequestConfig.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/RequestMethod.kt.mustache", infrastructureFolder, "RequestMethod.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ResponseExtensions.kt.mustache", infrastructureFolder, "ResponseExtensions.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/Serializer.kt.mustache", infrastructureFolder, "Serializer.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/Errors.kt.mustache", infrastructureFolder, "Errors.kt"));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toModelName(String name) {
        if (!name.startsWith("kotlin.") && !name.startsWith("java.")) {
            return this.initialCaps(this.modelNamePrefix + name + this.modelNameSuffix);
        }
        return name;
    }

    @Override
    public String getSwaggerType(Property p) {
        String type;
        String swaggerType = super.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<kotlin.String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected boolean needToImport(String type) {
        boolean imports = !type.startsWith("kotlin.") && !type.startsWith("java.") && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
        return imports;
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(name)) {
            return super.toModelImport(name);
        }
        return name;
    }
}

