/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaJAXRSServerCodegen;
import io.swagger.codegen.languages.features.JbossFeature;
import io.swagger.models.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;

public class JavaResteasyServerCodegen
extends AbstractJavaJAXRSServerCodegen
implements JbossFeature {
    protected boolean generateJbossDeploymentDescriptor = true;

    public JavaResteasyServerCodegen() {
        this.artifactId = "swagger-jaxrs-resteasy-server";
        this.outputFolder = "generated-code/JavaJaxRS-Resteasy";
        this.apiTemplateFiles.put("apiService.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceFactory.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.dateLibrary = "legacy";
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "resteasy";
        this.cliOptions.add(CliOption.newBoolean("generateJbossDeploymentDescriptor", "Generate Jboss Deployment Descriptor"));
    }

    @Override
    public String getName() {
        return "jaxrs-resteasy";
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS-Resteasy Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("generateJbossDeploymentDescriptor")) {
            boolean generateJbossDeploymentDescriptorProp = this.convertPropertyToBooleanAndWriteBack("generateJbossDeploymentDescriptor");
            this.setGenerateJbossDeploymentDescriptor(generateJbossDeploymentDescriptorProp);
        }
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("gradle.mustache", "", "build.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("settingsGradle.mustache", "", "settings.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("ApiOriginFilter.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiOriginFilter.java"));
        this.supportingFiles.add(new SupportingFile("ApiResponseMessage.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiResponseMessage.java"));
        this.supportingFiles.add(new SupportingFile("NotFoundException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "NotFoundException.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        if (this.generateJbossDeploymentDescriptor) {
            this.writeOptional(this.outputFolder, new SupportingFile("jboss-web.mustache", "src/main/webapp/WEB-INF", "jboss-web.xml"));
        }
        this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
        this.supportingFiles.add(new SupportingFile("StringUtil.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "StringUtil.java"));
        this.supportingFiles.add(new SupportingFile("JacksonConfig.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "JacksonConfig.java"));
        this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "RFC3339DateFormat.java"));
        if ("joda".equals(this.dateLibrary)) {
            this.supportingFiles.add(new SupportingFile("JodaDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("JodaLocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaLocalDateProvider.java"));
        } else if (this.dateLibrary.startsWith("java8")) {
            this.supportingFiles.add(new SupportingFile("OffsetDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "OffsetDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("LocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "LocalDateProvider.java"));
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                List<CodegenResponse> responses;
                Map<String, String> firstType;
                if (operation.hasConsumes == Boolean.TRUE && (firstType = operation.consumes.get(0)) != null && "multipart/form-data".equals(firstType.get("mediaType"))) {
                    operation.isMultipart = Boolean.TRUE;
                }
                if ((responses = operation.responses) != null) {
                    for (CodegenResponse resp : responses) {
                        if (!"0".equals(resp.code)) continue;
                        resp.code = "200";
                    }
                }
                if (operation.returnType == null) {
                    operation.returnType = "Void";
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    int end2 = rt.lastIndexOf(">");
                    if (end2 <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end2).trim();
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    int end3 = rt.lastIndexOf(">");
                    if (end3 <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end3).split(",")[1].trim();
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end).trim();
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("JsonProperty");
            if (BooleanUtils.toBoolean((Boolean)model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void setGenerateJbossDeploymentDescriptor(boolean generateJbossDeploymentDescriptor) {
        this.generateJbossDeploymentDescriptor = generateJbossDeploymentDescriptor;
    }
}

