/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoServerCodegen.class);
    protected String apiVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "swagger-server";
    protected String apiPath = "go";

    public GoServerCodegen() {
        this.outputFolder = "generated-code/go";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("controller.mustache", ".go");
        this.templateDir = "go-server";
        this.embeddedTemplateDir = "go-server";
        this.setReservedWordsLowerCase(Arrays.asList("break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "ApiResponse", "nil"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "bool", "uint", "uint32", "uint64", "int", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("number", "float32");
        this.typeMapping.put("float", "float32");
        this.typeMapping.put("double", "float64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("date", "time.Time");
        this.typeMapping.put("DateTime", "time.Time");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("File", "*os.File");
        this.typeMapping.put("file", "*os.File");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.importMapping = new HashMap();
        this.importMapping.put("time.Time", "time");
        this.importMapping.put("*os.File", "os");
        this.importMapping.put("os", "io/ioutil");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Go package name (convention: lowercase).").defaultValue("swagger"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "hides the timestamp when files were generated").defaultValue(Boolean.TRUE.toString()));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("serverPort", this.serverPort);
        this.additionalProperties.put("apiPath", this.apiPath);
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "api", "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.go"));
        this.supportingFiles.add(new SupportingFile("routers.mustache", this.apiPath, "routers.go"));
        this.supportingFiles.add(new SupportingFile("logger.mustache", this.apiPath, "logger.go"));
        this.supportingFiles.add(new SupportingFile("app.mustache", this.apiPath, "app.yaml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", this.apiPath, "README.md"));
    }

    @Override
    public String apiPackage() {
        return this.apiPath;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "go-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Go server library using the swagger-tools project.  By default, it will also generate service classes--which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultController";
        }
        return this.initialCaps(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toModelName(String name) {
        return GoServerCodegen.camelize(this.toModelFilename(name));
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + GoServerCodegen.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return GoServerCodegen.camelize(operationId);
    }

    @Override
    public String toModelFilename(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + GoServerCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return GoServerCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return GoServerCodegen.underscore(name);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

