/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FinchServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "io.swagger.client";
    protected String groupId = "io.swagger";
    protected String artifactId = "finch-server";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "src/main/scala";
    protected String packageName = "io.swagger";

    public FinchServerCodegen() {
        this.outputFolder = "generated-code/finch";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "finch";
        this.embeddedTemplateDir = "finch";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield", "abstract", "continue", "switch", "assert", "default", "synchronized", "goto", "break", "double", "implements", "byte", "public", "throws", "enum", "instanceof", "transient", "int", "short", "char", "interface", "static", "void", "finally", "long", "strictfp", "volatile", "const", "float", "native"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "Int", "Long", "Float", "Double", "char", "float", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "List", "Set", "Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("date-time", "LocalDateTime");
        this.typeMapping.put("date", "LocalDateTime");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("array", "Seq");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "Array[Byte]");
        this.typeMapping.put("Date", "LocalDateTime");
        this.typeMapping.put("DateTime", "LocalDateTime");
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("appName", "Swagger Sample");
        this.additionalProperties.put("appDescription", "A sample swagger server");
        this.additionalProperties.put("infoUrl", "http://swagger.io");
        this.additionalProperties.put("infoEmail", "apiteam@swagger.io");
        this.additionalProperties.put("licenseInfo", "Apache 2.0");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("Server.mustache", this.sourceFolder, "Server.scala"));
        this.supportingFiles.add(new SupportingFile("DataAccessor.mustache", this.sourceFolder, "DataAccessor.scala"));
        this.supportingFiles.add(new SupportingFile("project/build.properties", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("project/plugins.sbt", "project", "plugins.sbt"));
        this.supportingFiles.add(new SupportingFile("sbt", "", "sbt"));
        this.supportingFiles.add(new SupportingFile("endpoint.mustache", this.sourceFolder, "endpoint.scala"));
        this.supportingFiles.add(new SupportingFile("errors.mustache", this.sourceFolder, "errors.scala"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "Boolean", "Double", "Int", "Integer", "Long", "Float", "Any", "AnyVal", "AnyRef", "Object"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "scala.collection.immutable.Map");
        this.importMapping.put("HashMap", "scala.collection.immutable.HashMap");
        this.importMapping.put("Seq", "scala.collection.immutable.Seq");
        this.importMapping.put("ArrayBuffer", "scala.collection.mutable.ArrayBuffer");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Finch package name (e.g. io.swagger).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "finch";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala server application with Finch.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        return codegenModel;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase();
            String path = new String(op.path);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            String[] items = path.split("/", -1);
            String scalaPath = "";
            int pathParamIndex = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i].matches("^\\{(.*)\\}$")) {
                    CodegenParameter cp = op.pathParams.get(pathParamIndex);
                    scalaPath = scalaPath + cp.dataType.toLowerCase();
                    ++pathParamIndex;
                } else {
                    scalaPath = scalaPath + "\"" + items[i] + "\"";
                }
                if (i == items.length - 1) continue;
                scalaPath = scalaPath + " :: ";
            }
            for (CodegenParameter p : op.allParams) {
                if (Boolean.TRUE.equals(p.isPrimitiveType)) {
                    p.vendorExtensions.put("x-codegen-normalized-path-type", p.dataType.toLowerCase());
                    p.vendorExtensions.put("x-codegen-normalized-input-type", p.dataType);
                    continue;
                }
                if (Boolean.TRUE.equals(p.isBodyParam)) {
                    p.vendorExtensions.put("x-codegen-normalized-path-type", "jsonBody[" + p.dataType + "]");
                    p.vendorExtensions.put("x-codegen-normalized-input-type", p.dataType);
                    continue;
                }
                if (Boolean.TRUE.equals(p.isContainer) || Boolean.TRUE.equals(p.isListContainer)) {
                    p.vendorExtensions.put("x-codegen-normalized-path-type", "params(\"" + p.paramName + "\")");
                    p.vendorExtensions.put("x-codegen-normalized-input-type", p.dataType.replaceAll("^[^\\[]+", "Seq"));
                    continue;
                }
                if (Boolean.TRUE.equals(p.isFile)) {
                    p.vendorExtensions.put("x-codegen-normalized-path-type", "fileUpload(\"" + p.paramName + "\")");
                    p.vendorExtensions.put("x-codegen-normalized-input-type", "FileUpload");
                    continue;
                }
                p.vendorExtensions.put("x-codegen-normalized-path-type", p.dataType);
                p.vendorExtensions.put("x-codegen-normalized-input-type", p.dataType);
            }
            op.vendorExtensions.put("x-codegen-path", scalaPath);
        }
        return objs;
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

