/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractPhpCodegen;
import io.swagger.models.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ZendExpressivePathHandlerServerCodegen
extends AbstractPhpCodegen {
    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "ze-ph";
    }

    @Override
    public String getHelp() {
        return "Generates PHP server stub using Zend Expressive ( https://zendframework.github.io/zend-expressive ) and Path Handler ( https://github.com/Articus/PathHandler ).";
    }

    public ZendExpressivePathHandlerServerCodegen() {
        this.templateDir = "ze-ph";
        this.embeddedTemplateDir = "ze-ph";
        this.invokerPackage = "App";
        this.packagePath = "";
        this.srcBasePath = "src" + File.separator + "App";
        this.apiDirName = "Handler";
        this.modelDirName = "DTO";
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.supportingFiles.add(new SupportingFile("README.md.mustache", this.packagePath, "README.md"));
        this.supportingFiles.add(new SupportingFile("composer.json.mustache", this.packagePath, "composer.json"));
        this.supportingFiles.add(new SupportingFile("index.php", this.packagePath + File.separator + "public", "index.php"));
        this.supportingFiles.add(new SupportingFile("container.php", this.packagePath + File.separator + "application", "container.php"));
        this.supportingFiles.add(new SupportingFile("config.yml", this.packagePath + File.separator + "application", "config.yml"));
        this.supportingFiles.add(new SupportingFile("app.yml.mustache", this.packagePath + File.separator + "application" + File.separator + "config", "app.yml"));
        this.supportingFiles.add(new SupportingFile("path_handler.yml.mustache", this.packagePath + File.separator + "application" + File.separator + "config", "path_handler.yml"));
        this.supportingFiles.add(new SupportingFile("data_transfer.yml.mustache", this.packagePath + File.separator + "application" + File.separator + "config", "data_transfer.yml"));
        this.supportingFiles.add(new SupportingFile("Date.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Strategy", "Date.php"));
        this.supportingFiles.add(new SupportingFile("DateTime.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Strategy", "DateTime.php"));
        this.supportingFiles.add(new SupportingFile("Type.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Validator", "Type.php"));
        this.supportingFiles.add(new SupportingFile("ErrorMiddleware.php.mustache", this.packagePath + File.separator + this.srcBasePath, "ErrorMiddleware.php"));
        this.additionalProperties.put("artifactVersion", "1.0.0");
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(resourcePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(resourcePath, opList);
        }
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!co.operationId.equals(op.operationId)) continue;
            ++counter;
        }
        if (counter == 0) {
            co.operationIdLowerCase = co.operationId.toLowerCase();
            opList.add(co);
            co.baseName = tag;
        }
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiName(String name) {
        name = name.replaceAll("[\\}]", "");
        return super.toModelName(name);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        objs = super.postProcessOperations(objs);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        StringBuilder interfacesToImplement = new StringBuilder();
        for (CodegenOperation op : operationList) {
            String classMethod;
            String interfaceToImplement;
            switch (op.httpMethod) {
                case "GET": {
                    interfaceToImplement = "Operation\\GetInterface";
                    classMethod = "handleGet";
                    break;
                }
                case "POST": {
                    interfaceToImplement = "Operation\\PostInterface";
                    classMethod = "handlePost";
                    break;
                }
                case "PATCH": {
                    interfaceToImplement = "Operation\\PatchInterface";
                    classMethod = "handlePatch";
                    break;
                }
                case "PUT": {
                    interfaceToImplement = "Operation\\PutInterface";
                    classMethod = "handlePut";
                    break;
                }
                case "DELETE": {
                    interfaceToImplement = "Operation\\DeleteInterface";
                    classMethod = "handleDelete";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown HTTP Method " + op.httpMethod + " not allowed");
                }
            }
            if (interfacesToImplement.length() > 0) {
                interfacesToImplement.append(", ");
            }
            interfacesToImplement.append(interfaceToImplement);
            op.httpMethod = classMethod;
        }
        operations.put("interfacesToImplement", interfacesToImplement.toString());
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs = super.postProcessSupportingFileData(objs);
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        ArrayList<Map<String, Object>> routes = new ArrayList<Map<String, Object>>();
        for (Map api : apis) {
            String handler = (String)api.get("classname");
            String url = (String)api.get("baseName");
            if (url.charAt(0) == '/') {
                url = url.substring(1);
            }
            this.insertRoute(routes, url.split("/"), 0, handler);
        }
        objs.put("routes", routes);
        return objs;
    }

    private void insertRoute(List<Map<String, Object>> routes, String[] urlParts, int currentUrlPartIndex, String handler) {
        if (urlParts.length > currentUrlPartIndex) {
            String urlPart = urlParts[currentUrlPartIndex];
            Map<Object, Object> currentRoute = null;
            for (Map<String, Object> route : routes) {
                if (!urlPart.equals(route.get("name"))) continue;
                currentRoute = route;
                break;
            }
            if (currentRoute == null) {
                currentRoute = new HashMap();
                String routePart = urlPart.replaceAll("^\\{(\\w+)\\}$", ":$1");
                boolean isLastUrlPart = currentUrlPartIndex == urlParts.length - 1;
                currentRoute.put("name", urlPart);
                currentRoute.put("route", "/" + routePart);
                currentRoute.put("type", urlPart == routePart ? "Literal" : "Segment");
                currentRoute.put("handler", isLastUrlPart ? handler : null);
                currentRoute.put("hasChildren", false);
                currentRoute.put("children", new ArrayList());
                currentRoute.put("padding", StringUtils.repeat((char)' ', (int)(4 * currentUrlPartIndex)));
                routes.add(currentRoute);
            }
            List subRoutes = (List)currentRoute.get("children");
            this.insertRoute(subRoutes, urlParts, currentUrlPartIndex + 1, handler);
            currentRoute.put("hasChildren", !subRoutes.isEmpty());
        }
    }
}

